/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.identity.sdk.authentication.dto.AuthCodeDto;
import io.camunda.optimize.service.security.authentication.AbstractAuthenticationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/authentication"})
public class AuthenticationRestService {
    public static final String AUTHENTICATION_PATH = "/authentication";
    public static final String LOGOUT = "/logout";
    public static final String CALLBACK = "/callback";
    private final AbstractAuthenticationService authenticationService;

    public AuthenticationRestService(AbstractAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @GetMapping(path={"/callback"})
    public void loginCallback(@RequestParam(name="code", required=false) String code, @RequestParam(name="state", required=false) String state, @RequestParam(name="error", required=false) String error, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthCodeDto authCode = new AuthCodeDto(code, state, error);
        this.authenticationService.loginCallback(authCode, this.getUri(request), response);
    }

    @GetMapping(path={"/logout"})
    public void logoutUser(HttpServletRequest request, HttpServletResponse response) {
        this.authenticationService.logout(request.getCookies(), response);
    }

    private URI getUri(HttpServletRequest request) {
        try {
            return new URI(request.getRequestURL().toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

