/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.optimize.rest.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.optimize.dto.optimize.query.report.single.result.ResultType;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.dto.optimize.rest.report.measure.MeasureResponseDto;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ReportResultResponseDto<T> {
    private long instanceCount;
    private long instanceCountWithoutFilters;
    private List<MeasureResponseDto<T>> measures = new ArrayList<MeasureResponseDto<T>>();
    private PaginationDto pagination;

    public ReportResultResponseDto(long instanceCount, long instanceCountWithoutFilters, List<MeasureResponseDto<T>> measures, PaginationDto pagination) {
        this.instanceCount = instanceCount;
        this.instanceCountWithoutFilters = instanceCountWithoutFilters;
        this.measures = measures;
        this.pagination = pagination;
    }

    public ReportResultResponseDto() {
    }

    public void addMeasure(MeasureResponseDto<T> measure) {
        this.measures.add(measure);
    }

    @JsonIgnore
    public T getFirstMeasureData() {
        return this.getMeasures().get(0).getData();
    }

    @JsonIgnore
    public T getData() {
        return this.getFirstMeasureData();
    }

    public ResultType getType() {
        return this.getMeasures().stream().findFirst().map(MeasureResponseDto::getType).orElse(null);
    }

    public long getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(long instanceCount) {
        this.instanceCount = instanceCount;
    }

    public long getInstanceCountWithoutFilters() {
        return this.instanceCountWithoutFilters;
    }

    public void setInstanceCountWithoutFilters(long instanceCountWithoutFilters) {
        this.instanceCountWithoutFilters = instanceCountWithoutFilters;
    }

    public List<MeasureResponseDto<T>> getMeasures() {
        return this.measures;
    }

    public void setMeasures(List<MeasureResponseDto<T>> measures) {
        this.measures = measures;
    }

    public PaginationDto getPagination() {
        return this.pagination;
    }

    public void setPagination(PaginationDto pagination) {
        this.pagination = pagination;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportResultResponseDto;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "ReportResultResponseDto(instanceCount=" + this.getInstanceCount() + ", instanceCountWithoutFilters=" + this.getInstanceCountWithoutFilters() + ", measures=" + String.valueOf(this.getMeasures()) + ", pagination=" + String.valueOf(this.getPagination()) + ")";
    }
}

