/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.optimize.query.report;

import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.MeasureDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.ResultType;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class CommandEvaluationResult<T> {
    protected long instanceCount;
    protected long instanceCountWithoutFilters;
    protected List<MeasureDto<T>> measures = new ArrayList<MeasureDto<T>>();
    protected ReportDataDto reportData;
    protected PaginationDto pagination = new PaginationDto(null, null);

    protected CommandEvaluationResult(List<MeasureDto<T>> measures, ReportDataDto reportData) {
        if (measures == null) {
            throw new IllegalArgumentException("measures cannot be null");
        }
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
        this.measures = measures;
        this.reportData = reportData;
    }

    protected CommandEvaluationResult(long instanceCount, long instanceCountWithoutFilters, List<MeasureDto<T>> measures, ReportDataDto reportData) {
        if (measures == null) {
            throw new IllegalArgumentException("measures cannot be null");
        }
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
        this.instanceCount = instanceCount;
        this.instanceCountWithoutFilters = instanceCountWithoutFilters;
        this.measures = measures;
        this.reportData = reportData;
    }

    public CommandEvaluationResult(ReportDataDto reportData) {
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
        this.reportData = reportData;
    }

    public CommandEvaluationResult(long instanceCount, long instanceCountWithoutFilters, List<MeasureDto<T>> measures, ReportDataDto reportData, PaginationDto pagination) {
        if (measures == null) {
            throw new IllegalArgumentException("measures cannot be null");
        }
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
        if (pagination == null) {
            throw new IllegalArgumentException("pagination cannot be null");
        }
        this.instanceCount = instanceCount;
        this.instanceCountWithoutFilters = instanceCountWithoutFilters;
        this.measures = measures;
        this.reportData = reportData;
        this.pagination = pagination;
    }

    public CommandEvaluationResult() {
    }

    public <R extends ReportDataDto> R getReportDataAs(Class<R> reportDataType) {
        return (R)((ReportDataDto)reportDataType.cast(this.reportData));
    }

    public T getFirstMeasureData() {
        return this.measures.stream().findFirst().map(MeasureDto::getData).orElse(null);
    }

    public void addMeasure(MeasureDto<T> measureDto) {
        this.measures.add(measureDto);
    }

    public abstract List<String[]> getResultAsCsv(Integer var1, Integer var2, ZoneId var3);

    public abstract ResultType getType();

    public T getResult() {
        return this.getFirstMeasureData();
    }

    protected String getGroupByIdentifier(SingleReportDataDto reportData) {
        if (reportData instanceof ProcessReportDataDto) {
            return ((ProcessReportDataDto)reportData).getGroupBy().toString();
        }
        return ((DecisionReportDataDto)reportData).getGroupBy().toString();
    }

    protected String getViewIdentifier(SingleReportDataDto reportData) {
        if (reportData instanceof ProcessReportDataDto) {
            return ((ProcessReportDataDto)reportData).getView().createCommandKey().replace("-", "_");
        }
        return ((DecisionReportDataDto)reportData).getView().createCommandKey().replace("-", "_");
    }

    public long getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(long instanceCount) {
        this.instanceCount = instanceCount;
    }

    public long getInstanceCountWithoutFilters() {
        return this.instanceCountWithoutFilters;
    }

    public void setInstanceCountWithoutFilters(long instanceCountWithoutFilters) {
        this.instanceCountWithoutFilters = instanceCountWithoutFilters;
    }

    public List<MeasureDto<T>> getMeasures() {
        return this.measures;
    }

    public void setMeasures(List<MeasureDto<T>> measures) {
        if (measures == null) {
            throw new IllegalArgumentException("measures cannot be null");
        }
        this.measures = measures;
    }

    public ReportDataDto getReportData() {
        return this.reportData;
    }

    public void setReportData(ReportDataDto reportData) {
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
        this.reportData = reportData;
    }

    public PaginationDto getPagination() {
        return this.pagination;
    }

    public void setPagination(PaginationDto pagination) {
        if (pagination == null) {
            throw new IllegalArgumentException("pagination cannot be null");
        }
        this.pagination = pagination;
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandEvaluationResult;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "CommandEvaluationResult(instanceCount=" + this.getInstanceCount() + ", instanceCountWithoutFilters=" + this.getInstanceCountWithoutFilters() + ", measures=" + String.valueOf(this.getMeasures()) + ", reportData=" + String.valueOf(this.getReportData()) + ", pagination=" + String.valueOf(this.getPagination()) + ")";
    }
}

