/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.optimize.query.definition;

import io.camunda.optimize.dto.optimize.SimpleDefinitionDto;
import io.camunda.optimize.dto.optimize.TenantDto;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DefinitionVersionWithTenantsDto
extends SimpleDefinitionDto {
    private String version;
    private String versionTag;
    private List<TenantDto> tenants;

    public DefinitionVersionWithTenantsDto(String version, String versionTag, List<TenantDto> tenants) {
        if (version == null) {
            throw new IllegalArgumentException("version cannot be null");
        }
        if (tenants == null) {
            throw new IllegalArgumentException("tenants cannot be null");
        }
        this.version = version;
        this.versionTag = versionTag;
        this.tenants = tenants;
    }

    protected DefinitionVersionWithTenantsDto() {
    }

    public void sort() {
        this.tenants.sort(Comparator.comparing(TenantDto::getId, Comparator.nullsFirst(Comparator.naturalOrder())));
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version cannot be null");
        }
        this.version = version;
    }

    public String getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    public List<TenantDto> getTenants() {
        return this.tenants;
    }

    public void setTenants(List<TenantDto> tenants) {
        if (tenants == null) {
            throw new IllegalArgumentException("tenants cannot be null");
        }
        this.tenants = tenants;
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefinitionVersionWithTenantsDto;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "DefinitionVersionWithTenantsDto(version=" + this.getVersion() + ", versionTag=" + this.getVersionTag() + ", tenants=" + String.valueOf(this.getTenants()) + ")";
    }
}

