/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.util;

import io.camunda.optimize.dto.optimize.ReportConstants;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.rest.optimize.dto.VariableDto;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class VariableTestUtil {
    private VariableTestUtil() {
    }

    public static Map<String, Object> createAllPrimitiveTypeVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        boolean integer = true;
        variables.put("stringVar", "aStringValue");
        variables.put("boolVar", true);
        variables.put("integerVar", 1);
        variables.put("shortVar", (short)1);
        variables.put("longVar", 1L);
        variables.put("doubleVar", 1.1);
        variables.put("dateVar", new Date());
        return variables;
    }

    public static Map<String, Object> createAllPrimitiveVariableTypesWithNullValues() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (VariableType type : ReportConstants.ALL_PRIMITIVE_PROCESS_VARIABLE_TYPES) {
            String varName = String.format("%sVar", type.getId().toLowerCase(Locale.ENGLISH));
            VariableDto variableDto = new VariableDto();
            variableDto.setType(type.getId());
            variableDto.setValue(null);
            variables.put(varName, variableDto);
        }
        return variables;
    }
}

