/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.it.extension.db;

import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.ValueCountAggregate;
import co.elastic.clients.elasticsearch._types.mapping.DynamicMapping;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.cluster.PutClusterSettingsRequest;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.CountResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.AliasDefinition;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.ExistsTemplateRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasResponse;
import co.elastic.clients.elasticsearch.indices.GetIndexRequest;
import co.elastic.clients.elasticsearch.indices.GetMappingRequest;
import co.elastic.clients.elasticsearch.indices.GetMappingResponse;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.PutIndicesSettingsRequest;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.elasticsearch.indices.get.Feature;
import co.elastic.clients.elasticsearch.indices.get_alias.IndexAliases;
import co.elastic.clients.elasticsearch.indices.get_mapping.IndexMappingRecord;
import co.elastic.clients.elasticsearch.snapshot.CreateRepositoryRequest;
import co.elastic.clients.elasticsearch.snapshot.CreateSnapshotRequest;
import co.elastic.clients.elasticsearch.snapshot.DeleteRepositoryRequest;
import co.elastic.clients.elasticsearch.snapshot.DeleteSnapshotRequest;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import io.camunda.optimize.ApplicationContextProvider;
import io.camunda.optimize.dto.optimize.OptimizeDto;
import io.camunda.optimize.dto.optimize.index.TimestampBasedImportIndexDto;
import io.camunda.optimize.dto.optimize.query.MetadataDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeCountRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeDeleteRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeGetRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexOperationBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.es.schema.ElasticSearchIndexSettingsBuilder;
import io.camunda.optimize.service.db.es.schema.ElasticSearchMetadataService;
import io.camunda.optimize.service.db.es.schema.ElasticSearchSchemaManager;
import io.camunda.optimize.service.db.es.schema.index.ExternalProcessVariableIndexES;
import io.camunda.optimize.service.db.es.schema.index.ProcessInstanceIndexES;
import io.camunda.optimize.service.db.es.schema.index.TerminatedUserSessionIndexES;
import io.camunda.optimize.service.db.es.schema.index.VariableUpdateInstanceIndexES;
import io.camunda.optimize.service.db.es.schema.index.report.SingleProcessReportIndexES;
import io.camunda.optimize.service.db.schema.DatabaseSchemaManager;
import io.camunda.optimize.service.db.schema.DefaultIndexMappingCreator;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.db.schema.ScriptData;
import io.camunda.optimize.service.db.schema.index.VariableUpdateInstanceIndex;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.DatabaseHelper;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.DatabaseType;
import io.camunda.optimize.service.util.configuration.elasticsearch.DatabaseConnectionNodeConfiguration;
import io.camunda.optimize.service.util.mapper.ObjectMapperFactory;
import io.camunda.optimize.test.it.extension.IntegrationTestConfigurationUtil;
import io.camunda.optimize.test.it.extension.db.DatabaseTestService;
import io.camunda.optimize.test.it.extension.db.TermsQueryContainer;
import io.camunda.optimize.test.repository.TestIndexRepositoryES;
import io.camunda.optimize.test.util.DurationAggregationUtil;
import io.camunda.optimize.upgrade.es.ElasticsearchClientBuilder;
import io.camunda.search.connect.plugin.PluginRepository;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.tika.utils.StringUtils;
import org.elasticsearch.client.Request;
import org.mockserver.integration.ClientAndServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchDatabaseTestService
extends DatabaseTestService {
    private static final String MOCKSERVER_CLIENT_KEY = "MockServer";
    private static final Map<String, OptimizeElasticsearchClient> CLIENT_CACHE = new HashMap<String, OptimizeElasticsearchClient>();
    private static final ClientAndServer MOCK_SERVER_CLIENT = ElasticsearchDatabaseTestService.initMockServer();
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchDatabaseTestService.class);
    private String elasticsearchDatabaseVersion;
    private OptimizeElasticsearchClient optimizeElasticsearchClient;

    public ElasticsearchDatabaseTestService(String customIndexPrefix, boolean haveToClean) {
        super(customIndexPrefix, haveToClean);
        this.initEsClient();
        this.setTestIndexRepository(new TestIndexRepositoryES(this.optimizeElasticsearchClient));
    }

    private static ClientAndServer initMockServer() {
        return DatabaseTestService.initMockServer(IntegrationTestConfigurationUtil.createItConfigurationService().getElasticSearchConfiguration().getFirstConnectionNode());
    }

    @Override
    public void beforeEach() {
        if (this.haveToClean) {
            LOG.info("Cleaning database...");
            this.cleanAndVerifyDatabase();
            LOG.info("All documents have been wiped out! Database has successfully been cleaned!");
        }
    }

    @Override
    public void afterEach() {
        if (this.optimizeElasticsearchClient == CLIENT_CACHE.get(MOCKSERVER_CLIENT_KEY)) {
            LOG.info("Resetting all MockServer expectations and logs");
            MOCK_SERVER_CLIENT.reset();
            LOG.info("No longer using ES MockServer");
            this.initEsClient();
        }
    }

    @Override
    public ClientAndServer useDBMockServer() {
        LOG.info("Using ElasticSearch MockServer");
        if (CLIENT_CACHE.containsKey(MOCKSERVER_CLIENT_KEY)) {
            this.optimizeElasticsearchClient = CLIENT_CACHE.get(MOCKSERVER_CLIENT_KEY);
        } else {
            ConfigurationService configurationService = this.createConfigurationService();
            DatabaseConnectionNodeConfiguration esConfig = configurationService.getElasticSearchConfiguration().getFirstConnectionNode();
            esConfig.setHost("localhost");
            esConfig.setHttpPort(MOCK_SERVER_CLIENT.getLocalPort());
            this.createClientAndAddToCache(MOCKSERVER_CLIENT_KEY, configurationService);
        }
        return MOCK_SERVER_CLIENT;
    }

    @Override
    public void refreshAllOptimizeIndices() {
        try {
            this.getOptimizeElasticClient().getEsClient().indices().refresh(RefreshRequest.of(r -> r.index(this.getIndexNameService().getIndexPrefix() + "*", new String[0]).allowNoIndices(Boolean.valueOf(true)).ignoreUnavailable(Boolean.valueOf(true)).expandWildcards(ExpandWildcard.Open, new ExpandWildcard[0])));
        }
        catch (Exception e) {
            throw new OptimizeIntegrationTestException("Could not refresh Optimize indices!", e);
        }
    }

    @Override
    public void addEntryToDatabase(String indexName, String id, Object entry) {
        try {
            this.getOptimizeElasticClient().index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.getOptimizeElasticClient(), indexName).id(id).document(entry).refresh(Refresh.True)));
        }
        catch (IOException e) {
            throw new OptimizeIntegrationTestException("Unable to add an entry to elasticsearch", e);
        }
    }

    @Override
    public void addEntriesToDatabase(String indexName, Map<String, Object> idToEntryMap) {
        StreamSupport.stream(Iterables.partition(idToEntryMap.entrySet(), (int)10000).spliterator(), false).forEach(batch -> {
            BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
            for (Map.Entry idAndObject : batch) {
                bulkRequest.operations(o -> o.index(OptimizeIndexOperationBuilderES.of(i -> ((IndexOperation.Builder)i.optimizeIndex(this.getOptimizeElasticClient(), indexName).id((String)idAndObject.getKey())).document(idAndObject.getValue()))));
            }
            this.executeBulk(bulkRequest.build());
        });
    }

    @Override
    public <T> List<T> getAllDocumentsOfIndexAs(String indexName, Class<T> type) {
        return this.getAllDocumentsOfIndexAs(indexName, type, Query.of(q -> q.matchAll(m -> m)));
    }

    @Override
    public DatabaseClient getDatabaseClient() {
        return this.optimizeElasticsearchClient;
    }

    @Override
    public Integer getDocumentCountOf(String indexName) {
        try {
            CountResponse countResponse = this.getOptimizeElasticClient().count(OptimizeCountRequestBuilderES.of(c -> c.optimizeIndex(this.getOptimizeElasticClient(), indexName).query(Query.of(q -> q.matchAll(m -> m)))));
            return Long.valueOf(countResponse.count()).intValue();
        }
        catch (ElasticsearchException | IOException e) {
            throw new OptimizeIntegrationTestException("Cannot evaluate document count for index " + indexName, (Exception)e);
        }
    }

    @Override
    public void deleteAllOptimizeData() {
        try {
            this.getOptimizeElasticClient().getEsClient().deleteByQuery(DeleteByQueryRequest.of(d -> d.index(this.getIndexNameService().getIndexPrefix() + "*", new String[0]).query(Query.of(q -> q.matchAll(m -> m))).refresh(Boolean.valueOf(true))));
        }
        catch (IOException e) {
            throw new OptimizeIntegrationTestException("Could not delete all Optimize data", e);
        }
    }

    @Override
    public void deleteAllIndicesContainingTerm(String indexTerm) {
        String[] indicesToDelete;
        try {
            indicesToDelete = (String[])this.getOptimizeElasticClient().getAllIndexNames().stream().filter(index -> index.contains(indexTerm)).toArray(String[]::new);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        if (indicesToDelete.length > 0) {
            this.getOptimizeElasticClient().deleteIndexByRawIndexNames(indicesToDelete);
        }
    }

    @Override
    public void deleteAllSingleProcessReports() {
        try {
            this.getOptimizeElasticClient().getEsClient().deleteByQuery(DeleteByQueryRequest.of(d -> d.index(this.getIndexNameService().getOptimizeIndexAliasForIndex((IndexMappingCreator)new SingleProcessReportIndexES()), new String[0]).query(Query.of(q -> q.matchAll(m -> m))).refresh(Boolean.valueOf(true))));
        }
        catch (ElasticsearchException | IOException e) {
            throw new OptimizeIntegrationTestException("Could not delete data in index " + this.getIndexNameService().getOptimizeIndexAliasForIndex((IndexMappingCreator)new SingleProcessReportIndexES()), (Exception)e);
        }
    }

    @Override
    public void deleteTerminatedSessionsIndex() {
        this.deleteIndexOfMapping((IndexMappingCreator<IndexSettings.Builder>)new TerminatedUserSessionIndexES());
    }

    @Override
    public void deleteAllVariableUpdateInstanceIndices() {
        String[] indexNames = (String[])this.getOptimizeElasticClient().getAllIndicesForAlias(this.getIndexNameService().getOptimizeIndexAliasForIndex((IndexMappingCreator)new VariableUpdateInstanceIndexES())).toArray(String[]::new);
        this.getOptimizeElasticClient().deleteIndexByRawIndexNames(indexNames);
    }

    @Override
    public void deleteAllExternalVariableIndices() {
        String[] indexNames = (String[])this.getOptimizeElasticClient().getAllIndicesForAlias(this.getIndexNameService().getOptimizeIndexAliasForIndex((IndexMappingCreator)new ExternalProcessVariableIndexES())).toArray(String[]::new);
        this.getOptimizeElasticClient().deleteIndexByRawIndexNames(indexNames);
    }

    @Override
    public void deleteAllZeebeRecordsForPrefix(String zeebeRecordPrefix) {
        String[] indicesToDelete;
        try {
            indicesToDelete = (String[])this.getOptimizeElasticClient().getEsClient().indices().get(GetIndexRequest.of(r -> r.index(zeebeRecordPrefix + "*", new String[0]))).result().keySet().toArray(String[]::new);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        if (indicesToDelete.length > 1) {
            this.getOptimizeElasticClient().deleteIndexByRawIndexNames(indicesToDelete);
        }
    }

    @Override
    public void deleteAllOtherZeebeRecordsWithPrefix(String zeebeRecordPrefix, String recordsToKeep) {
        String[] indicesToDelete;
        try {
            indicesToDelete = (String[])this.getOptimizeElasticClient().elasticsearchClient().indices().get(GetIndexRequest.of(r -> r.index(zeebeRecordPrefix + "*", new String[0]))).result().keySet().stream().filter(indexName -> !indexName.contains(recordsToKeep)).toArray(String[]::new);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        if (indicesToDelete.length > 1) {
            this.getOptimizeElasticClient().deleteIndexByRawIndexNames(indicesToDelete);
        }
    }

    @Override
    public void updateZeebeRecordsForPrefix(String zeebeRecordPrefix, String indexName, String updateScript) {
        try {
            this.getOptimizeElasticClient().getEsClient().updateByQuery(UpdateByQueryRequest.of(u -> u.index(zeebeRecordPrefix + "_" + indexName + "*", new String[0]).refresh(Boolean.valueOf(true)).script(Script.of(s -> s.inline(i -> i.lang(ScriptLanguage.Painless).source(updateScript)))).query(Query.of(q -> q.matchAll(m -> m)))));
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public void updateZeebeRecordsWithPositionForPrefix(String zeebeRecordPrefix, String indexName, long position, String updateScript) {
        try {
            this.getOptimizeElasticClient().getEsClient().updateByQuery(UpdateByQueryRequest.of(u -> u.index(zeebeRecordPrefix + "_" + indexName + "*", new String[0]).refresh(Boolean.valueOf(true)).script(Script.of(s -> s.inline(i -> i.lang(ScriptLanguage.Painless).source(updateScript)))).query(Query.of(q -> q.bool(b -> b.must(m -> m.term(t -> t.field("position").value(position))))))));
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public void updateZeebeRecordsOfBpmnElementTypeForPrefix(String zeebeRecordPrefix, BpmnElementType bpmnElementType, String updateScript) {
        try {
            this.getOptimizeElasticClient().getEsClient().updateByQuery(UpdateByQueryRequest.of(u -> u.index(zeebeRecordPrefix + "_process-instance*", new String[0]).refresh(Boolean.valueOf(true)).script(Script.of(s -> s.inline(i -> i.lang(ScriptLanguage.Painless).source(updateScript)))).query(Query.of(q -> q.bool(b -> b.must(m -> m.term(t -> t.field("value.bpmnElementType").value(bpmnElementType.name()))))))));
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public void updateUserTaskDurations(String processInstanceId, String processDefinitionKey, long duration) {
        String updateScript = this.buildUpdateScript(duration);
        try {
            this.getOptimizeElasticClient().update(OptimizeUpdateRequestBuilderES.of(u -> u.optimizeIndex(this.getOptimizeElasticClient(), new String[]{InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)}).id(processInstanceId).script(Script.of(s -> s.inline(i -> i.lang(ScriptLanguage.Painless).source(updateScript)))).retryOnConflict(Integer.valueOf(5))), Object.class);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean indexExistsCheckWithApplyingOptimizePrefix(String indexOrAliasName) {
        return this.indexExists(indexOrAliasName, false);
    }

    @Override
    public boolean indexExistsCheckWithoutApplyingOptimizePrefix(String indexName) {
        OptimizeElasticsearchClient esClient = this.getOptimizeElasticClient();
        try {
            return esClient.getEsClient().indices().exists(ExistsRequest.of(r -> r.index(indexName, new String[0]))).value();
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public OffsetDateTime getLastImportTimestampOfTimestampBasedImportIndex(String dbType, String engine) {
        GetResponse response;
        try {
            response = this.optimizeElasticsearchClient.get(OptimizeGetRequestBuilderES.of(r -> r.optimizeIndex(this.optimizeElasticsearchClient, "timestamp-based-import-index").id(DatabaseHelper.constructKey((String)dbType, (String)engine))), TimestampBasedImportIndexDto.class);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        if (response.found()) {
            return ((TimestampBasedImportIndexDto)response.source()).getTimestampOfLastEntity();
        }
        throw new NotFoundException(String.format("Timestamp based import index does not exist: esType: {%s}, engine: {%s}", dbType, engine));
    }

    @Override
    public Map<AggregationDto, Double> calculateExpectedValueGivenDurations(Number ... setDuration) {
        return DurationAggregationUtil.calculateExpectedValueGivenDurationsWithPercentileInterpolation(setDuration);
    }

    @Override
    public long countRecordsByQuery(TermsQueryContainer termsQueryContainer, String expectedIndex) {
        return this.countRecordsByQuery(termsQueryContainer.toElasticSearchQuery(), expectedIndex);
    }

    @Override
    public <T> List<T> getZeebeExportedRecordsByQuery(String exportIndex, TermsQueryContainer query, Class<T> zeebeRecordClass) {
        SearchResponse searchResponse;
        OptimizeElasticsearchClient esClient = this.getOptimizeElasticClient();
        Query boolQueryBuilder = query.toElasticSearchQuery();
        try {
            searchResponse = esClient.searchWithoutPrefixing(SearchRequest.of(s -> s.index(exportIndex, new String[0]).query(boolQueryBuilder).trackTotalHits(t -> t.enabled(Boolean.valueOf(true))).size(Integer.valueOf(100))), zeebeRecordClass);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits((HitsMetadata)searchResponse.hits(), zeebeRecordClass, (ObjectMapper)ObjectMapperFactory.OPTIMIZE_MAPPER);
    }

    @Override
    public void deleteProcessInstancesFromIndex(String indexName, String id) {
        DeleteRequest request = OptimizeDeleteRequestBuilderES.of(d -> d.optimizeIndex(this.getOptimizeElasticClient(), indexName).id(id).refresh(Refresh.True));
        try {
            this.getOptimizeElasticClient().delete(request);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public DatabaseType getDatabaseVendor() {
        return DatabaseType.ELASTICSEARCH;
    }

    @Override
    public void createSnapshot(String snapshotRepositoryName, String snapshotName, String[] indexNames) {
        CreateSnapshotRequest createSnapshotRequest = CreateSnapshotRequest.of(b -> b.repository(snapshotRepositoryName).snapshot(snapshotName).indices(Arrays.stream(indexNames).toList()).includeGlobalState(Boolean.valueOf(false)).waitForCompletion(Boolean.valueOf(true)));
        try {
            this.getOptimizeElasticClient().triggerSnapshotAsync(createSnapshotRequest).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new OptimizeRuntimeException("Exception during creation snapshot:", (Throwable)e);
        }
    }

    @Override
    public void createRepoSnapshot(String snapshotRepositoryName) {
        try {
            this.getOptimizeElasticClient().getEsClient().snapshot().createRepository(CreateRepositoryRequest.of(b -> b.name(snapshotRepositoryName).repository(r -> r.fs(s -> s.settings(t -> t.location("/var/tmp"))))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cleanSnapshots(String snapshotRepositoryName) {
        try {
            this.getOptimizeElasticClient().getEsClient().snapshot().delete(DeleteSnapshotRequest.of(b -> b.repository(snapshotRepositoryName).snapshot("*")));
            this.getOptimizeElasticClient().getEsClient().snapshot().deleteRepository(DeleteRepositoryRequest.of(b -> b.name(snapshotRepositoryName, new String[0])));
        }
        catch (Exception e) {
            LOG.warn("Delete failed, no snapshots to delete from repository {}", (Object)snapshotRepositoryName);
        }
    }

    @Override
    public List<String> getImportIndices() {
        return ElasticSearchSchemaManager.getAllNonDynamicMappings().stream().filter(IndexMappingCreator::isImportIndex).map(IndexMappingCreator::getIndexName).toList();
    }

    @Override
    protected <T extends OptimizeDto> List<T> getInstancesById(String indexName, List<String> instanceIds, String idField, Class<T> type) {
        SearchResponse searchResponse;
        ArrayList<OptimizeDto> results = new ArrayList<OptimizeDto>();
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.getOptimizeElasticClient(), new String[]{indexName}).query(Query.of(q -> q.terms(t -> t.field(idField).terms(tt -> tt.value(instanceIds.stream().map(FieldValue::of).toList()))))).trackTotalHits(t -> t.enabled(Boolean.valueOf(true))).size(Integer.valueOf(100)));
        try {
            searchResponse = this.getOptimizeElasticClient().search(searchRequest, type);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        for (Hit hit : searchResponse.hits().hits()) {
            results.add((OptimizeDto)hit.source());
        }
        return results;
    }

    @Override
    public <T> Optional<T> getDatabaseEntryById(String indexName, String entryId, Class<T> type) {
        GetResponse getResponse;
        GetRequest getRequest = OptimizeGetRequestBuilderES.of(r -> r.optimizeIndex(this.getOptimizeElasticClient(), indexName).id(entryId));
        try {
            getResponse = this.getOptimizeElasticClient().get(getRequest, type);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        if (getResponse.found()) {
            return Optional.of(getResponse.source());
        }
        return Optional.empty();
    }

    @Override
    public String getDatabaseVersion() {
        if (this.elasticsearchDatabaseVersion == null) {
            this.elasticsearchDatabaseVersion = this.getOptimizeElasticClient().getDatabaseVersion();
        }
        return this.elasticsearchDatabaseVersion;
    }

    @Override
    public int getNestedDocumentsLimit(ConfigurationService configurationService) {
        return configurationService.getElasticSearchConfiguration().getNestedDocumentsLimit();
    }

    @Override
    public void setNestedDocumentsLimit(ConfigurationService configurationService, int nestedDocumentsLimit) {
        configurationService.getElasticSearchConfiguration().setNestedDocumentsLimit(nestedDocumentsLimit);
    }

    @Override
    public void updateProcessInstanceNestedDocLimit(String processDefinitionKey, int nestedDocLimit, ConfigurationService configurationService) {
        this.setNestedDocumentsLimit(configurationService, nestedDocLimit);
        OptimizeElasticsearchClient esClient = this.getOptimizeElasticClient();
        String indexName = esClient.getIndexNameService().getOptimizeIndexNameWithVersionForAllIndicesOf((IndexMappingCreator)new ProcessInstanceIndexES(processDefinitionKey));
        try {
            esClient.elasticsearchClient().indices().putSettings(PutIndicesSettingsRequest.of(p -> p.index(indexName, new String[0]).settings(ElasticSearchIndexSettingsBuilder.buildDynamicSettings((ConfigurationService)configurationService))));
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public void createIndex(String optimizeIndexNameWithVersion, String optimizeIndexAliasForIndex) throws IOException {
        CreateIndexRequest request = CreateIndexRequest.of(i -> {
            i.index(optimizeIndexNameWithVersion);
            if (!StringUtils.isBlank((String)optimizeIndexAliasForIndex)) {
                i.aliases(optimizeIndexAliasForIndex, Alias.of(a -> a.isWriteIndex(Boolean.valueOf(true))));
            }
            return i;
        });
        this.getOptimizeElasticClient().elasticsearchClient().indices().create(request);
    }

    @Override
    public void createIndex(String indexName, Map<String, Boolean> aliases, DefaultIndexMappingCreator indexMapping) throws IOException {
        IndexSettings indexSettings = this.createIndexSettings((IndexMappingCreator)indexMapping, this.createConfigurationService());
        CreateIndexRequest.Builder request = new CreateIndexRequest.Builder();
        request.index(DatabaseClient.convertToPrefixedAliasName((String)indexName, (DatabaseClient)this.getOptimizeElasticClient()));
        for (Map.Entry<String, Boolean> alias : aliases.entrySet()) {
            request.aliases(alias.getKey(), Alias.of(a -> a.isWriteIndex((Boolean)alias.getValue())));
        }
        request.settings(indexSettings);
        request.mappings(indexMapping.getSource());
        indexMapping.setDynamic(DynamicMapping.False);
        this.getOptimizeElasticClient().elasticsearchClient().indices().create(request.build());
    }

    @Override
    public Optional<MetadataDto> readMetadata() {
        return ((ElasticSearchMetadataService)ApplicationContextProvider.getBean(ElasticSearchMetadataService.class)).readMetadata(this.getOptimizeElasticClient());
    }

    @Override
    public void setActivityStartDatesToNull(String processDefinitionKey, ScriptData scriptData) {
        UpdateByQueryRequest.Builder request = new UpdateByQueryRequest.Builder().conflicts(Conflicts.Proceed).query(Query.of(q -> q.matchAll(m -> m))).script(Script.of(s -> s.inline(i -> (ObjectBuilder)i.lang(ScriptLanguage.Painless).source(scriptData.scriptString()).params(scriptData.params().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JsonData.of(e.getValue()))))))).refresh(Boolean.valueOf(true));
        try {
            this.getOptimizeElasticClient().updateByQuery(request, List.of(InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)));
        }
        catch (IOException e) {
            throw new OptimizeIntegrationTestException("Could not set activity start dates to null.", e);
        }
    }

    @Override
    public void setUserTaskDurationToNull(String processInstanceId, String durationFieldName, ScriptData script) {
        UpdateByQueryRequest.Builder request = new UpdateByQueryRequest.Builder().conflicts(Conflicts.Proceed).query(Query.of(q -> q.bool(b -> b.must(m -> m.term(t -> t.field("processInstanceId").value(processInstanceId)))))).script(Script.of(s -> s.inline(i -> (ObjectBuilder)i.lang(ScriptLanguage.Painless).source(script.scriptString()).params(script.params().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JsonData.of(e.getValue()))))))).refresh(Boolean.valueOf(true));
        try {
            this.getOptimizeElasticClient().updateByQuery(request, List.of("process-instance"));
        }
        catch (IOException e) {
            throw new OptimizeIntegrationTestException(String.format("Could not set userTask duration field [%s] to null.", durationFieldName), e);
        }
    }

    @Override
    public Long getImportedActivityCount() {
        SearchResponse response;
        try {
            response = this.getOptimizeElasticClient().search(OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.getOptimizeElasticClient(), new String[]{"process-instance"}).query(q -> q.matchAll(m -> m)).size(Integer.valueOf(0)).source(ss -> ss.fetch(Boolean.valueOf(false))).aggregations("flowNodeInstances", Aggregation.of(a -> a.nested(n -> n.path("flowNodeInstances")).aggregations("flowNodeInstances_frequency", Aggregation.of(aa -> aa.valueCount(c -> (ObjectBuilder)c.field("flowNodeInstances.flowNodeInstanceId"))))))), Object.class);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        NestedAggregate nested = ((Aggregate)response.aggregations().get("flowNodeInstances")).nested();
        ValueCountAggregate countAggregator = ((Aggregate)nested.aggregations().get("flowNodeInstances_frequency")).valueCount();
        return Double.valueOf(countAggregator.value()).longValue();
    }

    @Override
    public List<String> getAllIndicesWithWriteAlias(String aliasNameWithPrefix) {
        Map indexNameToAliasMap;
        GetAliasRequest aliasesRequest = GetAliasRequest.of(a -> a.index(this.getOptimizeElasticClient().addPrefixesToIndices(new String[]{aliasNameWithPrefix})));
        try {
            indexNameToAliasMap = this.getOptimizeElasticClient().getAlias(aliasesRequest).result();
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        return indexNameToAliasMap.keySet().stream().filter(index -> ((IndexAliases)indexNameToAliasMap.get(index)).aliases().entrySet().stream().anyMatch(a -> ((AliasDefinition)a.getValue()).isWriteIndex())).toList();
    }

    @Override
    public VariableUpdateInstanceIndex getVariableUpdateInstanceIndex() {
        return new VariableUpdateInstanceIndexES();
    }

    @Override
    public void deleteAllDocumentsInIndex(String optimizeIndexAliasForIndex) {
        try {
            this.getOptimizeElasticClient().elasticsearchClient().deleteByQuery(DeleteByQueryRequest.of(r -> r.index(DatabaseClient.convertToPrefixedAliasName((String)optimizeIndexAliasForIndex, (DatabaseClient)this.getOptimizeElasticClient()), new String[0]).query(q -> q.matchAll(m -> m)).refresh(Boolean.valueOf(true))));
        }
        catch (ElasticsearchException | IOException e) {
            throw new OptimizeIntegrationTestException("Could not delete data in index " + optimizeIndexAliasForIndex, (Exception)e);
        }
    }

    @Override
    public void insertTestDocuments(int amount, String indexName, String jsonDocument) throws IOException {
        this.getOptimizeElasticClient().bulk(BulkRequest.of(r -> {
            int i = 0;
            while (i < amount) {
                int finalI = i++;
                r.operations(o -> o.index(OptimizeIndexOperationBuilderES.of(b -> b.optimizeIndex(this.getOptimizeElasticClient(), indexName).document((Object)JsonData.fromJson((String)String.format(jsonDocument, finalI))))));
            }
            return r;
        }));
        this.getOptimizeElasticClient().refresh(indexName);
    }

    @Override
    public void performLowLevelBulkRequest(String methodName, String endpoint, String bulkPayload) throws IOException {
        NStringEntity entity = new NStringEntity(bulkPayload, ContentType.APPLICATION_JSON);
        Request request = new Request(methodName, endpoint);
        request.setEntity((HttpEntity)entity);
        this.getOptimizeElasticClient().performRequest(request);
    }

    @Override
    public void initSchema(DatabaseSchemaManager schemaManager) {
        schemaManager.initializeSchema((DatabaseClient)this.getOptimizeElasticClient());
    }

    @Override
    public Map<String, ? extends Object> getMappingFields(String indexName) throws IOException {
        GetMappingResponse getMappingResponse = this.getOptimizeElasticClient().getMapping(new GetMappingRequest.Builder(), new String[]{indexName});
        Map propertiesMap = ((IndexMappingRecord)getMappingResponse.result().values().stream().findFirst().orElseThrow(() -> new OptimizeRuntimeException("There should be at least one mapping available for the index!"))).mappings().properties();
        if (propertiesMap instanceof Map) {
            return propertiesMap;
        }
        throw new OptimizeRuntimeException("ElasticSearch index mapping properties should be of type map");
    }

    @Override
    public boolean indexExists(String indexOrAliasName, Boolean addMappingFeatures) {
        GetIndexRequest.Builder request = new GetIndexRequest.Builder();
        request.index(this.getOptimizeElasticClient().addPrefixesToIndices(new String[]{indexOrAliasName}));
        if (addMappingFeatures.booleanValue()) {
            request.features(Feature.Mappings, new Feature[0]);
        }
        try {
            return this.getOptimizeElasticClient().exists(request.build());
        }
        catch (IOException e) {
            String message = String.format("Could not check if [%s] index already exist.", String.join((CharSequence)",", indexOrAliasName));
            throw new OptimizeRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public boolean templateExists(String optimizeIndexTemplateNameWithVersion) throws IOException {
        return this.getOptimizeElasticClient().elasticsearchClient().indices().existsTemplate(ExistsTemplateRequest.of(e -> e.name(optimizeIndexTemplateNameWithVersion, new String[0]))).value();
    }

    @Override
    public boolean isAliasReadOnly(String readOnlyAliasForIndex) throws IOException {
        GetAliasResponse aliases = this.getOptimizeElasticClient().getAlias(GetAliasRequest.of(a -> a.name(this.getOptimizeElasticClient().addPrefixesToIndices(new String[]{readOnlyAliasForIndex}))));
        return aliases.result().values().stream().flatMap(a -> a.aliases().values().stream()).collect(Collectors.toSet()).stream().noneMatch(AliasDefinition::isWriteIndex);
    }

    @Override
    public List<String> getAllIndicesWithReadOnlyAlias(String aliasNameWithPrefix) {
        Map indexNameToAliasMap;
        GetAliasRequest aliasesRequest = GetAliasRequest.of(a -> a.index(this.getOptimizeElasticClient().addPrefixesToIndices(new String[]{aliasNameWithPrefix})));
        try {
            indexNameToAliasMap = this.getOptimizeElasticClient().getAlias(aliasesRequest).result();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return indexNameToAliasMap.keySet().stream().filter(index -> ((IndexAliases)indexNameToAliasMap.get(index)).aliases().entrySet().stream().anyMatch(alias -> Boolean.FALSE.equals(((AliasDefinition)alias.getValue()).isWriteIndex()))).toList();
    }

    @Override
    public String[] getIndexNames() {
        return (String[])ElasticSearchSchemaManager.getAllNonDynamicMappings().stream().filter(IndexMappingCreator::isImportIndex).map(arg_0 -> ((OptimizeIndexNameService)this.getIndexNameService()).getOptimizeIndexAliasForIndex(arg_0)).toArray(String[]::new);
    }

    public OptimizeIndexNameService getIndexNameService() {
        return this.getOptimizeElasticClient().getIndexNameService();
    }

    public OptimizeElasticsearchClient getOptimizeElasticClient() {
        return this.optimizeElasticsearchClient;
    }

    private long countRecordsByQuery(Query boolQueryBuilder, String expectedIndex) {
        OptimizeElasticsearchClient esClient = this.getOptimizeElasticClient();
        CountRequest countRequest = CountRequest.of(c -> c.index(expectedIndex, new String[0]).query(boolQueryBuilder));
        try {
            return esClient.elasticsearchClient().count(countRequest).count();
        }
        catch (IOException e) {
            throw new OptimizeIntegrationTestException(e);
        }
    }

    private void initEsClient() {
        if (CLIENT_CACHE.containsKey(this.customIndexPrefix)) {
            this.optimizeElasticsearchClient = CLIENT_CACHE.get(this.customIndexPrefix);
        } else {
            this.createClientAndAddToCache(this.customIndexPrefix, this.createConfigurationService());
        }
    }

    private void createClientAndAddToCache(String clientKey, ConfigurationService configurationService) {
        DatabaseConnectionNodeConfiguration esConfig = configurationService.getElasticSearchConfiguration().getFirstConnectionNode();
        LOG.info("Creating ES Client with host {} and port {}", (Object)esConfig.getHost(), (Object)esConfig.getHttpPort());
        this.optimizeElasticsearchClient = new OptimizeElasticsearchClient(ElasticsearchClientBuilder.restClient((ConfigurationService)configurationService, (PluginRepository)new PluginRepository()), ObjectMapperFactory.OPTIMIZE_MAPPER, ElasticsearchClientBuilder.build((ConfigurationService)configurationService, (ObjectMapper)ObjectMapperFactory.OPTIMIZE_MAPPER, (PluginRepository)new PluginRepository()), new OptimizeIndexNameService(configurationService, DatabaseType.ELASTICSEARCH));
        this.adjustClusterSettings();
        CLIENT_CACHE.put(clientKey, this.optimizeElasticsearchClient);
    }

    private ConfigurationService createConfigurationService() {
        ConfigurationService configurationService = IntegrationTestConfigurationUtil.createItConfigurationService();
        if (this.customIndexPrefix != null) {
            configurationService.getElasticSearchConfiguration().setIndexPrefix(configurationService.getElasticSearchConfiguration().getIndexPrefix() + this.customIndexPrefix);
        }
        return configurationService;
    }

    private void adjustClusterSettings() {
        PutClusterSettingsRequest clusterUpdateSettingsRequest = PutClusterSettingsRequest.of(p -> p.persistent("action.auto_create_index", JsonData.of((Object)true)).persistent("cluster.max_shards_per_node", JsonData.of((Object)10000)).flatSettings(Boolean.valueOf(true)));
        try {
            this.optimizeElasticsearchClient.elasticsearchClient().cluster().putSettings(clusterUpdateSettingsRequest);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Could not update cluster settings!", (Throwable)e);
        }
    }

    private void executeBulk(BulkRequest bulkRequest) {
        try {
            this.getOptimizeElasticClient().bulk(bulkRequest);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    private <T> List<T> getAllDocumentsOfIndexAs(String indexName, Class<T> type, Query query) {
        try {
            return this.getAllDocumentsOfIndicesAs(new String[]{indexName}, type, query);
        }
        catch (ElasticsearchException e) {
            throw new OptimizeIntegrationTestException("Cannot get all documents for index " + indexName, (Exception)((Object)e));
        }
    }

    private <T> List<T> getAllDocumentsOfIndicesAs(String[] indexNames, Class<T> type, Query query) {
        SearchResponse response;
        ArrayList results = new ArrayList();
        Map<String, List<String>> groupedByPrefix = Arrays.stream(indexNames).collect(Collectors.groupingBy(name -> name.startsWith("zeebe-record") ? "ZeebeIndex" : "OptimizeIndex"));
        if (groupedByPrefix.containsKey("ZeebeIndex")) {
            try {
                response = this.getOptimizeElasticClient().searchWithoutPrefixing(SearchRequest.of(s -> s.index(List.of(indexNames)).query(query).trackTotalHits(t -> t.enabled(Boolean.valueOf(true))).size(Integer.valueOf(100))), type);
            }
            catch (IOException e) {
                throw new OptimizeRuntimeException((Throwable)e);
            }
            results.addAll(ElasticsearchReaderUtil.mapHits((HitsMetadata)response.hits(), type, (ObjectMapper)this.getObjectMapper()));
        }
        if (groupedByPrefix.containsKey("OptimizeIndex")) {
            try {
                response = this.getOptimizeElasticClient().search(OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.getOptimizeElasticClient(), indexNames).query(query).trackTotalHits(t -> t.enabled(Boolean.valueOf(true))).size(Integer.valueOf(100))), type);
            }
            catch (IOException e) {
                throw new OptimizeRuntimeException((Throwable)e);
            }
            results.addAll(ElasticsearchReaderUtil.mapHits((HitsMetadata)response.hits(), type, (ObjectMapper)this.getObjectMapper()));
        }
        return results;
    }

    private void deleteIndexOfMapping(IndexMappingCreator<IndexSettings.Builder> indexMapping) {
        this.getOptimizeElasticClient().deleteIndex(indexMapping);
    }

    private IndexSettings createIndexSettings(IndexMappingCreator indexMappingCreator, ConfigurationService configurationService) {
        try {
            return ElasticSearchIndexSettingsBuilder.buildAllSettings((ConfigurationService)configurationService, (IndexMappingCreator)indexMappingCreator);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Could not create index settings");
        }
    }
}

