/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.util.DecisionVariableHelper;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class DecisionVariableHelperTest {
    @Test
    void shouldGetVariableValueFieldReturnCorrectFieldPath() {
        String variablePath = "testPath";
        String result = DecisionVariableHelper.getVariableValueField((String)"testPath");
        Assertions.assertThat((String)result).isEqualTo("testPath.value");
    }

    @Test
    void shouldGetVariableMultivalueFieldsReturnUnmodifiableList() {
        List result = DecisionVariableHelper.getVariableMultivalueFields();
        ((ListAssert)Assertions.assertThat((List)result).containsExactly((Object[])new VariableType[]{VariableType.DATE, VariableType.DOUBLE, VariableType.LONG})).isUnmodifiable();
    }

    @Test
    void shouldGetVariableStringValueFieldReturnCorrectStringValueField() {
        String variablePath = "testPath";
        String result = DecisionVariableHelper.getVariableStringValueField((String)"testPath");
        Assertions.assertThat((String)result).isEqualTo("testPath.value");
    }

    @Test
    void shouldGetValueSearchFieldReturnSearchFieldPath() {
        String variablePath = "testPath";
        String searchFieldName = "field";
        String result = DecisionVariableHelper.getValueSearchField((String)"testPath", (String)"field");
        Assertions.assertThat((String)result).isEqualTo("testPath.value.field");
    }

    @Test
    void shouldBuildWildcardQueryReturnWildcardString() {
        String valueFilter = "query";
        String result = DecisionVariableHelper.buildWildcardQuery((String)"query");
        Assertions.assertThat((String)result).isEqualTo("*query*");
    }

    @Test
    void shouldGetVariableValueFieldForTypeHandleStringType() {
        String variablePath = "testPath";
        VariableType type = VariableType.STRING;
        String result = DecisionVariableHelper.getVariableValueFieldForType((String)"testPath", (VariableType)type);
        Assertions.assertThat((String)result).isEqualTo("testPath.value");
    }

    @Test
    void shouldGetVariableValueFieldForTypeHandleDateType() {
        String variablePath = "testPath";
        VariableType type = VariableType.DATE;
        String result = DecisionVariableHelper.getVariableValueFieldForType((String)"testPath", (VariableType)type);
        Assertions.assertThat((String)result).isEqualTo("testPath.value.date");
    }

    @Test
    void shouldGetVariableValueFieldForTypeThrowExceptionForNullType() {
        String variablePath = "testPath";
        VariableType type = null;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DecisionVariableHelper.getVariableValueFieldForType((String)"testPath", (VariableType)type)).isInstanceOf(IllegalArgumentException.class)).hasMessage("No Type provided");
    }

    @Test
    void shouldGetVariableClauseIdFieldReturnCorrectFieldPath() {
        String variablePath = "testPath";
        String result = DecisionVariableHelper.getVariableClauseIdField((String)"testPath");
        Assertions.assertThat((String)result).isEqualTo("testPath.clauseId");
    }

    @Test
    void shouldGetVariableTypeFieldReturnCorrectFieldPath() {
        String variablePath = "testPath";
        String result = DecisionVariableHelper.getVariableTypeField((String)"testPath");
        Assertions.assertThat((String)result).isEqualTo("testPath.type");
    }
}

