/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.service.util.DateFormatterUtil;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class DateFormatterUtilTest {
    @ParameterizedTest
    @MethodSource(value={"getDateStringsAndValidityExpectations"})
    public void checkValidityOfDateFormatStrings(String dateString, boolean expectedValidity) {
        boolean isValidFormat = DateFormatterUtil.isValidOptimizeDateFormat((String)dateString);
        Assertions.assertThat((boolean)isValidFormat).isEqualTo(expectedValidity);
    }

    @ParameterizedTest
    @MethodSource(value={"getDateStringsAndExpectedConversionOutput"})
    public void attemptConversionToOptimizeFormattedDates(String dateStringInput, Optional<String> expectedOutput) {
        Optional convertedString = DateFormatterUtil.getDateStringInOptimizeDateFormat((String)dateStringInput);
        Assertions.assertThat((Optional)convertedString).isEqualTo(expectedOutput);
    }

    private static Stream<Arguments> getDateStringsAndValidityExpectations() {
        return Stream.of(Arguments.of((Object[])new Object[]{"10/12/2020", false}), Arguments.of((Object[])new Object[]{"10-12-2020", false}), Arguments.of((Object[])new Object[]{"2020-07-01", false}), Arguments.of((Object[])new Object[]{"10/12/2020+03:00", false}), Arguments.of((Object[])new Object[]{"2020-07-16T10:14:22.761421", false}), Arguments.of((Object[])new Object[]{"2019-06-15T12:00:00.000+02:00", false}), Arguments.of((Object[])new Object[]{"2019-06-15T12:00:00.000+0200", true}), Arguments.of((Object[])new Object[]{"SOME-NON-PARSEABLE_DATE", false}));
    }

    private static Stream<Arguments> getDateStringsAndExpectedConversionOutput() {
        return Stream.of(Arguments.of((Object[])new Object[]{"10/12/2020", Optional.of("2020-12-10T00:00:00.000+0000")}), Arguments.of((Object[])new Object[]{"10-12-2020", Optional.of("2020-12-10T00:00:00.000+0000")}), Arguments.of((Object[])new Object[]{"2020-07-01", Optional.of("2020-07-01T00:00:00.000+0000")}), Arguments.of((Object[])new Object[]{"10/12/2020+03:00", Optional.of("2020-12-10T03:00:00.000+0000")}), Arguments.of((Object[])new Object[]{"2020-07-16T10:14:22.761421", Optional.of("2020-07-16T10:14:22.761+0000")}), Arguments.of((Object[])new Object[]{"2019-06-15T12:00:00.000+02:00", Optional.of("2019-06-15T12:00:00.000+0200")}), Arguments.of((Object[])new Object[]{"2019-06-15T12:00:00.000+0200", Optional.of("2019-06-15T12:00:00.000+0200")}), Arguments.of((Object[])new Object[]{"SOME-NON-PARSEABLE_DATE", Optional.empty()}));
    }
}

