/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security;

import com.google.common.collect.ImmutableList;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.Authentication;
import io.camunda.identity.sdk.authentication.UserDetails;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.rest.exceptions.NotAuthorizedException;
import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.security.CCSMTokenService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class CCSMTokenServiceTest {
    private static final String ACCESS_TOKEN_VALUE = "accessToken";
    private static final String OPTIMIZE_PERMISSION = "write:*";
    private static final String EMAIL = "user@example.com";
    private static final String ID = "user123";
    private static final String NAME = "name";
    private static final String USERNAME = "username";
    @Mock
    private AuthCookieService authCookieService;
    @Mock
    private ConfigurationService configurationService;
    @Mock
    private Identity identity;
    @Mock
    private Authentication authentication;
    @Mock
    private AccessToken accessToken;
    @Mock
    private UserDetails userDetails;
    private CCSMTokenService ccsmTokenService;

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.identity.authentication()).thenReturn((Object)this.authentication);
        Mockito.when((Object)this.authentication.verifyToken(ACCESS_TOKEN_VALUE)).thenReturn((Object)this.accessToken);
        Mockito.when((Object)this.accessToken.getPermissions()).thenReturn((Object)ImmutableList.of((Object)OPTIMIZE_PERMISSION));
        this.ccsmTokenService = new CCSMTokenService(this.authCookieService, this.configurationService, this.identity);
    }

    @Test
    void getUserInfoFromTokenValidTokenReturnsUserDto() {
        Mockito.when((Object)this.accessToken.getUserDetails()).thenReturn((Object)this.userDetails);
        Mockito.when((Object)this.userDetails.getName()).thenReturn(Optional.of(NAME));
        Mockito.when((Object)this.userDetails.getEmail()).thenReturn(Optional.of(EMAIL));
        UserDto result = this.ccsmTokenService.getUserInfoFromToken(ID, ACCESS_TOKEN_VALUE);
        Assertions.assertEquals((Object)ID, (Object)result.getId());
        Assertions.assertEquals((Object)NAME, (Object)result.getFirstName());
        Assertions.assertEquals((Object)EMAIL, (Object)result.getEmail());
        Assertions.assertNull((Object)result.getLastName());
        Assertions.assertTrue((boolean)result.getRoles().isEmpty());
    }

    @Test
    void getUserInfoFromTokenMissingNameReturnsUsername() {
        Mockito.when((Object)this.accessToken.getUserDetails()).thenReturn((Object)this.userDetails);
        Mockito.when((Object)this.userDetails.getName()).thenReturn(Optional.empty());
        Mockito.when((Object)this.userDetails.getUsername()).thenReturn(Optional.of(USERNAME));
        Mockito.when((Object)this.userDetails.getEmail()).thenReturn(Optional.of(EMAIL));
        UserDto result = this.ccsmTokenService.getUserInfoFromToken(ID, ACCESS_TOKEN_VALUE);
        Assertions.assertEquals((Object)ID, (Object)result.getId());
        Assertions.assertEquals((Object)USERNAME, (Object)result.getFirstName());
        Assertions.assertEquals((Object)EMAIL, (Object)result.getEmail());
        Assertions.assertNull((Object)result.getLastName());
        Assertions.assertTrue((boolean)result.getRoles().isEmpty());
    }

    @Test
    void getUserInfoFromTokenMissingNameAndUsernameReturnsUserIdAsUsername() {
        Mockito.when((Object)this.accessToken.getUserDetails()).thenReturn((Object)this.userDetails);
        Mockito.when((Object)this.userDetails.getName()).thenReturn(Optional.empty());
        Mockito.when((Object)this.userDetails.getUsername()).thenReturn(Optional.empty());
        Mockito.when((Object)this.userDetails.getEmail()).thenReturn(Optional.of(EMAIL));
        UserDto result = this.ccsmTokenService.getUserInfoFromToken(ID, ACCESS_TOKEN_VALUE);
        Assertions.assertEquals((Object)ID, (Object)result.getId());
        Assertions.assertEquals((Object)ID, (Object)result.getFirstName());
        Assertions.assertEquals((Object)EMAIL, (Object)result.getEmail());
        Assertions.assertNull((Object)result.getLastName());
        Assertions.assertTrue((boolean)result.getRoles().isEmpty());
    }

    @Test
    void getUserInfoFromTokenMissingEmailReturnsUserIdAsEmail() {
        Mockito.when((Object)this.accessToken.getUserDetails()).thenReturn((Object)this.userDetails);
        Mockito.when((Object)this.userDetails.getName()).thenReturn(Optional.of(NAME));
        Mockito.when((Object)this.userDetails.getEmail()).thenReturn(Optional.empty());
        UserDto result = this.ccsmTokenService.getUserInfoFromToken(ID, ACCESS_TOKEN_VALUE);
        Assertions.assertEquals((Object)ID, (Object)result.getId());
        Assertions.assertEquals((Object)ID, (Object)result.getEmail());
        Assertions.assertEquals((Object)NAME, (Object)result.getFirstName());
        Assertions.assertNull((Object)result.getLastName());
        Assertions.assertTrue((boolean)result.getRoles().isEmpty());
    }

    @Test
    void getUserInfoFromTokenInvalidTokenThrowsNotAuthorizedException() {
        Mockito.when((Object)this.accessToken.getPermissions()).thenReturn((Object)ImmutableList.of());
        Assertions.assertThrows(NotAuthorizedException.class, () -> this.ccsmTokenService.getUserInfoFromToken(ID, ACCESS_TOKEN_VALUE));
    }
}

