/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.zeebe.variable.ZeebeVariableRecordDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.importing.page.PositionBasedImportPage;
import io.camunda.optimize.service.importing.zeebe.db.ZeebeProcessInstanceFetcher;
import io.camunda.optimize.service.importing.zeebe.fetcher.es.ZeebeProcessInstanceFetcherES;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ZeebeRecordFetcherTest {
    public static final int TEST_CONFIGURED_BATCH_SIZE = 5;
    @Mock
    ObjectMapper objectMapper;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    ConfigurationService configurationService;
    @Mock
    SearchResponse searchResponse;
    private ZeebeProcessInstanceFetcher underTest;
    @Mock
    private OptimizeElasticsearchClient optimizeElasticsearchClient;

    @Test
    public void testFetchFailsTriggersDynamicBatchResizing() {
        Mockito.when((Object)this.configurationService.getConfiguredZeebe().getMaxImportPageSize()).thenReturn((Object)5);
        Mockito.when((Object)this.configurationService.getConfiguredZeebe().getImportConfig().getDynamicBatchSuccessAttempts()).thenReturn((Object)10);
        this.initalizeClassUnderTest();
        Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(5);
        Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isZero();
        try {
            Mockito.when((Object)this.optimizeElasticsearchClient.searchWithoutPrefixing((SearchRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any())).thenThrow(IOException.class);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        this.triggerFailedFetchAttempt();
        Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(2);
        Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isZero();
        Assertions.assertThat((Collection)this.underTest.getBatchSizeDeque()).containsExactly((Object[])new Integer[]{2});
        this.triggerFailedFetchAttempt();
        Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(1);
        Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isZero();
        Assertions.assertThat((Collection)this.underTest.getBatchSizeDeque()).containsExactly((Object[])new Integer[]{1, 2});
        this.triggerFailedFetchAttempt();
        Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(1);
        Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isZero();
        Assertions.assertThat((Collection)this.underTest.getBatchSizeDeque()).containsExactly((Object[])new Integer[]{1, 2});
        try (MockedStatic mockEsReaderUtil = Mockito.mockStatic(ElasticsearchReaderUtil.class);){
            mockEsReaderUtil.when(() -> ElasticsearchReaderUtil.mapHits((HitsMetadata)((HitsMetadata)ArgumentMatchers.any()), (Class)((Class)ArgumentMatchers.any()), (ObjectMapper)((ObjectMapper)ArgumentMatchers.any()))).thenReturn(List.of());
            Mockito.reset((Object[])new OptimizeElasticsearchClient[]{this.optimizeElasticsearchClient});
            ShardStatistics mockedShardStatistics = (ShardStatistics)Mockito.mock(ShardStatistics.class);
            Mockito.when((Object)mockedShardStatistics.failures()).thenReturn(List.of());
            Mockito.when((Object)mockedShardStatistics.total()).thenReturn((Object)0);
            Mockito.when((Object)mockedShardStatistics.failed()).thenReturn((Object)0);
            Mockito.when((Object)mockedShardStatistics.successful()).thenReturn((Object)0);
            Mockito.when((Object)this.searchResponse.shards()).thenReturn((Object)mockedShardStatistics);
            try {
                Mockito.when((Object)this.optimizeElasticsearchClient.searchWithoutPrefixing((SearchRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any())).thenReturn((Object)this.searchResponse);
            }
            catch (IOException e) {
                throw new OptimizeRuntimeException((Throwable)e);
            }
            this.underTest.getZeebeRecordsForPrefixAndPartitionFrom(new PositionBasedImportPage());
            Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(1);
            Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isEqualTo(1);
            Assertions.assertThat((Collection)this.underTest.getBatchSizeDeque()).containsExactly((Object[])new Integer[]{1, 2});
            IntStream.range(0, 9).forEach(batch -> this.underTest.getZeebeRecordsForPrefixAndPartitionFrom(new PositionBasedImportPage()));
            Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(1);
            Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isZero();
            Assertions.assertThat((Collection)this.underTest.getBatchSizeDeque()).containsExactly((Object[])new Integer[]{2});
            this.underTest.getZeebeRecordsForPrefixAndPartitionFrom(new PositionBasedImportPage());
            Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(1);
            Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isEqualTo(1);
            Assertions.assertThat((Collection)this.underTest.getBatchSizeDeque()).containsExactly((Object[])new Integer[]{2});
            IntStream.range(0, 9).forEach(batch -> this.underTest.getZeebeRecordsForPrefixAndPartitionFrom(new PositionBasedImportPage()));
            Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(2);
            Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isZero();
            Assertions.assertThat((Collection)this.underTest.getBatchSizeDeque()).isEmpty();
            this.underTest.getZeebeRecordsForPrefixAndPartitionFrom(new PositionBasedImportPage());
            Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(2);
            Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isEqualTo(1);
            Assertions.assertThat((Collection)this.underTest.getBatchSizeDeque()).isEmpty();
            IntStream.range(0, 9).forEach(batch -> this.underTest.getZeebeRecordsForPrefixAndPartitionFrom(new PositionBasedImportPage()));
            Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(5);
            Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isZero();
            Assertions.assertThat((Collection)this.underTest.getBatchSizeDeque()).isEmpty();
            this.underTest.getZeebeRecordsForPrefixAndPartitionFrom(new PositionBasedImportPage());
            Assertions.assertThat((int)this.underTest.getDynamicBatchSize()).isEqualTo(5);
            Assertions.assertThat((int)this.underTest.getConsecutiveSuccessfulFetches()).isZero();
            Assertions.assertThat((Collection)this.underTest.getBatchSizeDeque()).isEmpty();
        }
    }

    @Test
    public void testThatEmptyPageFetchesAreTrackedCorrectly() {
        Mockito.when((Object)this.configurationService.getConfiguredZeebe().getImportConfig().getMaxEmptyPagesToImport()).thenReturn((Object)3);
        this.initalizeClassUnderTest();
        Assertions.assertThat((int)this.underTest.getConsecutiveEmptyPages()).isZero();
        try (MockedStatic mockEsReaderUtil = Mockito.mockStatic(ElasticsearchReaderUtil.class);){
            mockEsReaderUtil.when(() -> ElasticsearchReaderUtil.mapHits((HitsMetadata)((HitsMetadata)ArgumentMatchers.any()), (Class)((Class)ArgumentMatchers.any()), (ObjectMapper)((ObjectMapper)ArgumentMatchers.any()))).thenReturn(List.of());
            Mockito.reset((Object[])new OptimizeElasticsearchClient[]{this.optimizeElasticsearchClient});
            ShardStatistics mockedShardStatistics = (ShardStatistics)Mockito.mock(ShardStatistics.class);
            Mockito.when((Object)mockedShardStatistics.failures()).thenReturn(List.of());
            Mockito.when((Object)mockedShardStatistics.total()).thenReturn((Object)0);
            Mockito.when((Object)mockedShardStatistics.failed()).thenReturn((Object)0);
            Mockito.when((Object)mockedShardStatistics.successful()).thenReturn((Object)0);
            Mockito.when((Object)this.searchResponse.shards()).thenReturn((Object)mockedShardStatistics);
            try {
                Mockito.when((Object)this.optimizeElasticsearchClient.searchWithoutPrefixing((SearchRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any())).thenReturn((Object)this.searchResponse);
            }
            catch (IOException e) {
                throw new OptimizeRuntimeException((Throwable)e);
            }
            this.triggerFetchAttemptForEmptyPage();
            Assertions.assertThat((int)this.underTest.getConsecutiveEmptyPages()).isEqualTo(1);
            this.triggerFetchAttemptForEmptyPage();
            Assertions.assertThat((int)this.underTest.getConsecutiveEmptyPages()).isEqualTo(2);
            this.triggerFetchAttemptForEmptyPage();
            Assertions.assertThat((int)this.underTest.getConsecutiveEmptyPages()).isEqualTo(3);
            this.triggerFetchAttemptForEmptyPage();
            Assertions.assertThat((int)this.underTest.getConsecutiveEmptyPages()).isZero();
            this.triggerFetchAttemptForEmptyPage();
            Assertions.assertThat((int)this.underTest.getConsecutiveEmptyPages()).isEqualTo(1);
            mockEsReaderUtil.when(() -> ElasticsearchReaderUtil.mapHits((HitsMetadata)((HitsMetadata)ArgumentMatchers.any()), (Class)((Class)ArgumentMatchers.any()), (ObjectMapper)((ObjectMapper)ArgumentMatchers.any()))).thenReturn(List.of(new ZeebeVariableRecordDto()));
            this.triggerFetchAttempt();
            Assertions.assertThat((int)this.underTest.getConsecutiveEmptyPages()).isZero();
        }
    }

    private void initalizeClassUnderTest() {
        this.underTest = new ZeebeProcessInstanceFetcherES(1, this.optimizeElasticsearchClient, this.objectMapper, this.configurationService);
    }

    private void triggerFailedFetchAttempt() {
        PositionBasedImportPage positionBasedImportPage = new PositionBasedImportPage();
        org.junit.jupiter.api.Assertions.assertThrows(OptimizeRuntimeException.class, () -> this.underTest.getZeebeRecordsForPrefixAndPartitionFrom(positionBasedImportPage));
    }

    private void triggerFetchAttemptForEmptyPage() {
        PositionBasedImportPage positionBasedImportPage = new PositionBasedImportPage();
        positionBasedImportPage.setHasSeenSequenceField(true);
        Assertions.assertThat((List)this.underTest.getZeebeRecordsForPrefixAndPartitionFrom(positionBasedImportPage)).isEmpty();
    }

    private void triggerFetchAttempt() {
        PositionBasedImportPage positionBasedImportPage = new PositionBasedImportPage();
        positionBasedImportPage.setHasSeenSequenceField(true);
        this.underTest.getZeebeRecordsForPrefixAndPartitionFrom(positionBasedImportPage);
    }
}

