/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.client.api.response.Process;
import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.process.FlowNodeInstanceDto;
import io.camunda.optimize.dto.zeebe.process.ZeebeProcessInstanceRecordDto;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.test.it.extension.db.TermsQueryContainer;
import io.camunda.optimize.util.ZeebeBpmnModels;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AdHocSubProcessBuilder;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;

public class ZeebeProcessInstanceImportIT
extends AbstractCCSMIT {
    private final Supplier<OptimizeIntegrationTestException> eventNotFoundExceptionSupplier = () -> new OptimizeIntegrationTestException("Cannot find exported event");

    @Test
    public void importCompletedZeebeProcessInstanceDataInOneBatch_allDataSavedToOptimizeProcessInstance() {
        String processName = "someProcess";
        ProcessInstanceEvent deployedInstance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createStartEndProcess("someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(6);
        this.importAllZeebeEntitiesFromScratch();
        Map<String, List<ZeebeProcessInstanceRecordDto>> exportedEvents = this.getZeebeExportedProcessInstanceEventsByElementId();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(deployedInstance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(deployedInstance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(deployedInstance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getProcessDefinitionVersion()).isEqualTo(String.valueOf(deployedInstance.getVersion()));
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getState()).isEqualTo("COMPLETED");
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            Assertions.assertThat((String)savedInstance.getBusinessKey()).isNull();
            Assertions.assertThat((List)savedInstance.getIncidents()).isEmpty();
            Assertions.assertThat((List)savedInstance.getVariables()).isEmpty();
            Assertions.assertThat((OffsetDateTime)savedInstance.getStartDate()).isEqualTo((Object)this.getExpectedStartDateForEvents((List)exportedEvents.get(deployedInstance.getBpmnProcessId())));
            Assertions.assertThat((OffsetDateTime)savedInstance.getEndDate()).isEqualTo((Object)this.getExpectedEndDateForEvents((List)exportedEvents.get(deployedInstance.getBpmnProcessId())));
            Assertions.assertThat((Long)savedInstance.getDuration()).isEqualTo(this.getExpectedDurationForEvents((List)exportedEvents.get(deployedInstance.getBpmnProcessId())));
            ((ListAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).hasSize(2)).containsExactlyInAnyOrder((Object[])new FlowNodeInstanceDto[]{this.createFlowNodeInstance(deployedInstance, exportedEvents, "startEvent", BpmnElementType.START_EVENT), this.createFlowNodeInstance(deployedInstance, exportedEvents, "end", BpmnElementType.END_EVENT)});
        }});
    }

    @Test
    public void importCompletedZeebeProcessInstanceDataInMultipleBatches_allDataSavedToOptimizeProcessInstance() {
        embeddedOptimizeExtension.getConfigurationService().getConfiguredZeebe().setMaxImportPageSize(1);
        embeddedOptimizeExtension.reloadConfiguration();
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createStartEndProcess("someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(6);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getState()).isEqualTo("ACTIVE");
            Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).isEmpty();
        }});
        this.importAllZeebeEntitiesFromLastIndex();
        this.importAllZeebeEntitiesFromLastIndex();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getState()).isEqualTo("ACTIVE");
            ((ListAssert)((ListAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).hasSize(1)).allSatisfy(flowNodeInstance -> Assertions.assertThat((Long)flowNodeInstance.getTotalDurationInMs()).isNull())).extracting(FlowNodeInstanceDto::getFlowNodeId).containsExactly((Object[])new String[]{"startEvent"});
        }});
        embeddedOptimizeExtension.getConfigurationService().getConfiguredZeebe().setMaxImportPageSize(15);
        embeddedOptimizeExtension.reloadConfiguration();
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getState()).isEqualTo("COMPLETED");
            ((ListAssert)((ListAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).hasSize(2)).allSatisfy(flowNodeInstance -> Assertions.assertThat((Long)flowNodeInstance.getTotalDurationInMs()).isNotNull())).extracting(FlowNodeInstanceDto::getFlowNodeId).containsExactlyInAnyOrder((Object[])new String[]{"startEvent", "end"});
        }});
    }

    @Test
    public void importRunningZeebeProcessInstanceData_allDataSavedToOptimizeProcessInstance() {
        String processName = "someProcess";
        ProcessInstanceEvent deployedInstance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleUserTaskProcess("someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.importAllZeebeEntitiesFromScratch();
        Map<String, List<ZeebeProcessInstanceRecordDto>> exportedEvents = this.getZeebeExportedProcessInstanceEventsByElementId();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(deployedInstance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(deployedInstance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(deployedInstance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getProcessDefinitionVersion()).isEqualTo(String.valueOf(deployedInstance.getVersion()));
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getState()).isEqualTo("ACTIVE");
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            Assertions.assertThat((String)savedInstance.getBusinessKey()).isNull();
            Assertions.assertThat((List)savedInstance.getIncidents()).isEmpty();
            Assertions.assertThat((List)savedInstance.getVariables()).isEmpty();
            Assertions.assertThat((OffsetDateTime)savedInstance.getStartDate()).isEqualTo((Object)this.getExpectedStartDateForEvents((List)exportedEvents.get(deployedInstance.getBpmnProcessId())));
            Assertions.assertThat((OffsetDateTime)savedInstance.getEndDate()).isNull();
            Assertions.assertThat((Long)savedInstance.getDuration()).isNull();
            FlowNodeInstanceDto flowNodeInstanceDto = new FlowNodeInstanceDto(String.valueOf(deployedInstance.getBpmnProcessId()), String.valueOf(deployedInstance.getVersion()), "<default>", String.valueOf(deployedInstance.getProcessInstanceKey()), "user_task", this.getBpmnElementTypeNameForType(BpmnElementType.USER_TASK), String.valueOf(((ZeebeProcessInstanceRecordDto)((List)exportedEvents.get("user_task")).get(0)).getKey()));
            flowNodeInstanceDto.setStartDate(this.getExpectedStartDateForEvents((List)exportedEvents.get("user_task")));
            flowNodeInstanceDto.setCanceled(Boolean.valueOf(false));
            ((ListAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).hasSize(2)).containsExactlyInAnyOrder((Object[])new FlowNodeInstanceDto[]{this.createFlowNodeInstance(deployedInstance, exportedEvents, "startEvent", BpmnElementType.START_EVENT), flowNodeInstanceDto});
        }});
    }

    @Test
    public void importCanceledZeebeProcessInstanceData_allDataSavedToOptimizeProcessInstance() {
        String processName = "someProcess";
        ProcessInstanceEvent deployedInstance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        zeebeExtension.cancelProcessInstance(deployedInstance.getProcessInstanceKey());
        this.waitUntilMinimumProcessInstanceEventsExportedCount(6);
        this.importAllZeebeEntitiesFromScratch();
        Map<String, List<ZeebeProcessInstanceRecordDto>> exportedEvents = this.getZeebeExportedProcessInstanceEventsByElementId();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(deployedInstance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(deployedInstance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(deployedInstance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getProcessDefinitionVersion()).isEqualTo(String.valueOf(deployedInstance.getVersion()));
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getState()).isEqualTo("EXTERNALLY_TERMINATED");
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            Assertions.assertThat((String)savedInstance.getBusinessKey()).isNull();
            Assertions.assertThat((List)savedInstance.getIncidents()).isEmpty();
            Assertions.assertThat((List)savedInstance.getVariables()).isEmpty();
            Assertions.assertThat((OffsetDateTime)savedInstance.getStartDate()).isEqualTo((Object)this.getExpectedStartDateForEvents((List)exportedEvents.get(deployedInstance.getBpmnProcessId())));
            Assertions.assertThat((OffsetDateTime)savedInstance.getEndDate()).isEqualTo((Object)this.getExpectedEndDateForEvents((List)exportedEvents.get(deployedInstance.getBpmnProcessId())));
            Assertions.assertThat((Long)savedInstance.getDuration()).isEqualTo(this.getExpectedDurationForEvents((List)exportedEvents.get(deployedInstance.getBpmnProcessId())));
            ((ListAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).hasSize(2)).containsExactlyInAnyOrder((Object[])new FlowNodeInstanceDto[]{this.createFlowNodeInstance(deployedInstance, exportedEvents, "startEvent", BpmnElementType.START_EVENT), this.createFlowNodeInstance(deployedInstance, exportedEvents, "service_task", BpmnElementType.SERVICE_TASK, true)});
        }});
    }

    @Test
    public void importZeebeProcessInstanceDataFromMultipleDays_allDataSavedToOptimizeProcessInstance() {
        String processName = "someProcess";
        ProcessInstanceEvent deployedInstance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        try {
            zeebeExtension.setClock(Instant.now().plus(1L, ChronoUnit.DAYS));
        }
        catch (IOException | InterruptedException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        zeebeExtension.completeTaskForInstanceWithJobType("service_task");
        this.waitUntilMinimumProcessInstanceEventsExportedCount(8);
        this.importAllZeebeEntitiesFromScratch();
        Map<String, List<ZeebeProcessInstanceRecordDto>> exportedEvents = this.getZeebeExportedProcessInstanceEventsByElementId();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> {
            Assertions.assertThat((String)savedInstance.getProcessInstanceId()).isEqualTo(String.valueOf(deployedInstance.getProcessInstanceKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionId()).isEqualTo(String.valueOf(deployedInstance.getProcessDefinitionKey()));
            Assertions.assertThat((String)savedInstance.getProcessDefinitionKey()).isEqualTo(deployedInstance.getBpmnProcessId());
            Assertions.assertThat((String)savedInstance.getProcessDefinitionVersion()).isEqualTo(String.valueOf(deployedInstance.getVersion()));
            Assertions.assertThat((String)savedInstance.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)savedInstance.getState()).isEqualTo("COMPLETED");
            Assertions.assertThat((String)savedInstance.getTenantId()).isEqualTo("<default>");
            Assertions.assertThat((String)savedInstance.getBusinessKey()).isNull();
            Assertions.assertThat((List)savedInstance.getIncidents()).isEmpty();
            Assertions.assertThat((List)savedInstance.getVariables()).isEmpty();
            Assertions.assertThat((OffsetDateTime)savedInstance.getStartDate()).isEqualTo((Object)this.getExpectedStartDateForEvents((List)exportedEvents.get(deployedInstance.getBpmnProcessId())));
            Assertions.assertThat((OffsetDateTime)savedInstance.getEndDate()).isEqualTo((Object)this.getExpectedEndDateForEvents((List)exportedEvents.get(deployedInstance.getBpmnProcessId())));
            Assertions.assertThat((Long)savedInstance.getDuration()).isEqualTo(this.getExpectedDurationForEvents((List)exportedEvents.get(deployedInstance.getBpmnProcessId())));
            ((ListAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).hasSize(3)).containsExactlyInAnyOrder((Object[])new FlowNodeInstanceDto[]{this.createFlowNodeInstance(deployedInstance, exportedEvents, "startEvent", BpmnElementType.START_EVENT), this.createFlowNodeInstance(deployedInstance, exportedEvents, "service_task", BpmnElementType.SERVICE_TASK), this.createFlowNodeInstance(deployedInstance, exportedEvents, "end", BpmnElementType.END_EVENT)});
        }});
    }

    @Test
    public void importZeebeProcessInstanceData_multipleInstancesForSameProcess() {
        String processName = "someProcess";
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createStartEndProcess("someProcess"));
        ProcessInstanceEvent firstInstance = zeebeExtension.startProcessInstanceForProcess(deployedProcess.getBpmnProcessId());
        ProcessInstanceEvent secondInstance = zeebeExtension.startProcessInstanceForProcess(deployedProcess.getBpmnProcessId());
        this.waitUntilMinimumProcessInstanceEventsExportedCount(12);
        this.importAllZeebeEntitiesFromScratch();
        ((ListAssert)((ListAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).hasSize(2)).allSatisfy(instance -> Assertions.assertThat((List)instance.getFlowNodeInstances()).hasSize(2))).extracting(ProcessInstanceDto::getProcessInstanceId).containsExactlyInAnyOrder((Object[])new String[]{String.valueOf(firstInstance.getProcessInstanceKey()), String.valueOf(secondInstance.getProcessInstanceKey())});
    }

    @Test
    public void importZeebeProcessInstanceData_instancesForDifferentProcesses() {
        ProcessInstanceEvent firstInstance = zeebeExtension.startProcessInstanceForProcess(zeebeExtension.deployProcess(ZeebeBpmnModels.createStartEndProcess("firstProcess")).getBpmnProcessId());
        ProcessInstanceEvent secondInstance = zeebeExtension.startProcessInstanceForProcess(zeebeExtension.deployProcess(ZeebeBpmnModels.createStartEndProcess("secondProcess")).getBpmnProcessId());
        this.waitUntilMinimumProcessInstanceEventsExportedCount(12);
        this.importAllZeebeEntitiesFromScratch();
        ((ListAssert)((ListAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).hasSize(2)).allSatisfy(instance -> Assertions.assertThat((List)instance.getFlowNodeInstances()).hasSize(2))).extracting(ProcessInstanceDto::getProcessInstanceId).containsExactlyInAnyOrder((Object[])new String[]{String.valueOf(firstInstance.getProcessInstanceKey()), String.valueOf(secondInstance.getProcessInstanceKey())});
    }

    @Test
    public void importZeebeProcessInstanceData_instancesWithDifferentVersionsOfSameProcess() {
        String processName = "someProcess";
        ProcessInstanceEvent v1Instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createStartEndProcess("someProcess", "someProcess"));
        ProcessInstanceEvent v2Instance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createStartEndProcess("someProcess", "someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(12);
        this.importAllZeebeEntitiesFromScratch();
        ((ListAssert)((ListAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).hasSize(2)).allSatisfy(instance -> Assertions.assertThat((List)instance.getFlowNodeInstances()).hasSize(2))).extracting(new Function[]{ProcessInstanceDto::getProcessInstanceId, ProcessInstanceDto::getProcessDefinitionVersion}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{String.valueOf(v1Instance.getProcessInstanceKey()), "1"}), Tuple.tuple((Object[])new Object[]{String.valueOf(v2Instance.getProcessInstanceKey()), "2"})});
    }

    @Test
    public void importZeebeProcessInstanceData_processContainsLoop() {
        String processName = "someProcess";
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createLoopingProcess("someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(1);
        zeebeExtension.completeTaskForInstanceWithJobType("service_task", Map.of("loop", true));
        zeebeExtension.completeTaskForInstanceWithJobType("service_task", Map.of("loop", false));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(18);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{instance -> ((ListAssert)Assertions.assertThat((List)instance.getFlowNodeInstances()).filteredOn(flowNodeInstance -> flowNodeInstance.getFlowNodeId().equals("service_task"))).hasSizeGreaterThan(1)});
    }

    @Test
    public void importZeebeProcessInstanceData_processStartedDuringProcess() {
        String processName = "someProcess";
        Process process = zeebeExtension.deployProcess(ZeebeBpmnModels.createSingleStartDoubleEndEventProcess("someProcess"));
        zeebeExtension.startProcessInstanceBeforeElementWithIds(process.getBpmnProcessId(), "end", "end2");
        this.waitUntilMinimumProcessInstanceEventsExportedCount(6);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{instance -> {
            Assertions.assertThat((OffsetDateTime)instance.getEndDate()).isNotNull();
            Assertions.assertThat((String)instance.getState()).isEqualTo("COMPLETED");
            Assertions.assertThat((List)instance.getFlowNodeInstances()).extracting(FlowNodeInstanceDto::getFlowNodeType).containsExactlyInAnyOrder((Object[])new String[]{(String)BpmnElementType.END_EVENT.getElementTypeName().get(), (String)BpmnElementType.END_EVENT.getElementTypeName().get()});
        }});
    }

    @Test
    public void importZeebeProcessInstanceData_processContainsTerminateEndEvent() {
        String processName = "someProcess";
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createTerminateEndEventProcess("someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(6);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{instance -> Assertions.assertThat((List)instance.getFlowNodeInstances()).extracting(FlowNodeInstanceDto::getFlowNodeType).containsExactlyInAnyOrder((Object[])new String[]{(String)BpmnElementType.START_EVENT.getElementTypeName().get(), (String)BpmnElementType.END_EVENT.getElementTypeName().get()})});
    }

    @Test
    public void importZeebeProcessInstanceData_processContainsInclusiveGateway() {
        String processName = "someProcess";
        Process process = zeebeExtension.deployProcess(ZeebeBpmnModels.createInclusiveGatewayProcess("someProcess"));
        zeebeExtension.startProcessInstanceWithVariables(process.getBpmnProcessId(), Map.of("varName", "a,b"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(8);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{instance -> Assertions.assertThat((List)instance.getFlowNodeInstances()).extracting(FlowNodeInstanceDto::getFlowNodeType).containsExactlyInAnyOrder((Object[])new String[]{(String)BpmnElementType.START_EVENT.getElementTypeName().get(), (String)BpmnElementType.INCLUSIVE_GATEWAY.getElementTypeName().get(), (String)BpmnElementType.END_EVENT.getElementTypeName().get(), (String)BpmnElementType.END_EVENT.getElementTypeName().get()})});
    }

    @DisabledIf(value="isZeebeVersionPre86")
    @Test
    public void importZeebeProcessInstanceData_processContainsInclusiveGatewayWithConverging() {
        String processName = "someProcess";
        Process process = zeebeExtension.deployProcess(ZeebeBpmnModels.createInclusiveGatewayProcessWithConverging("someProcess"));
        zeebeExtension.startProcessInstanceWithVariables(process.getBpmnProcessId(), Map.of("varName", "a,b"));
        this.waitUntilInstanceRecordWithElementIdExported("end");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{instance -> Assertions.assertThat((List)instance.getFlowNodeInstances()).extracting(FlowNodeInstanceDto::getFlowNodeId).containsExactlyInAnyOrder((Object[])new String[]{"startEvent", "diverging_gateway", "converging_gateway", "end"})});
    }

    @Test
    public void importSendTaskZeebeProcessInstanceData_flowNodeInstancesCreatedCorrectly() {
        ProcessInstanceEvent processInstance = this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSendTaskProcess("someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{savedInstance -> ((ListAssert)((ListAssert)Assertions.assertThat((List)savedInstance.getFlowNodeInstances()).hasSize(2)).allSatisfy(flowNodeInstanceDto -> ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)flowNodeInstanceDto).hasFieldOrPropertyWithValue("definitionKey", (Object)processInstance.getBpmnProcessId())).hasFieldOrPropertyWithValue("definitionVersion", (Object)String.valueOf(processInstance.getVersion()))).hasFieldOrPropertyWithValue("tenantId", (Object)"<default>"))).extracting(new Function[]{FlowNodeInstanceDto::getFlowNodeId, FlowNodeInstanceDto::getFlowNodeType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"startEvent", this.getBpmnElementTypeNameForType(BpmnElementType.START_EVENT)}), Tuple.tuple((Object[])new Object[]{"send_task", this.getBpmnElementTypeNameForType(BpmnElementType.SEND_TASK)})})});
    }

    @Test
    public void importZeebeProcessInstanceData_processContainsNewBpmnElementsIntroducedWith820() {
        BpmnModelInstance model = this.readProcessDiagramAsInstance("/bpmn/compatibility/adventure.bpmn");
        String processId = zeebeExtension.deployProcess(model).getBpmnProcessId();
        zeebeExtension.startProcessInstanceWithVariables(processId, Map.of("space", true, "time", true));
        this.waitUntilInstanceRecordWithElementIdExported("milkAdventureEndEventId");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{instance -> Assertions.assertThat((List)instance.getFlowNodeInstances()).extracting(FlowNodeInstanceDto::getFlowNodeId).contains((Object[])new String[]{"linkIntermediateThrowEventId", "linkIntermediateCatchEventId", "undefinedTaskId", "escalationIntermediateThrowEventId", "escalationNonInterruptingBoundaryEventId", "escalationBoundaryEventId", "escalationNonInterruptingStartEventId", "escalationStartEventId", "escalationEndEventId"})});
    }

    @DisabledIf(value="isZeebeVersionPre83")
    @Test
    public void importZeebeProcessInstanceData_processContainsNewBpmnElementsIntroducedWith830() {
        zeebeExtension.deployProcess(ZeebeBpmnModels.createProcessWith83SignalEvents("startSignalName"));
        zeebeExtension.startProcessInstanceWithSignal("startSignalName");
        this.waitUntilInstanceRecordWithElementIdExported("signalProcessServiceTask1");
        zeebeExtension.broadcastSignalWithName("nonInterruptingBoundarySignal");
        this.waitUntilInstanceRecordWithElementIdExported("signalProcessServiceTask2");
        zeebeExtension.broadcastSignalWithName("interruptingBoundarySignal");
        this.waitUntilInstanceRecordWithElementIdExported("eventBasedGateway");
        zeebeExtension.broadcastSignalWithName("eventBasedGatewaySignal");
        this.waitUntilInstanceRecordWithElementIdExported("signalEndEvent");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{instance -> Assertions.assertThat((List)instance.getFlowNodeInstances()).extracting(FlowNodeInstanceDto::getFlowNodeId).contains((Object[])new String[]{"signalStartEvent", "signalStartInterruptingSubProcessEvent", "signalStartNonInterruptingSubProcessEvent", "signalIntermediateCatchEventAttachedToEventBasedGateway", "signalIntermediateThrowEvent", "signalIntermediateCatchEvent", "signalIntermediateBoundaryInterruptingEvent", "signalIntermediateBoundaryNonInterruptingEvent", "signalEndEvent"})});
    }

    @DisabledIf(value="isZeebeVersionPre85")
    @Test
    public void importZeebeProcessInstanceData_processContainsCompensationTasks() {
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createCompensationEventProcess());
        zeebeExtension.completeTaskForInstanceWithJobType("compensationEvent");
        zeebeExtension.completeTaskForInstanceWithJobType("compensationEventTask");
        this.waitUntilInstanceRecordWithElementTypeAndIntentExported(BpmnElementType.BOUNDARY_EVENT, (Intent)ProcessInstanceIntent.ELEMENT_COMPLETED);
        this.waitUntilMinimumProcessInstanceEventsExportedCount(12);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{instance -> {
            Assertions.assertThat((List)instance.getFlowNodeInstances()).extracting(FlowNodeInstanceDto::getFlowNodeType).containsExactlyInAnyOrder((Object[])new String[]{(String)BpmnElementType.END_EVENT.getElementTypeName().get(), (String)BpmnElementType.BOUNDARY_EVENT.getElementTypeName().get(), (String)BpmnElementType.SERVICE_TASK.getElementTypeName().get(), (String)BpmnElementType.START_EVENT.getElementTypeName().get(), (String)BpmnElementType.SERVICE_TASK.getElementTypeName().get()});
            Assertions.assertThat((List)instance.getFlowNodeInstances()).extracting(FlowNodeInstanceDto::getFlowNodeId).contains((Object[])new String[]{"compensationEvent", "compensationEventTask"});
        }});
    }

    @EnabledIf(value="isZeebeVersion87_OrLater")
    @Test
    public void importZeebeProcessInstanceData_processContainsAdHocSubProcess() {
        BpmnModelInstance adHocSubProcessModel = ZeebeBpmnModels.createAdHocSubProcess("someProcess", process -> ((AdHocSubProcessBuilder)process.zeebeActiveElementsCollectionExpression("activateElements")).task("task"));
        String processId = zeebeExtension.deployProcess(adHocSubProcessModel).getBpmnProcessId();
        zeebeExtension.startProcessInstanceWithVariables(processId, Map.of("activateElements", List.of("task")));
        this.waitUntilInstanceRecordWithElementIdExported("end");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessInstances()).singleElement()).satisfies(new ThrowingConsumer[]{instance -> Assertions.assertThat((List)instance.getFlowNodeInstances()).extracting(FlowNodeInstanceDto::getFlowNodeId).contains((Object[])new String[]{"startEvent", "adhocSubProcess", "task", "end"})});
    }

    @DisabledIf(value="isZeebeVersionWithMultiTenancy")
    @Test
    public void importZeebeProcess_defaultTenantIdForRecordsWithoutTenantId() {
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createStartEndProcess("someProcess"));
        this.waitUntilInstanceRecordWithElementIdExported("startEvent");
        this.importAllZeebeEntitiesFromScratch();
        List<ProcessInstanceDto> instances = databaseIntegrationTestExtension.getAllProcessInstances();
        ((ObjectAssert)Assertions.assertThat(instances).extracting(ProcessInstanceDto::getTenantId).singleElement()).isEqualTo((Object)"<default>");
        ((AbstractListAssert)Assertions.assertThat(instances).flatExtracting(ProcessInstanceDto::getFlowNodeInstances).extracting(FlowNodeInstanceDto::getTenantId).hasSize(2)).containsOnly((Object[])new String[]{"<default>"});
    }

    @EnabledIf(value="isZeebeVersionWithMultiTenancy")
    @Test
    public void importZeebeProcessInstanceData_tenantIdImported() {
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createStartEndProcess("aProcess"));
        this.waitUntilInstanceRecordWithElementIdExported("startEvent");
        String expectedTenantId = "testTenant";
        this.setTenantIdForExportedZeebeRecords("process-instance", "testTenant");
        this.importAllZeebeEntitiesFromScratch();
        List<ProcessInstanceDto> instances = databaseIntegrationTestExtension.getAllProcessInstances();
        ((ObjectAssert)Assertions.assertThat(instances).extracting(ProcessInstanceDto::getTenantId).singleElement()).isEqualTo((Object)"testTenant");
        ((AbstractListAssert)Assertions.assertThat(instances).flatExtracting(ProcessInstanceDto::getFlowNodeInstances).extracting(FlowNodeInstanceDto::getTenantId).hasSize(2)).containsOnly((Object[])new String[]{"testTenant"});
    }

    @Test
    public void importZeebeProcessInstanceData_documentsHittingNestedDocLimitAreSkippedOnImportIfConfigurationEnabled() {
        embeddedOptimizeExtension.getConfigurationService().setSkipDataAfterNestedDocLimitReached(Boolean.valueOf(true));
        Map<String, Object> processVariables = Map.of("var1", "someValue1", "var2", "someValue2");
        Map<String, Object> additionalVariables = Map.of("var3", "someValue3", "var4", "someValue4");
        String processId = "nestedBonanza";
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("nestedBonanza"));
        long startedInstanceKey = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), processVariables);
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto firstInstanceOnFirstRoundImport = this.getProcessInstanceForId(String.valueOf(startedInstanceKey));
        int currentNestedDocCount = this.getNestedDocumentCountForProcessInstance(firstInstanceOnFirstRoundImport);
        Assertions.assertThat((int)currentNestedDocCount).isGreaterThan(0);
        this.updateProcessInstanceNestedDocLimit(deployedProcess.getBpmnProcessId(), currentNestedDocCount);
        zeebeExtension.addVariablesToScope(startedInstanceKey, additionalVariables, true);
        this.waitUntilMinimumVariableDocumentsExportedCount(2);
        long secondInstanceKey = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), processVariables);
        this.waitUntilMinimumProcessInstanceEventsExportedCount(8);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto firstInstanceAfterSecondRoundImport = this.getProcessInstanceForId(String.valueOf(startedInstanceKey));
        Assertions.assertThat((List)firstInstanceAfterSecondRoundImport.getVariables()).isEqualTo((Object)firstInstanceOnFirstRoundImport.getVariables());
        Assertions.assertThat((List)this.getProcessInstanceForId(String.valueOf(secondInstanceKey)).getVariables()).hasSize(2);
    }

    private FlowNodeInstanceDto createFlowNodeInstance(ProcessInstanceEvent deployedInstance, Map<String, List<ZeebeProcessInstanceRecordDto>> events, String eventId, BpmnElementType eventType) {
        return this.createFlowNodeInstance(deployedInstance, events, eventId, eventType, false);
    }

    private FlowNodeInstanceDto createFlowNodeInstance(ProcessInstanceEvent deployedInstance, Map<String, List<ZeebeProcessInstanceRecordDto>> events, String eventId, BpmnElementType eventType, boolean canceled) {
        FlowNodeInstanceDto flowNodeInstanceDto = new FlowNodeInstanceDto(String.valueOf(deployedInstance.getBpmnProcessId()), String.valueOf(deployedInstance.getVersion()), "<default>", String.valueOf(deployedInstance.getProcessInstanceKey()), eventId, this.getBpmnElementTypeNameForType(eventType), String.valueOf(events.get(eventId).get(0).getKey()));
        flowNodeInstanceDto.setStartDate(this.getExpectedStartDateForEvents(events.get(eventId)));
        flowNodeInstanceDto.setEndDate(this.getExpectedEndDateForEvents(events.get(eventId)));
        flowNodeInstanceDto.setTotalDurationInMs(Long.valueOf(this.getExpectedDurationForEvents(events.get(eventId))));
        flowNodeInstanceDto.setCanceled(Boolean.valueOf(canceled));
        return flowNodeInstanceDto;
    }

    private long getExpectedDurationForEvents(List<ZeebeProcessInstanceRecordDto> eventsForElement) {
        ZeebeProcessInstanceRecordDto startOfElement = eventsForElement.stream().filter(event -> ((ProcessInstanceIntent)event.getIntent()).equals((Object)ProcessInstanceIntent.ELEMENT_ACTIVATING)).findFirst().orElseThrow(this.eventNotFoundExceptionSupplier);
        ZeebeProcessInstanceRecordDto endOfElement = eventsForElement.stream().filter(event -> ((ProcessInstanceIntent)event.getIntent()).equals((Object)ProcessInstanceIntent.ELEMENT_COMPLETED) || ((ProcessInstanceIntent)event.getIntent()).equals((Object)ProcessInstanceIntent.ELEMENT_TERMINATED)).findFirst().orElseThrow(this.eventNotFoundExceptionSupplier);
        return endOfElement.getTimestamp() - startOfElement.getTimestamp();
    }

    private OffsetDateTime getExpectedStartDateForEvents(List<ZeebeProcessInstanceRecordDto> eventsForElement) {
        ZeebeProcessInstanceRecordDto startOfElement = eventsForElement.stream().filter(event -> ((ProcessInstanceIntent)event.getIntent()).equals((Object)ProcessInstanceIntent.ELEMENT_ACTIVATING)).findFirst().orElseThrow(this.eventNotFoundExceptionSupplier);
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startOfElement.getTimestamp()), ZoneId.systemDefault());
    }

    private OffsetDateTime getExpectedEndDateForEvents(List<ZeebeProcessInstanceRecordDto> eventsForElement) {
        ZeebeProcessInstanceRecordDto endOfElement = eventsForElement.stream().filter(event -> ((ProcessInstanceIntent)event.getIntent()).equals((Object)ProcessInstanceIntent.ELEMENT_COMPLETED) || ((ProcessInstanceIntent)event.getIntent()).equals((Object)ProcessInstanceIntent.ELEMENT_TERMINATED)).findFirst().orElseThrow(this.eventNotFoundExceptionSupplier);
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(endOfElement.getTimestamp()), ZoneId.systemDefault());
    }

    private String getBpmnElementTypeNameForType(BpmnElementType type) {
        return (String)type.getElementTypeName().orElseThrow(() -> new OptimizeRuntimeException("Cannot find name for type: " + String.valueOf(type)));
    }

    private ProcessInstanceDto getProcessInstanceForId(String processInstanceId) {
        List instances = databaseIntegrationTestExtension.getAllProcessInstances().stream().filter(instance -> instance.getProcessInstanceId().equals(processInstanceId)).collect(Collectors.toList());
        Assertions.assertThat(instances).hasSize(1);
        return (ProcessInstanceDto)instances.get(0);
    }

    private int getNestedDocumentCountForProcessInstance(ProcessInstanceDto instance) {
        return instance.getFlowNodeInstances().size() + instance.getVariables().size() + instance.getIncidents().size();
    }

    private void updateProcessInstanceNestedDocLimit(String processDefinitionKey, int nestedDocLimit) {
        databaseIntegrationTestExtension.updateProcessInstanceNestedDocLimit(processDefinitionKey, nestedDocLimit, embeddedOptimizeExtension.getConfigurationService());
    }

    private void waitUntilMinimumVariableDocumentsExportedCount(int minExportedEventCount) {
        TermsQueryContainer variableBoolQuery = new TermsQueryContainer();
        variableBoolQuery.addTermQuery("intent", VariableIntent.CREATED.name());
        this.waitUntilMinimumDataExportedCount(minExportedEventCount, "variable", variableBoolQuery);
    }
}

