/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.backup;

import io.camunda.optimize.service.metadata.Version;
import io.camunda.optimize.service.util.SnapshotUtil;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnapshotUtilTest {
    @Test
    public void getSnapshotNameForImportIndices() {
        Assertions.assertThat((String)SnapshotUtil.getSnapshotNameForImportIndices((Long)123L)).isEqualTo(String.format("camunda_optimize_123_%s_part_1_of_2", Version.VERSION));
    }

    @Test
    public void getSnapshotNameForNonImportIndices() {
        Assertions.assertThat((String)SnapshotUtil.getSnapshotNameForNonImportIndices((Long)123L)).isEqualTo(String.format("camunda_optimize_123_%s_part_2_of_2", Version.VERSION));
    }

    @Test
    public void getSnapshotPrefixWithBackupId() {
        Assertions.assertThat((String)SnapshotUtil.getSnapshotPrefixWithBackupId((Long)123L)).isEqualTo("camunda_optimize_123_");
    }

    @Test
    public void getBackupIdFromSnapshotName() {
        ((AbstractLongAssert)Assertions.assertThat((Long)SnapshotUtil.getBackupIdFromSnapshotName((String)"camunda_optimize_123_3.9.0_part_1_of_2")).isEqualTo((Object)SnapshotUtil.getBackupIdFromSnapshotName((String)"camunda_optimize_123_3.9.0_part_2_of_2"))).isEqualTo(123L);
    }
}

