/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.alert;

import io.camunda.optimize.dto.optimize.alert.AlertNotificationDto;
import io.camunda.optimize.dto.optimize.alert.AlertNotificationType;
import io.camunda.optimize.dto.optimize.query.alert.AlertDefinitionDto;
import io.camunda.optimize.service.alert.MixpanelNotificationService;
import io.camunda.optimize.service.mixpanel.MixpanelReportingService;
import io.camunda.optimize.service.mixpanel.client.EventReportingEvent;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class MixpanelNotificationServiceTest {
    @Mock
    private AlertDefinitionDto alertDefinitionDto;
    @Mock
    private AlertNotificationDto alertNotificationDto;
    @Mock
    private MixpanelReportingService reportingService;
    @InjectMocks
    private MixpanelNotificationService underTest;

    @ParameterizedTest
    @MethodSource(value={"alertTypeAndExpectedMixPanelEvent"})
    public void notifyWithCorrectEventName(AlertNotificationType type, EventReportingEvent eventName) {
        String alertId = "id";
        Mockito.when((Object)this.alertDefinitionDto.getId()).thenReturn((Object)"id");
        Mockito.when((Object)this.alertNotificationDto.getAlert()).thenReturn((Object)this.alertDefinitionDto);
        Mockito.when((Object)this.alertNotificationDto.getType()).thenReturn((Object)type);
        this.underTest.notify(this.alertNotificationDto);
        ((MixpanelReportingService)Mockito.verify((Object)this.reportingService, (VerificationMode)Mockito.times((int)1))).sendEntityEvent(eventName, "id");
    }

    private static Stream<Arguments> alertTypeAndExpectedMixPanelEvent() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{AlertNotificationType.NEW, EventReportingEvent.ALERT_NEW_TRIGGERED}), Arguments.arguments((Object[])new Object[]{AlertNotificationType.REMINDER, EventReportingEvent.ALERT_REMINDER_TRIGGERED}), Arguments.arguments((Object[])new Object[]{AlertNotificationType.RESOLVED, EventReportingEvent.ALERT_RESOLVED_TRIGGERED}), Arguments.arguments((Object[])new Object[]{null, EventReportingEvent.ALERT_NEW_TRIGGERED}));
    }
}

