/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.definition.DefinitionWithTenantIdsDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestRequestDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessUpdateDto;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.KpiService;
import io.camunda.optimize.service.ProcessOverviewService;
import io.camunda.optimize.service.db.reader.ProcessOverviewReader;
import io.camunda.optimize.service.db.writer.ProcessOverviewWriter;
import io.camunda.optimize.service.digest.DigestService;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ProcessOverviewServiceTest {
    private static final String EN_LOCALE = "en";
    private static final String USER_ID = "user123";
    private static final String PROCESS_KEY = "processKey1";
    private static final String OWNER_ID = "owner123";
    private static final String OWNER_NAME = "Owner Name";
    private static final String PROCESS_NAME = "Process Name";
    private static final List<String> TENANT_LIST = ProcessOverviewServiceTest.getSingleTenantList();
    public static final DefinitionWithTenantIdsDto DEFINITION_DTO = new DefinitionWithTenantIdsDto("processKey1", "Process Name", DefinitionType.PROCESS, TENANT_LIST, Set.of());
    private final DefinitionService definitionService = (DefinitionService)Mockito.mock(DefinitionService.class);
    private final DataSourceDefinitionAuthorizationService definitionAuthorizationService = (DataSourceDefinitionAuthorizationService)Mockito.mock(DataSourceDefinitionAuthorizationService.class);
    private final ProcessOverviewWriter processOverviewWriter = (ProcessOverviewWriter)Mockito.mock(ProcessOverviewWriter.class);
    private final ProcessOverviewReader processOverviewReader = (ProcessOverviewReader)Mockito.mock(ProcessOverviewReader.class);
    private final AbstractIdentityService identityService = (AbstractIdentityService)Mockito.mock(AbstractIdentityService.class);
    private final KpiService kpiService = (KpiService)Mockito.mock(KpiService.class);
    private final DigestService digestService = (DigestService)Mockito.mock(DigestService.class);
    private final ProcessOverviewService underTest = new ProcessOverviewService(this.definitionService, this.definitionAuthorizationService, this.processOverviewWriter, this.processOverviewReader, this.identityService, this.kpiService, this.digestService);

    @Test
    void shouldReturnProcessOverviewsWhenUserIsAuthorized() {
        Mockito.when((Object)this.definitionService.getAllDefinitionsWithTenants(DefinitionType.PROCESS)).thenReturn(List.of(DEFINITION_DTO));
        Mockito.when((Object)this.definitionService.getCachedTenantToLatestDefinitionMap(DefinitionType.PROCESS, PROCESS_KEY)).thenReturn(Map.of(PROCESS_KEY, new ProcessDefinitionOptimizeDto()));
        Mockito.when((Object)this.definitionAuthorizationService.isAuthorizedToAccessDefinition(USER_ID, DefinitionType.PROCESS, PROCESS_KEY, DEFINITION_DTO.getTenantIds())).thenReturn((Object)true);
        Map<String, ProcessOverviewDto> overviewMap = Map.of(PROCESS_KEY, new ProcessOverviewDto(OWNER_ID, PROCESS_KEY, new ProcessDigestDto(Boolean.valueOf(false), Map.of()), Map.of()));
        Mockito.when((Object)this.processOverviewReader.getProcessOverviewsByKey(Set.of(PROCESS_KEY))).thenReturn(overviewMap);
        Mockito.when((Object)this.identityService.getIdentityNameById(OWNER_ID)).thenReturn(Optional.of(OWNER_NAME));
        List result = this.underTest.getAllProcessOverviews(USER_ID, EN_LOCALE);
        ((ObjectAssert)Assertions.assertThat((List)result).singleElement()).satisfies(new ThrowingConsumer[]{response -> {
            Assertions.assertThat((String)response.getProcessDefinitionKey()).isEqualTo(PROCESS_KEY);
            Assertions.assertThat((String)response.getProcessDefinitionName()).isEqualTo(PROCESS_KEY);
            Assertions.assertThat((String)response.getOwner().getId()).isEqualTo(OWNER_ID);
            Assertions.assertThat((String)response.getOwner().getName()).isEqualTo(OWNER_NAME);
        }});
    }

    @Test
    void shouldReturnProcessOverviewsWithoutOwnerWhenUserIsAuthorized() {
        Mockito.when((Object)this.definitionService.getAllDefinitionsWithTenants(DefinitionType.PROCESS)).thenReturn(List.of(DEFINITION_DTO));
        Mockito.when((Object)this.definitionService.getCachedTenantToLatestDefinitionMap(DefinitionType.PROCESS, PROCESS_KEY)).thenReturn(Map.of(PROCESS_KEY, new ProcessDefinitionOptimizeDto()));
        Mockito.when((Object)this.definitionAuthorizationService.isAuthorizedToAccessDefinition(USER_ID, DefinitionType.PROCESS, PROCESS_KEY, DEFINITION_DTO.getTenantIds())).thenReturn((Object)true);
        Mockito.when((Object)this.processOverviewReader.getProcessOverviewsByKey(Set.of(PROCESS_KEY))).thenReturn(Map.of());
        Mockito.when((Object)this.identityService.getIdentityNameById(OWNER_ID)).thenReturn(Optional.of(OWNER_NAME));
        List result = this.underTest.getAllProcessOverviews(USER_ID, EN_LOCALE);
        ((ObjectAssert)Assertions.assertThat((List)result).singleElement()).satisfies(new ThrowingConsumer[]{response -> {
            Assertions.assertThat((String)response.getProcessDefinitionKey()).isEqualTo(PROCESS_KEY);
            Assertions.assertThat((String)response.getProcessDefinitionName()).isEqualTo(PROCESS_KEY);
            Assertions.assertThat((String)response.getOwner().getId()).isNull();
            Assertions.assertThat((String)response.getOwner().getName()).isNull();
        }});
    }

    @Test
    void shouldReturnEmptyListProcessOverviewsWhenDefinitionsEmpty() {
        Mockito.when((Object)this.definitionService.getAllDefinitionsWithTenants(DefinitionType.PROCESS)).thenReturn(List.of());
        List result = this.underTest.getAllProcessOverviews(USER_ID, EN_LOCALE);
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    void shouldUpdateProcessWhenAuthorizedAndValid() {
        ProcessUpdateDto updateDto = new ProcessUpdateDto(OWNER_ID, new ProcessDigestRequestDto(true));
        Mockito.when((Object)this.definitionService.getProcessDefinitionWithTenants(PROCESS_KEY)).thenReturn(Optional.of(DEFINITION_DTO));
        Mockito.when((Object)this.definitionAuthorizationService.isAuthorizedToAccessDefinition((String)ArgumentMatchers.any(), (DefinitionType)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.identityService.getUserById(OWNER_ID)).thenReturn(Optional.of(new UserDto(OWNER_ID)));
        Mockito.when((Object)this.identityService.isUserAuthorizedToAccessIdentity(USER_ID, new IdentityDto(OWNER_ID, IdentityType.USER))).thenReturn((Object)true);
        this.underTest.updateProcess(USER_ID, PROCESS_KEY, updateDto);
        ((ProcessOverviewWriter)Mockito.verify((Object)this.processOverviewWriter)).updateProcessConfiguration(PROCESS_KEY, updateDto);
        ((DigestService)Mockito.verify((Object)this.digestService)).handleProcessUpdate(PROCESS_KEY, updateDto);
    }

    @Test
    void shouldThrowExceptionWhenUnauthorizedForProcessUpdate() {
        ProcessUpdateDto updateDto = new ProcessUpdateDto(OWNER_ID, new ProcessDigestRequestDto(true));
        Mockito.when((Object)this.definitionService.getProcessDefinitionWithTenants(PROCESS_KEY)).thenReturn(Optional.of(DEFINITION_DTO));
        Mockito.when((Object)this.definitionAuthorizationService.isAuthorizedToAccessDefinition(USER_ID, DefinitionType.PROCESS, PROCESS_KEY, ProcessOverviewServiceTest.getSingleTenantList())).thenReturn((Object)false);
        Throwable thrown = AssertionsForClassTypes.catchThrowable(() -> this.underTest.updateProcess(USER_ID, PROCESS_KEY, updateDto));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(ForbiddenException.class)).hasMessageContaining("User is not authorized to access the process definition with key processKey1");
    }

    @Test
    void shouldThrowExceptionWhenUserAuthorizationFails() {
        ProcessUpdateDto updateDto = new ProcessUpdateDto(OWNER_ID, new ProcessDigestRequestDto(true));
        Mockito.when((Object)this.definitionService.getProcessDefinitionWithTenants(PROCESS_KEY)).thenReturn(Optional.of(DEFINITION_DTO));
        Mockito.when((Object)this.definitionAuthorizationService.isAuthorizedToAccessDefinition(USER_ID, DefinitionType.PROCESS, PROCESS_KEY, TENANT_LIST)).thenReturn((Object)true);
        Mockito.when((Object)this.identityService.isUserAuthorizedToAccessIdentity(USER_ID, new IdentityDto(USER_ID, IdentityType.GROUP))).thenReturn((Object)false);
        Throwable thrown = AssertionsForClassTypes.catchThrowable(() -> this.underTest.updateProcess(USER_ID, PROCESS_KEY, updateDto));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(ForbiddenException.class)).hasMessageContaining("Could not find a user with ID owner123 that the user user123 is authorized to see.");
    }

    @Test
    void shouldThrowExceptionWhenOwnerIdIsNullAndDigestEnabled() {
        ProcessUpdateDto updateDto = new ProcessUpdateDto(null, new ProcessDigestRequestDto(true));
        Mockito.when((Object)this.definitionService.getProcessDefinitionWithTenants(PROCESS_KEY)).thenReturn(Optional.of(DEFINITION_DTO));
        Mockito.when((Object)this.definitionAuthorizationService.isAuthorizedToAccessDefinition(USER_ID, DefinitionType.PROCESS, PROCESS_KEY, TENANT_LIST)).thenReturn((Object)true);
        Mockito.when((Object)this.identityService.isUserAuthorizedToAccessIdentity(USER_ID, new IdentityDto(USER_ID, IdentityType.GROUP))).thenReturn((Object)false);
        Throwable thrown = AssertionsForClassTypes.catchThrowable(() -> this.underTest.updateProcess(USER_ID, PROCESS_KEY, updateDto));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(BadRequestException.class)).hasMessageContaining("Process digest cannot be enabled if no owner is set");
    }

    @Test
    void shouldSuccessfullyUpdateProcess() {
        ProcessUpdateDto updateDto = new ProcessUpdateDto(OWNER_ID, new ProcessDigestRequestDto(true));
        Mockito.when((Object)this.definitionService.getProcessDefinitionWithTenants(PROCESS_KEY)).thenReturn(Optional.of(new DefinitionWithTenantIdsDto(PROCESS_KEY, PROCESS_NAME, DefinitionType.PROCESS, TENANT_LIST, Set.of())));
        Mockito.when((Object)this.definitionAuthorizationService.isAuthorizedToAccessDefinition(USER_ID, DefinitionType.PROCESS, PROCESS_KEY, TENANT_LIST)).thenReturn((Object)true);
        Mockito.when((Object)this.identityService.getUserById((String)ArgumentMatchers.any())).thenReturn(Optional.of(new UserDto(USER_ID)));
        this.underTest.updateProcess(USER_ID, PROCESS_KEY, updateDto);
    }

    @Test
    void shouldUpdateOwnerIfDefinitionIsImported() {
        Mockito.when((Object)this.definitionService.getLatestVersionToKey(DefinitionType.PROCESS, PROCESS_KEY)).thenReturn((Object)"1");
        Mockito.when((Object)this.identityService.getUserById(OWNER_ID)).thenReturn(Optional.of(new UserDto(OWNER_ID)));
        Mockito.when((Object)this.identityService.isUserAuthorizedToAccessIdentity(USER_ID, new IdentityDto(OWNER_ID, IdentityType.USER))).thenReturn((Object)true);
        Mockito.when((Object)this.definitionService.getProcessDefinitionWithTenants(PROCESS_KEY)).thenReturn(Optional.of(new DefinitionWithTenantIdsDto(TENANT_LIST)));
        Mockito.when((Object)this.definitionAuthorizationService.isAuthorizedToAccessDefinition((String)ArgumentMatchers.any(), (DefinitionType)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenReturn((Object)true);
        this.underTest.updateProcessOwnerIfNotSet(USER_ID, PROCESS_KEY, OWNER_ID);
        ((ProcessOverviewWriter)Mockito.verify((Object)this.processOverviewWriter)).updateProcessOwnerIfNotSet(PROCESS_KEY, OWNER_ID);
    }

    @Test
    void shouldThrowExceptionWhenOwnerIdIsNull() {
        Throwable thrown = AssertionsForClassTypes.catchThrowable(() -> this.underTest.updateProcessOwnerIfNotSet(USER_ID, PROCESS_KEY, null));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(BadRequestException.class)).hasMessageContaining("Owner ID cannot be empty!");
    }

    private static List<String> getSingleTenantList() {
        ArrayList<String> tenantList = new ArrayList<String>();
        tenantList.add("tenant1");
        return tenantList;
    }
}

