/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. See the NOTICE file distributed
 * with this work for additional information regarding copyright ownership.
 * Licensed under the Camunda License 1.0. You may not use this file
 * except in compliance with the Camunda License 1.0.
 */
package io.camunda.optimize.service.db.report.plan.process;

import static io.camunda.optimize.service.db.report.plan.ReportResultType.HYPER_MAP;
import static io.camunda.optimize.service.db.report.plan.ReportResultType.MAP;
import static io.camunda.optimize.service.db.report.plan.ReportResultType.NUMBER;
import static io.camunda.optimize.service.db.report.plan.ReportResultType.RAW_DATA;
import static io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_ASSIGNEE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_CANDIDATE_GROUP;
import static io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_FLOW_NODE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_INSTANCE_END_DATE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_INSTANCE_START_DATE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_NONE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_PROCESS;
import static io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_USER_TASK;
import static io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_VARIABLE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_ASSIGNEE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_CANDIDATE_GROUP;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_DURATION;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_FLOW_NODE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_FLOW_NODE_DURATION;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_FLOW_NODE_END_DATE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_FLOW_NODE_START_DATE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_INCIDENT_FLOW_NODE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_NONE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_PROCESS_INSTANCE_END_DATE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_PROCESS_INSTANCE_RUNNING_DATE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_PROCESS_INSTANCE_START_DATE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_USER_TASK;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_USER_TASK_DURATION;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_USER_TASK_END_DATE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_USER_TASK_START_DATE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_GROUP_BY_VARIABLE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy.PROCESS_INCIDENT_GROUP_BY_NONE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_FLOW_NODE_DURATION;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_FLOW_NODE_FREQUENCY;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_INCIDENT_DURATION;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_INCIDENT_FREQUENCY;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_INSTANCE_DURATION;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_INSTANCE_FREQUENCY;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_INSTANCE_PERCENTAGE;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_RAW_DATA;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_USER_TASK_DURATION;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_USER_TASK_FREQUENCY;
import static io.camunda.optimize.service.db.report.plan.process.ProcessView.PROCESS_VIEW_VARIABLE;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.db.report.plan.ReportResultType;

public enum ProcessExecutionPlan implements ExecutionPlan {
  FLOW_NODE_DURATION_GROUP_BY_FLOW_NODE_END_DATE_BY_FLOW_NODE(
      PROCESS_VIEW_FLOW_NODE_DURATION,
      PROCESS_GROUP_BY_FLOW_NODE_END_DATE,
      PROCESS_DISTRIBUTED_BY_FLOW_NODE,
      HYPER_MAP),
  FLOW_NODE_DURATION_GROUP_BY_FLOW_NODE_START_DATE_BY_FLOW_NODE(
      PROCESS_VIEW_FLOW_NODE_DURATION,
      PROCESS_GROUP_BY_FLOW_NODE_START_DATE,
      PROCESS_DISTRIBUTED_BY_FLOW_NODE,
      HYPER_MAP),
  FLOW_NODE_DURATION_GROUP_BY_FLOW_NODE_END_DATE(
      PROCESS_VIEW_FLOW_NODE_DURATION,
      PROCESS_GROUP_BY_FLOW_NODE_END_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  FLOW_NODE_DURATION_GROUP_BY_FLOW_NODE_START_DATE(
      PROCESS_VIEW_FLOW_NODE_DURATION,
      PROCESS_GROUP_BY_FLOW_NODE_START_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  FLOW_NODE_DURATION_GROUP_BY_FLOW_NODE_END_DATE_BY_PROCESS(
      PROCESS_VIEW_FLOW_NODE_DURATION,
      PROCESS_GROUP_BY_FLOW_NODE_END_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  FLOW_NODE_DURATION_GROUP_BY_FLOW_NODE_START_DATE_BY_PROCESS(
      PROCESS_VIEW_FLOW_NODE_DURATION,
      PROCESS_GROUP_BY_FLOW_NODE_START_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  FLOW_NODE_DURATION_GROUP_BY_FLOW_NODE_BY_PROCESS(
      PROCESS_VIEW_FLOW_NODE_DURATION,
      PROCESS_GROUP_BY_FLOW_NODE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  FLOW_NODE_DURATION_GROUP_BY_FLOW_NODE(
      PROCESS_VIEW_FLOW_NODE_DURATION,
      PROCESS_GROUP_BY_FLOW_NODE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  FLOW_NODE_DURATION_BY_VARIABLE_BY_FLOW_NODE(
      PROCESS_VIEW_FLOW_NODE_DURATION,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_FLOW_NODE,
      HYPER_MAP),
  FLOW_NODE_DURATION_GROUP_BY_VARIABLE(
      PROCESS_VIEW_FLOW_NODE_DURATION, PROCESS_GROUP_BY_VARIABLE, PROCESS_DISTRIBUTED_BY_NONE, MAP),
  FLOW_NODE_DURATION_BY_VARIABLE_BY_PROCESS(
      PROCESS_VIEW_FLOW_NODE_DURATION,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),

  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE_END_DATE_BY_FLOW_NODE(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE_END_DATE,
      PROCESS_DISTRIBUTED_BY_FLOW_NODE,
      HYPER_MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE_START_DATE_BY_FLOW_NODE(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE_START_DATE,
      PROCESS_DISTRIBUTED_BY_FLOW_NODE,
      HYPER_MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE_END_DATE(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE_END_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE_START_DATE(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE_START_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE_END_DATE_BY_PROCESS(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE_END_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE_START_DATE_BY_PROCESS(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE_START_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE_DURATION_BY_FLOW_NODE(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE_DURATION,
      PROCESS_DISTRIBUTED_BY_FLOW_NODE,
      HYPER_MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE_DURATION_BY_PROCESS(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE_DURATION,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE_DURATION(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE_DURATION,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE_BY_PROCESS(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_FLOW_NODE(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_FLOW_NODE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  FLOW_NODE_FREQUENCY_BY_VARIABLE_BY_FLOW_NODE(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_FLOW_NODE,
      HYPER_MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_VARIABLE_BY_PROCESS(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  FLOW_NODE_FREQUENCY_GROUP_BY_VARIABLE(
      PROCESS_VIEW_FLOW_NODE_FREQUENCY,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),

  INCIDENT_DURATION_GROUP_BY_FLOW_NODE(
      PROCESS_VIEW_INCIDENT_DURATION,
      PROCESS_GROUP_BY_INCIDENT_FLOW_NODE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  INCIDENT_DURATION_GROUP_BY_NONE(
      PROCESS_VIEW_INCIDENT_DURATION,
      PROCESS_INCIDENT_GROUP_BY_NONE,
      PROCESS_DISTRIBUTED_BY_NONE,
      NUMBER),

  INCIDENT_FREQUENCY_GROUP_BY_FLOW_NODE(
      PROCESS_VIEW_INCIDENT_FREQUENCY,
      PROCESS_GROUP_BY_INCIDENT_FLOW_NODE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  INCIDENT_FREQUENCY_GROUP_BY_NONE(
      PROCESS_VIEW_INCIDENT_FREQUENCY,
      PROCESS_INCIDENT_GROUP_BY_NONE,
      PROCESS_DISTRIBUTED_BY_NONE,
      NUMBER),

  PROCESS_INSTANCE_DURATION_GROUP_BY_END_DATE(
      PROCESS_VIEW_INSTANCE_DURATION,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_END_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_INSTANCE_DURATION_GROUP_BY_START_DATE(
      PROCESS_VIEW_INSTANCE_DURATION,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_START_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_INSTANCE_DURATION_GROUP_BY_END_DATE_BY_PROCESS(
      PROCESS_VIEW_INSTANCE_DURATION,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_END_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_GROUP_BY_START_DATE_BY_PROCESS(
      PROCESS_VIEW_INSTANCE_DURATION,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_START_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_GROUP_BY_END_DATE_BY_VARIABLE(
      PROCESS_VIEW_INSTANCE_DURATION,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_END_DATE,
      PROCESS_DISTRIBUTED_BY_VARIABLE,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_GROUP_BY_START_DATE_BY_VARIABLE(
      PROCESS_VIEW_INSTANCE_DURATION,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_START_DATE,
      PROCESS_DISTRIBUTED_BY_VARIABLE,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_GROUP_BY_NONE_BY_PROCESS(
      PROCESS_VIEW_INSTANCE_DURATION,
      PROCESS_GROUP_BY_NONE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_GROUP_BY_NONE(
      PROCESS_VIEW_INSTANCE_DURATION, PROCESS_GROUP_BY_NONE, PROCESS_DISTRIBUTED_BY_NONE, NUMBER),
  PROCESS_INSTANCE_DURATION_GROUP_BY_VARIABLE_BY_END_DATE(
      PROCESS_VIEW_INSTANCE_DURATION,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_INSTANCE_END_DATE,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_GROUP_BY_VARIABLE_BY_START_DATE(
      PROCESS_VIEW_INSTANCE_DURATION,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_INSTANCE_START_DATE,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_GROUP_BY_VARIABLE(
      PROCESS_VIEW_INSTANCE_DURATION, PROCESS_GROUP_BY_VARIABLE, PROCESS_DISTRIBUTED_BY_NONE, MAP),
  PROCESS_INSTANCE_DURATION_GROUP_BY_VARIABLE_BY_PROCESS(
      PROCESS_VIEW_INSTANCE_DURATION,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),

  PROCESS_INSTANCE_DURATION_ON_PROCESS_PART_GROUP_BY_END_DATE(
      PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_END_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_INSTANCE_DURATION_ON_PROCESS_PART_GROUP_BY_START_DATE(
      PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_START_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_INSTANCE_DURATION_ON_PROCESS_PART_GROUP_BY_END_DATE_BY_VARIABLE(
      PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_END_DATE,
      PROCESS_DISTRIBUTED_BY_VARIABLE,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_ON_PROCESS_PART_GROUP_BY_START_DATE_BY_VARIABLE(
      PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_START_DATE,
      PROCESS_DISTRIBUTED_BY_VARIABLE,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_ON_PROCESS_PART_GROUP_BY_NONE(
      PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART,
      PROCESS_GROUP_BY_NONE,
      PROCESS_DISTRIBUTED_BY_NONE,
      NUMBER),
  PROCESS_INSTANCE_DURATION_ON_PROCESS_PART_GROUP_BY_VARIABLE_BY_END_DATE(
      PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_INSTANCE_END_DATE,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_ON_PROCESS_PART_GROUP_BY_VARIABLE_BY_START_DATE(
      PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_INSTANCE_START_DATE,
      HYPER_MAP),
  PROCESS_INSTANCE_DURATION_ON_PROCESS_PART_GROUP_BY_VARIABLE(
      PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),

  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_END_DATE(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_END_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_RUNNING_DATE(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_RUNNING_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_START_DATE(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_START_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_END_DATE_BY_PROCESS(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_END_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_RUNNING_DATE_BY_PROCESS(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_RUNNING_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_START_DATE_BY_PROCESS(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_START_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_END_DATE_BY_VARIABLE(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_END_DATE,
      PROCESS_DISTRIBUTED_BY_VARIABLE,
      HYPER_MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_START_DATE_BY_VARIABLE(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_PROCESS_INSTANCE_START_DATE,
      PROCESS_DISTRIBUTED_BY_VARIABLE,
      HYPER_MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_DURATION_BY_PROCESS(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_DURATION,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_DURATION(
      PROCESS_VIEW_INSTANCE_FREQUENCY, PROCESS_GROUP_BY_DURATION, PROCESS_DISTRIBUTED_BY_NONE, MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_NONE_BY_PROCESS(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_NONE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_NONE(
      PROCESS_VIEW_INSTANCE_FREQUENCY, PROCESS_GROUP_BY_NONE, PROCESS_DISTRIBUTED_BY_NONE, NUMBER),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_VARIABLE_BY_END_DATE(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_INSTANCE_END_DATE,
      HYPER_MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_VARIABLE_BY_START_DATE(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_INSTANCE_START_DATE,
      HYPER_MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_VARIABLE_BY_PROCESS(
      PROCESS_VIEW_INSTANCE_FREQUENCY,
      PROCESS_GROUP_BY_VARIABLE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_INSTANCE_FREQUENCY_GROUP_BY_VARIABLE(
      PROCESS_VIEW_INSTANCE_FREQUENCY, PROCESS_GROUP_BY_VARIABLE, PROCESS_DISTRIBUTED_BY_NONE, MAP),

  PROCESS_INSTANCE_PERCENTAGE_GROUP_BY_NONE(
      PROCESS_VIEW_INSTANCE_PERCENTAGE, PROCESS_GROUP_BY_NONE, PROCESS_DISTRIBUTED_BY_NONE, NUMBER),

  PROCESS_RAW_PROCESS_INSTANCE_DATA_GROUP_BY_NONE(
      PROCESS_VIEW_RAW_DATA, PROCESS_GROUP_BY_NONE, PROCESS_DISTRIBUTED_BY_NONE, RAW_DATA),

  PROCESS_USER_TASK_DURATION_GROUP_BY_ASSIGNEE(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_ASSIGNEE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP,
      true),
  PROCESS_USER_TASK_DURATION_GROUP_BY_ASSIGNEE_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_ASSIGNEE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP,
      true),
  PROCESS_USER_TASK_DURATION_GROUP_BY_ASSIGNEE_BY_TASK(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_ASSIGNEE,
      PROCESS_DISTRIBUTED_BY_USER_TASK,
      HYPER_MAP,
      true),
  PROCESS_USER_TASK_DURATION_GROUP_BY_CANDIDATE_GROUP(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_CANDIDATE_GROUP,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_CANDIDATE_GROUP_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_CANDIDATE_GROUP,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_CANDIDATE_GROUP_BY_TASK(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_CANDIDATE_GROUP,
      PROCESS_DISTRIBUTED_BY_USER_TASK,
      HYPER_MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_USER_TASK_END_DATE_BY_ASSIGNEE(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK_END_DATE,
      PROCESS_DISTRIBUTED_BY_ASSIGNEE,
      HYPER_MAP,
      true),
  PROCESS_USER_TASK_DURATION_GROUP_BY_USER_TASK_START_DATE_BY_ASSIGNEE(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK_START_DATE,
      PROCESS_DISTRIBUTED_BY_ASSIGNEE,
      HYPER_MAP,
      true),
  PROCESS_USER_TASK_DURATION_GROUP_BY_USER_TASK_END_DATE_BY_CANDIDATE_GROUP(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK_END_DATE,
      PROCESS_DISTRIBUTED_BY_CANDIDATE_GROUP,
      HYPER_MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_USER_TASK_START_DATE_BY_CANDIDATE_GROUP(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK_START_DATE,
      PROCESS_DISTRIBUTED_BY_CANDIDATE_GROUP,
      HYPER_MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_USER_TASK_END_DATE(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK_END_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_USER_TASK_START_DATE(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK_START_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_USER_TASK_END_DATE_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK_END_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_USER_TASK_START_DATE_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK_START_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_USER_TASK_END_DATE_BY_TASK(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK_END_DATE,
      PROCESS_DISTRIBUTED_BY_USER_TASK,
      HYPER_MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_USER_TASK_START_DATE_BY_TASK(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK_START_DATE,
      PROCESS_DISTRIBUTED_BY_USER_TASK,
      HYPER_MAP),

  PROCESS_USER_TASK_DURATION_GROUP_BY_TASK_GROUP_BY_ASSIGNEE(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK,
      PROCESS_DISTRIBUTED_BY_ASSIGNEE,
      HYPER_MAP,
      true),
  PROCESS_USER_TASK_DURATION_GROUP_BY_TASK_GROUP_BY_CANDIDATE_GROUP(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK,
      PROCESS_DISTRIBUTED_BY_CANDIDATE_GROUP,
      HYPER_MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_TASK_GROUP_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_USER_TASK_DURATION_GROUP_BY_TASK(
      PROCESS_VIEW_USER_TASK_DURATION,
      PROCESS_GROUP_BY_USER_TASK,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),

  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_ASSIGNEE_DISTRIBUTE_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_ASSIGNEE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP,
      true),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_ASSIGNEE_DISTRIBUTE_BY_TASK(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_ASSIGNEE,
      PROCESS_DISTRIBUTED_BY_USER_TASK,
      HYPER_MAP,
      true),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_ASSIGNEE(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_ASSIGNEE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP,
      true),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_CANDIDATE_DISTRIBUTE_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_CANDIDATE_GROUP,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_CANDIDATE_DISTRIBUTE_BY_TASK(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_CANDIDATE_GROUP,
      PROCESS_DISTRIBUTED_BY_USER_TASK,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_CANDIDATE_GROUP(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_CANDIDATE_GROUP,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_END_DATE_BY_ASSIGNEE(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_END_DATE,
      PROCESS_DISTRIBUTED_BY_ASSIGNEE,
      HYPER_MAP,
      true),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_START_DATE_BY_ASSIGNEE(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_START_DATE,
      PROCESS_DISTRIBUTED_BY_ASSIGNEE,
      HYPER_MAP,
      true),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_END_DATE_BY_CANDIDATE_GROUP(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_END_DATE,
      PROCESS_DISTRIBUTED_BY_CANDIDATE_GROUP,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_START_DATE_BY_CANDIDATE_GROUP(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_START_DATE,
      PROCESS_DISTRIBUTED_BY_CANDIDATE_GROUP,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_END_DATE(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_END_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_START_DATE(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_START_DATE,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_END_DATE_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_END_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_START_DATE_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_START_DATE,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_END_DATE_BY_TASK(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_END_DATE,
      PROCESS_DISTRIBUTED_BY_USER_TASK,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_START_DATE_BY_TASK(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_START_DATE,
      PROCESS_DISTRIBUTED_BY_USER_TASK,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_DURATION_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_DURATION,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_DURATION_BY_USER_TASK(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_DURATION,
      PROCESS_DISTRIBUTED_BY_USER_TASK,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_USER_TASK_DURATION(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK_DURATION,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_TASK_BY_ASSIGNEE(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK,
      PROCESS_DISTRIBUTED_BY_ASSIGNEE,
      HYPER_MAP,
      true),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_TASK_BY_CANDIDATE_GROUP(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK,
      PROCESS_DISTRIBUTED_BY_CANDIDATE_GROUP,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_TASK_BY_PROCESS(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK,
      PROCESS_DISTRIBUTED_BY_PROCESS,
      HYPER_MAP),
  PROCESS_USER_TASK_FREQUENCY_GROUP_BY_TASK(
      PROCESS_VIEW_USER_TASK_FREQUENCY,
      PROCESS_GROUP_BY_USER_TASK,
      PROCESS_DISTRIBUTED_BY_NONE,
      MAP),

  PROCESS_VARIABLE_GROUP_BY_NONE(
      PROCESS_VIEW_VARIABLE, PROCESS_GROUP_BY_NONE, PROCESS_DISTRIBUTED_BY_NONE, NUMBER);

  private final ProcessView view;
  private final ProcessGroupBy groupBy;
  private final ProcessDistributedBy distributedBy;
  private final ReportResultType resultType;
  private final boolean assigneeReport;
  private final String commandKey;

  ProcessExecutionPlan(
      final ProcessView view,
      final ProcessGroupBy groupBy,
      final ProcessDistributedBy distributedBy,
      final ReportResultType resultType) {
    this(view, groupBy, distributedBy, resultType, false);
  }

  ProcessExecutionPlan(
      final ProcessView view,
      final ProcessGroupBy groupBy,
      final ProcessDistributedBy distributedBy,
      final ReportResultType resultType,
      final boolean assigneeReport) {
    this.view = view;
    this.groupBy = groupBy;
    this.distributedBy = distributedBy;
    this.resultType = resultType;
    this.assigneeReport = assigneeReport;
    commandKey = buildCommandKey();
  }

  private ProcessExecutionPlan(
      final ProcessView view,
      final ProcessGroupBy groupBy,
      final ProcessDistributedBy distributedBy,
      final ReportResultType resultType,
      final boolean assigneeReport,
      final String commandKey) {
    this.view = view;
    this.groupBy = groupBy;
    this.distributedBy = distributedBy;
    this.resultType = resultType;
    this.assigneeReport = assigneeReport;
    this.commandKey = commandKey;
  }

  @Override
  public boolean isRawDataReport() {
    return resultType == RAW_DATA;
  }

  private String buildCommandKey() {
    final ProcessReportDataDto processReportDataDto =
        ProcessReportDataDto.builder()
            .groupBy(groupBy.getDto())
            .distributedBy(distributedBy.getDto())
            .view(view.getProcessViewDto())
            .build();

    processReportDataDto.getConfiguration().setProcessPart(view.getProcessPartDto());

    return processReportDataDto.createCommandKeys().get(0);
  }

  public ProcessView getView() {
    return this.view;
  }

  public ProcessGroupBy getGroupBy() {
    return this.groupBy;
  }

  public ProcessDistributedBy getDistributedBy() {
    return this.distributedBy;
  }

  public ReportResultType getResultType() {
    return this.resultType;
  }

  public boolean isAssigneeReport() {
    return this.assigneeReport;
  }

  public String getCommandKey() {
    return this.commandKey;
  }
}
