/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.tomcat;

import io.camunda.optimize.rest.providers.CacheRequest;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class CacheRequestInterceptor
implements HandlerInterceptor {
    private final Logger log = LoggerFactory.getLogger(CacheRequestInterceptor.class);

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        boolean isSuccessfull = Optional.ofNullable(HttpStatus.resolve((int)response.getStatus())).map(HttpStatus::is2xxSuccessful).orElse(false);
        if (!response.containsHeader("Cache-Control") && isSuccessfull && this.hasCacheRequestAnnotation(handler)) {
            this.log.info("Adding header Cache-Control: max-age=" + this.getSecondsToMidnight() + " to response for request " + request.getRequestURI());
            response.addHeader("Cache-Control", "max-age=" + this.getSecondsToMidnight());
        }
    }

    private boolean hasCacheRequestAnnotation(Object handler) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            return method.isAnnotationPresent(CacheRequest.class);
        }
        return false;
    }

    private String getSecondsToMidnight() {
        OffsetDateTime now = LocalDateUtil.getCurrentDateTime();
        OffsetDateTime tomorrowDayStart = now.plusDays(1L).truncatedTo(ChronoUnit.DAYS);
        Duration timeToMidnight = Duration.between(now, tomorrowDayStart);
        return String.valueOf(timeToMidnight.getSeconds());
    }
}

