/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.variable;

import io.camunda.optimize.dto.optimize.query.variable.ExternalProcessVariableDto;
import io.camunda.optimize.service.db.writer.variable.ExternalProcessVariableWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ExternalVariableService {
    private final ExternalProcessVariableWriter externalProcessVariableWriter;

    public ExternalVariableService(ExternalProcessVariableWriter externalProcessVariableWriter) {
        this.externalProcessVariableWriter = externalProcessVariableWriter;
    }

    public void storeExternalProcessVariables(List<ExternalProcessVariableDto> externalProcessVariables) {
        this.externalProcessVariableWriter.writeExternalProcessVariables(this.resolveDuplicateVariableUpdatesPerProcessInstance(externalProcessVariables));
    }

    private List<ExternalProcessVariableDto> resolveDuplicateVariableUpdatesPerProcessInstance(List<ExternalProcessVariableDto> externalProcessVariables) {
        ArrayList<ExternalProcessVariableDto> deduplicatedVariables = new ArrayList<ExternalProcessVariableDto>();
        HashMap<String, List> variablesByProcessInstanceId = new HashMap<String, List>();
        for (ExternalProcessVariableDto variable : externalProcessVariables) {
            variablesByProcessInstanceId.putIfAbsent(variable.getProcessInstanceId(), new ArrayList());
            ((List)variablesByProcessInstanceId.get(variable.getProcessInstanceId())).add(variable);
        }
        variablesByProcessInstanceId.forEach((id, vars) -> deduplicatedVariables.addAll(this.resolveDuplicateVariableUpdates((List<ExternalProcessVariableDto>)vars)));
        return deduplicatedVariables;
    }

    private Collection<ExternalProcessVariableDto> resolveDuplicateVariableUpdates(List<ExternalProcessVariableDto> externalEntities) {
        return externalEntities.stream().collect(Collectors.toMap(ExternalProcessVariableDto::getVariableId, Function.identity(), (var1, var2) -> var2)).values();
    }
}

