/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisRequestDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationType;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.filter.DecisionFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.filter.EvaluationDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.filter.InputVariableFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.filter.OutputVariableFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.view.DecisionViewDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterType;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.RelativeDateFilterStartDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.RollingDateFilterStartDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.flownode.FlowNodeDateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.VariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutedFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutingFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.VariableFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.CanceledFlowNodeFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.ExecutedFlowNodeFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.ExecutingFlowNodeFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.ProcessViewDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedReportDefinitionResponseDto;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.exceptions.evaluation.ReportEvaluationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationHelper {
    protected static final Logger LOG = LoggerFactory.getLogger(ValidationHelper.class);

    private ValidationHelper() {
    }

    public static void validate(BranchAnalysisRequestDto dto) {
        ValidationHelper.ensureNotEmpty("gateway activity id", dto.getGateway());
        ValidationHelper.ensureNotEmpty("end activity id", dto.getEnd());
        ValidationHelper.ensureNotEmpty("query dto", dto);
        ValidationHelper.ensureNotEmpty("ProcessDefinitionKey", dto.getProcessDefinitionKey());
        ValidationHelper.ensureCollectionNotEmpty("ProcessDefinitionVersion", dto.getProcessDefinitionVersions());
        ValidationHelper.validateProcessFilters(dto.getFilter());
    }

    public static void ensureNotEmpty(String fieldName, Object target) {
        if (target == null || target.toString().isEmpty()) {
            throw new OptimizeValidationException(fieldName + " is not allowed to be empty or null");
        }
    }

    public static void ensureCollectionNotEmpty(String fieldName, Collection<?> target) {
        if (target == null || target.isEmpty()) {
            throw new OptimizeValidationException(fieldName + " is not allowed to be empty or null");
        }
    }

    public static void ensureNotNull(String fieldName, Object object) {
        if (object == null) {
            throw new OptimizeValidationException(fieldName + " is not allowed to be null");
        }
    }

    public static void validateCombinedReportDefinition(CombinedReportDefinitionRequestDto combinedReportDefinitionDto, RoleType currentUserRole) {
        AuthorizedReportDefinitionResponseDto authorizedReportDefinitionDto = new AuthorizedReportDefinitionResponseDto((ReportDefinitionDto)combinedReportDefinitionDto, currentUserRole);
        if (combinedReportDefinitionDto.getData() == null) {
            OptimizeValidationException ex = new OptimizeValidationException("Report data for a combined report is not allowed to be null!");
            throw new ReportEvaluationException(authorizedReportDefinitionDto, (Exception)((Object)ex));
        }
        if (((CombinedReportDataDto)combinedReportDefinitionDto.getData()).getReportIds() == null) {
            OptimizeValidationException ex = new OptimizeValidationException("Reports list for a combined report is not allowed to be null!");
            throw new ReportEvaluationException(authorizedReportDefinitionDto, (Exception)((Object)ex));
        }
    }

    private static void validateDefinitionData(ReportDataDto data) {
        if (data instanceof SingleReportDataDto) {
            SingleReportDataDto singleReportData = (SingleReportDataDto)data;
            if (data instanceof ProcessReportDataDto && !((ProcessReportDataDto)data).isManagementReport()) {
                ValidationHelper.ensureNotNull("definitionKey", singleReportData.getDefinitionKey());
            }
            ValidationHelper.ensureNotNull("definitionVersions", singleReportData.getDefinitionVersions());
        } else if (data == null) {
            throw new OptimizeValidationException("Report data is not allowed to be null!");
        }
    }

    public static boolean isValid(ReportDataDto dataDto) {
        try {
            ValidationHelper.validate(dataDto);
            return true;
        }
        catch (Exception e) {
            LOG.debug("Report Data Validation failed", (Throwable)e);
            return false;
        }
    }

    public static void validate(ReportDataDto dataDto) {
        ValidationHelper.validateDefinitionData(dataDto);
        if (dataDto instanceof ProcessReportDataDto) {
            ProcessReportDataDto processReportDataDto = (ProcessReportDataDto)dataDto;
            ValidationHelper.ensureNotNull("report data", processReportDataDto);
            ProcessViewDto viewDto = processReportDataDto.getView();
            ValidationHelper.ensureNotNull("view", viewDto);
            ValidationHelper.ensureNotNull("group by", processReportDataDto.getGroupBy());
            ValidationHelper.validateProcessFilters(processReportDataDto.getFilter());
            ValidationHelper.validateAggregationTypes(processReportDataDto.getConfiguration().getAggregationTypes());
        } else if (dataDto instanceof DecisionReportDataDto) {
            DecisionReportDataDto decisionReportDataDto = (DecisionReportDataDto)dataDto;
            ValidationHelper.ensureNotNull("report data", decisionReportDataDto);
            DecisionViewDto viewDto = decisionReportDataDto.getView();
            ValidationHelper.ensureNotNull("view", viewDto);
            ValidationHelper.ensureNotNull("group by", decisionReportDataDto.getGroupBy());
            ValidationHelper.validateDecisionFilters(decisionReportDataDto.getFilter());
            ValidationHelper.validateAggregationTypes(decisionReportDataDto.getConfiguration().getAggregationTypes());
        }
    }

    public static void validateProcessFilters(List<ProcessFilterDto<?>> filters) {
        if (filters != null) {
            for (ProcessFilterDto<?> filterDto : filters) {
                ExecutingFlowNodeFilterDto executingFlowNodeFilterDto;
                ExecutedFlowNodeFilterDataDto flowNodeFilterData;
                if (!filterDto.validApplicationLevels().contains(filterDto.getFilterLevel())) {
                    throw new OptimizeValidationException(String.format("%s is not a valid application level for this filter type", filterDto.getFilterLevel()));
                }
                if (filterDto instanceof InstanceStartDateFilterDto) {
                    InstanceStartDateFilterDto instanceStartDateFilterDto = (InstanceStartDateFilterDto)filterDto;
                    DateFilterDataDto startDateFilterDataDto = (DateFilterDataDto)instanceStartDateFilterDto.getData();
                    ValidationHelper.ensureAtLeastOneNotNull("start date filter ", startDateFilterDataDto.getStart(), startDateFilterDataDto.getEnd());
                    continue;
                }
                if (filterDto instanceof VariableFilterDto) {
                    VariableFilterDto variableFilterDto = (VariableFilterDto)filterDto;
                    VariableFilterDataDto variableFilterData = (VariableFilterDataDto)variableFilterDto.getData();
                    ValidationHelper.ensureNotEmpty("data", variableFilterData.getData());
                    ValidationHelper.ensureNotEmpty("name", variableFilterData.getName());
                    ValidationHelper.ensureNotEmpty("type", variableFilterData.getType());
                    continue;
                }
                if (filterDto instanceof ExecutedFlowNodeFilterDto) {
                    ExecutedFlowNodeFilterDto executedFlowNodeFilterDto = (ExecutedFlowNodeFilterDto)filterDto;
                    flowNodeFilterData = (ExecutedFlowNodeFilterDataDto)executedFlowNodeFilterDto.getData();
                    ValidationHelper.ensureNotEmpty("operator", flowNodeFilterData.getOperator());
                    ValidationHelper.ensureNotEmpty("values", flowNodeFilterData.getValues());
                    continue;
                }
                if (filterDto instanceof ExecutingFlowNodeFilterDto) {
                    executingFlowNodeFilterDto = (ExecutingFlowNodeFilterDto)filterDto;
                    flowNodeFilterData = (ExecutingFlowNodeFilterDataDto)executingFlowNodeFilterDto.getData();
                    ValidationHelper.ensureNotEmpty("values", flowNodeFilterData.getValues());
                    continue;
                }
                if (filterDto instanceof CanceledFlowNodeFilterDto) {
                    executingFlowNodeFilterDto = (CanceledFlowNodeFilterDto)filterDto;
                    flowNodeFilterData = (CanceledFlowNodeFilterDataDto)executingFlowNodeFilterDto.getData();
                    ValidationHelper.ensureNotEmpty("values", flowNodeFilterData.getValues());
                    continue;
                }
                if (!(filterDto instanceof FlowNodeStartDateFilterDto) && !(filterDto instanceof FlowNodeEndDateFilterDto)) continue;
                ProcessFilterDto<?> flowNodeDateFilterDto = filterDto;
                ValidationHelper.validateFlowNodeDateFilter(flowNodeDateFilterDto);
            }
        }
    }

    public static void validateAggregationTypes(Set<AggregationDto> aggregationDtos) {
        if (aggregationDtos != null) {
            aggregationDtos.forEach(aggType -> {
                Double aggValue = aggType.getValue();
                if (aggType.getType() == AggregationType.PERCENTILE) {
                    if (aggValue == null || aggValue < 0.0 || aggValue > 100.0) {
                        throw new OptimizeValidationException("Percentile aggregation values be between 0 and 100");
                    }
                } else if (aggValue != null) {
                    throw new OptimizeValidationException("Aggregation values can only be supplied for percentile aggregations");
                }
            });
        }
    }

    private static void validateFlowNodeDateFilter(ProcessFilterDto<FlowNodeDateFilterDataDto<?>> flowNodeDateFilter) {
        FlowNodeDateFilterDataDto flowNodeDateFilterDataDto = (FlowNodeDateFilterDataDto)flowNodeDateFilter.getData();
        if (DateFilterType.FIXED.equals((Object)flowNodeDateFilterDataDto.getType())) {
            ValidationHelper.ensureAtLeastOneNotNull("flowNode date filter start or end field", flowNodeDateFilterDataDto.getStart(), flowNodeDateFilterDataDto.getEnd());
        } else {
            ValidationHelper.ensureNotNull("start", flowNodeDateFilterDataDto.getStart());
        }
        if (flowNodeDateFilterDataDto.getStart() instanceof RollingDateFilterStartDto) {
            RollingDateFilterStartDto rollingStartDto = (RollingDateFilterStartDto)flowNodeDateFilterDataDto.getStart();
            ValidationHelper.ensureNotNull("unit", rollingStartDto.getUnit());
            ValidationHelper.ensureNotNull("value", rollingStartDto.getValue());
        } else if (flowNodeDateFilterDataDto.getStart() instanceof RelativeDateFilterStartDto) {
            RelativeDateFilterStartDto relativeStartDto = (RelativeDateFilterStartDto)flowNodeDateFilterDataDto.getStart();
            ValidationHelper.ensureNotNull("unit", relativeStartDto.getUnit());
            ValidationHelper.ensureNotNull("value", relativeStartDto.getValue());
        }
        if (FilterApplicationLevel.INSTANCE.equals((Object)flowNodeDateFilter.getFilterLevel())) {
            ValidationHelper.ensureCollectionNotEmpty("flowNodeIds", flowNodeDateFilterDataDto.getFlowNodeIds());
        } else {
            ValidationHelper.ensureNull("flowNodeIds", flowNodeDateFilterDataDto.getFlowNodeIds());
        }
    }

    private static void validateDecisionFilters(List<DecisionFilterDto<?>> filters) {
        if (filters != null) {
            for (DecisionFilterDto<?> filterDto : filters) {
                VariableFilterDataDto variableFilterData;
                InputVariableFilterDto variableFilterDto;
                if (filterDto instanceof EvaluationDateFilterDto) {
                    EvaluationDateFilterDto evaluationDateFilterDto = (EvaluationDateFilterDto)filterDto;
                    DateFilterDataDto evaluationDateFilterDataDto = (DateFilterDataDto)evaluationDateFilterDto.getData();
                    ValidationHelper.ensureAtLeastOneNotNull("evaluation date filter ", evaluationDateFilterDataDto.getStart(), evaluationDateFilterDataDto.getEnd());
                    continue;
                }
                if (filterDto instanceof InputVariableFilterDto) {
                    variableFilterDto = (InputVariableFilterDto)filterDto;
                    variableFilterData = (VariableFilterDataDto)variableFilterDto.getData();
                    ValidationHelper.ensureNotEmpty("data", variableFilterData.getData());
                    ValidationHelper.ensureNotEmpty("name", variableFilterData.getName());
                    ValidationHelper.ensureNotEmpty("type", variableFilterData.getType());
                    continue;
                }
                if (!(filterDto instanceof OutputVariableFilterDto)) continue;
                variableFilterDto = (OutputVariableFilterDto)filterDto;
                variableFilterData = (VariableFilterDataDto)variableFilterDto.getData();
                ValidationHelper.ensureNotEmpty("data", variableFilterData.getData());
                ValidationHelper.ensureNotEmpty("name", variableFilterData.getName());
                ValidationHelper.ensureNotEmpty("type", variableFilterData.getType());
            }
        }
    }

    private static void ensureAtLeastOneNotNull(String fieldName, Object ... objects) {
        boolean oneNotNull = Arrays.stream(objects).anyMatch(Objects::nonNull);
        if (!oneNotNull) {
            throw new OptimizeValidationException(fieldName + " at least one sub field not allowed to be empty or null");
        }
    }

    private static void ensureNull(String fieldName, Object object) {
        if (object != null) {
            throw new OptimizeValidationException(fieldName + " has to be null");
        }
    }
}

