/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateUnit;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public final class DateFilterUtil {
    private DateFilterUtil() {
    }

    public static OffsetDateTime getStartOfCurrentInterval(OffsetDateTime now, DateUnit dateUnit) {
        switch (dateUnit) {
            case MINUTES: {
                return now.with(ChronoField.SECOND_OF_MINUTE, 0L).with(ChronoField.MILLI_OF_SECOND, 0L).with(ChronoField.NANO_OF_SECOND, 0L);
            }
            case HOURS: {
                return now.with(ChronoField.MINUTE_OF_HOUR, 0L).with(ChronoField.SECOND_OF_MINUTE, 0L).with(ChronoField.MILLI_OF_SECOND, 0L).with(ChronoField.NANO_OF_SECOND, 0L);
            }
            case DAYS: {
                return now.with(LocalTime.MIN);
            }
            case WEEKS: {
                return now.with(ChronoField.DAY_OF_WEEK, 1L).with(LocalTime.MIN);
            }
            case MONTHS: {
                return now.with(ChronoField.DAY_OF_MONTH, 1L).with(LocalTime.MIN);
            }
            case QUARTERS: {
                int completedMonthsInQuarter = (now.getMonthValue() + 2) % 3;
                return now.with(ChronoField.DAY_OF_MONTH, 1L).with(LocalTime.MIN).minusMonths(completedMonthsInQuarter);
            }
            case YEARS: {
                return now.with(ChronoField.DAY_OF_YEAR, 1L).with(LocalTime.MIN);
            }
        }
        throw new OptimizeValidationException("Unknown date unit: " + String.valueOf(dateUnit));
    }

    public static OffsetDateTime getStartOfPreviousInterval(OffsetDateTime startOfCurrentInterval, DateUnit dateUnit, Long unitQuantity) {
        if (dateUnit.equals((Object)DateUnit.QUARTERS)) {
            return startOfCurrentInterval.minus(3L * unitQuantity, ChronoUnit.MONTHS);
        }
        return startOfCurrentInterval.minus(unitQuantity, DateFilterUtil.unitOf(dateUnit.getId()));
    }

    public static TemporalUnit unitOf(String unit) {
        return ChronoUnit.valueOf(unit.toUpperCase());
    }
}

