/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.rollover;

import io.camunda.optimize.service.AbstractScheduledService;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.stereotype.Component;

@Component
public class ExternalProcessVariableIndexRolloverService
extends AbstractScheduledService {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalProcessVariableIndexRolloverService.class);
    private final DatabaseClient databaseClient;
    private final ConfigurationService configurationService;

    public ExternalProcessVariableIndexRolloverService(DatabaseClient databaseClient, ConfigurationService configurationService) {
        this.databaseClient = databaseClient;
        this.configurationService = configurationService;
    }

    @Override
    protected void run() {
        this.triggerRollover();
    }

    @Override
    protected Trigger createScheduleTrigger() {
        return new PeriodicTrigger(Duration.ofMinutes(this.getScheduleIntervalInMinutes()));
    }

    public List<String> triggerRollover() {
        ArrayList<String> rolledOverIndexAliases = new ArrayList<String>();
        this.getAliasesToConsiderRolling().forEach(indexAlias -> {
            try {
                boolean isRolledOver = this.databaseClient.triggerRollover(indexAlias, this.getMaxIndexSizeGB());
                if (isRolledOver) {
                    rolledOverIndexAliases.add((String)indexAlias);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed rolling over index {}, will try again next time.", indexAlias, (Object)e);
            }
        });
        return rolledOverIndexAliases;
    }

    private Set<String> getAliasesToConsiderRolling() {
        return Collections.singleton("external-process-variable");
    }

    private int getMaxIndexSizeGB() {
        return this.configurationService.getVariableIndexRolloverConfiguration().getMaxIndexSizeGB();
    }

    private int getScheduleIntervalInMinutes() {
        return this.configurationService.getVariableIndexRolloverConfiguration().getScheduleIntervalInMinutes();
    }
}

