/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.report;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDataDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.ScopeComplianceType;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.report.SingleReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedProcessReportDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessVisualization;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizationType;
import io.camunda.optimize.dto.optimize.rest.AuthorizedReportDefinitionResponseDto;
import io.camunda.optimize.dto.optimize.rest.ConflictResponseDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemType;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.reader.ReportReader;
import io.camunda.optimize.service.db.writer.ReportWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.exceptions.UncombinableReportsException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeNonDefinitionScopeCompliantException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeNonTenantScopeCompliantException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeReportConflictException;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.relations.CollectionReferencingService;
import io.camunda.optimize.service.relations.ReportRelationService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.ReportAuthorizationService;
import io.camunda.optimize.service.util.BpmnModelUtil;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import io.camunda.optimize.service.util.DmnModelUtil;
import io.camunda.optimize.service.util.ValidationHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportService
implements CollectionReferencingService {
    private static final String DEFAULT_REPORT_NAME = "New Report";
    private static final String REPORT_NOT_IN_SAME_COLLECTION_ERROR_MESSAGE = "Either the report %s does not reside in the same collection as the combined report or both are not private entities";
    private static final Logger LOG = LoggerFactory.getLogger(ReportService.class);
    private final ReportWriter reportWriter;
    private final ReportReader reportReader;
    private final ReportAuthorizationService reportAuthorizationService;
    private final ReportRelationService reportRelationService;
    private final AuthorizedCollectionService collectionService;
    private final AbstractIdentityService identityService;
    private final DefinitionService defintionService;

    public ReportService(ReportWriter reportWriter, ReportReader reportReader, ReportAuthorizationService reportAuthorizationService, ReportRelationService reportRelationService, AuthorizedCollectionService collectionService, AbstractIdentityService identityService, DefinitionService defintionService) {
        this.reportWriter = reportWriter;
        this.reportReader = reportReader;
        this.reportAuthorizationService = reportAuthorizationService;
        this.reportRelationService = reportRelationService;
        this.collectionService = collectionService;
        this.identityService = identityService;
        this.defintionService = defintionService;
    }

    private static void copyDefinitionMetaDataToUpdate(ReportDefinitionDto from, ReportDefinitionUpdateDto to, String userId) {
        to.setId(from.getId());
        to.setName(from.getName());
        to.setDescription(from.getDescription());
        to.setLastModifier(userId);
        to.setLastModified(from.getLastModified());
    }

    @Override
    public Set<ConflictedItemDto> getConflictedItemsForCollectionDelete(CollectionDefinitionDto definition) {
        return this.reportReader.getReportsForCollectionOmitXml(definition.getId()).stream().map(reportDefinitionDto -> new ConflictedItemDto(reportDefinitionDto.getId(), ConflictedItemType.COLLECTION, reportDefinitionDto.getName())).collect(Collectors.toSet());
    }

    @Override
    public void handleCollectionDeleted(CollectionDefinitionDto definition) {
        List<ReportDefinitionDto> reportsToDelete = this.getReportsForCollection(definition.getId());
        for (ReportDefinitionDto reportDefinition : reportsToDelete) {
            this.reportRelationService.handleDeleted(reportDefinition);
        }
        this.reportWriter.deleteAllReportsOfCollection(definition.getId());
    }

    public IdResponseDto createNewSingleDecisionReport(String userId, SingleDecisionReportDefinitionRequestDto definitionDto) {
        this.ensureCompliesWithCollectionScope(userId, definitionDto.getCollectionId(), (SingleReportDefinitionDto<?>)definitionDto);
        this.validateReportDescription(definitionDto.getDescription());
        return this.createReport(userId, definitionDto, DecisionReportDataDto::new, this.reportWriter::createNewSingleDecisionReport);
    }

    public IdResponseDto createNewSingleProcessReport(String userId, SingleProcessReportDefinitionRequestDto definitionDto) {
        this.ensureCompliesWithCollectionScope(userId, definitionDto.getCollectionId(), (SingleReportDefinitionDto<?>)definitionDto);
        this.validateReportDescription(definitionDto.getDescription());
        Optional.ofNullable((ProcessReportDataDto)definitionDto.getData()).ifPresent(data -> {
            ValidationHelper.validateProcessFilters(data.getFilter());
            Optional.ofNullable(data.getConfiguration()).ifPresent(config -> ValidationHelper.validateAggregationTypes(config.getAggregationTypes()));
        });
        return this.createReport(userId, definitionDto, ProcessReportDataDto::new, this.reportWriter::createNewSingleProcessReport);
    }

    public IdResponseDto createNewCombinedProcessReport(String userId, CombinedReportDefinitionRequestDto combinedReportDefinitionDto) {
        this.validateReportDescription(combinedReportDefinitionDto.getDescription());
        this.verifyValidReportCombination(userId, combinedReportDefinitionDto.getCollectionId(), (CombinedReportDataDto)combinedReportDefinitionDto.getData());
        return this.createReport(userId, combinedReportDefinitionDto, CombinedReportDataDto::new, this.reportWriter::createNewCombinedReport);
    }

    public ConflictResponseDto getReportDeleteConflictingItems(String userId, String reportId) {
        ReportDefinitionDto currentReportVersion = this.getReportDefinition(reportId, userId).getDefinitionDto();
        return new ConflictResponseDto(this.getConflictedItemsForDeleteReport(currentReportVersion));
    }

    public IdResponseDto copyReport(String reportId, String userId, String newReportName) {
        AuthorizedReportDefinitionResponseDto authorizedReportDefinition = this.getReportDefinition(reportId, userId);
        ReportDefinitionDto oldReportDefinition = authorizedReportDefinition.getDefinitionDto();
        return this.copyAndMoveReport(reportId, userId, oldReportDefinition.getCollectionId(), newReportName, new HashMap<String, String>());
    }

    public IdResponseDto copyAndMoveReport(String reportId, String userId, String collectionId, String newReportName) {
        return this.copyAndMoveReport(reportId, userId, collectionId, newReportName, new HashMap<String, String>());
    }

    public List<IdResponseDto> getAllReportIdsInCollection(String collectionId) {
        return this.reportReader.getReportsForCollectionOmitXml(collectionId).stream().map(report -> new IdResponseDto(report.getId())).collect(Collectors.toList());
    }

    public List<ReportDefinitionDto> getAllAuthorizedReportsForIds(String userId, List<String> reportIds) {
        return this.reportReader.getAllReportsForIdsOmitXml(reportIds).stream().filter(reportDefinitionDto -> this.reportAuthorizationService.isAuthorizedToReport(userId, (ReportDefinitionDto<?>)reportDefinitionDto)).collect(Collectors.toList());
    }

    public List<ReportDefinitionDto> getAllReportsForIds(List<String> reportIds) {
        return this.reportReader.getAllReportsForIdsOmitXml(reportIds);
    }

    private IdResponseDto copyAndMoveReport(String reportId, String userId, String collectionId, String newReportName, Map<String, String> existingReportCopies) {
        return this.copyAndMoveReport(reportId, userId, collectionId, newReportName, existingReportCopies, false);
    }

    public IdResponseDto copyAndMoveReport(String reportId, String userId, String collectionId, String newReportName, Map<String, String> existingReportCopies, boolean keepSubReportNames) {
        if (reportId == null) {
            throw new OptimizeRuntimeException("reportId is null");
        }
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (existingReportCopies == null) {
            throw new OptimizeRuntimeException("existingReportCopies is null");
        }
        AuthorizedReportDefinitionResponseDto authorizedReportDefinition = this.getReportDefinition(reportId, userId);
        ReportDefinitionDto originalReportDefinition = authorizedReportDefinition.getDefinitionDto();
        if (this.isManagementOrInstantPreviewReport(originalReportDefinition)) {
            throw new OptimizeValidationException("Management and Instant Preview Reports cannot be copied");
        }
        this.collectionService.verifyUserAuthorizedToEditCollectionResources(userId, collectionId);
        String oldCollectionId = originalReportDefinition.getCollectionId();
        String newCollectionId = Objects.equals(oldCollectionId, collectionId) ? oldCollectionId : collectionId;
        String newName = newReportName != null ? newReportName : originalReportDefinition.getName() + " \u2013 Copy";
        return this.copyAndMoveReport(originalReportDefinition, userId, newName, newCollectionId, existingReportCopies, keepSubReportNames);
    }

    public ReportDefinitionDto<ReportDataDto> getReportDefinition(String reportId) {
        return this.reportReader.getReport(reportId).orElseThrow(() -> new NotFoundException("Was not able to retrieve report with id [" + reportId + "]from the database. Report does not exist."));
    }

    public AuthorizedReportDefinitionResponseDto getReportDefinition(String reportId, String userId) {
        ReportDefinitionDto report = this.reportReader.getReport(reportId).orElseThrow(() -> new NotFoundException("Was not able to retrieve report with id [" + reportId + "]from the database. Report does not exist."));
        RoleType currentUserRole = this.reportAuthorizationService.getAuthorizedRole(userId, report).orElseThrow(() -> new ForbiddenException(String.format("User [%s] is not authorized to access report [%s].", userId, reportId)));
        return new AuthorizedReportDefinitionResponseDto(report, currentUserRole);
    }

    public List<AuthorizedReportDefinitionResponseDto> findAndFilterPrivateReports(String userId) {
        List<ReportDefinitionDto> reports = this.reportReader.getAllPrivateReportsOmitXml();
        return this.filterAuthorizedReports(userId, reports).stream().sorted(Comparator.comparing(o -> ((AuthorizedReportDefinitionResponseDto)o).getDefinitionDto().getLastModified()).reversed()).collect(Collectors.toList());
    }

    public void deleteAllReportsForProcessDefinitionKey(String processDefinitionKey) {
        List<ReportDefinitionDto> reportsForDefinitionKey = this.getAllReportsForProcessDefinitionKeyOmitXml(processDefinitionKey);
        reportsForDefinitionKey.forEach(report -> this.removeReportAndAssociatedResources(report.getId(), (ReportDefinitionDto)report));
    }

    public List<ReportDefinitionDto> getAllReportsForProcessDefinitionKeyOmitXml(String processDefinitionKey) {
        return this.reportReader.getAllReportsForProcessDefinitionKeyOmitXml(processDefinitionKey);
    }

    public List<SingleProcessReportDefinitionRequestDto> getAllSingleProcessReportsForIdsOmitXml(List<String> reportIds) {
        return this.reportReader.getAllSingleProcessReportsForIdsOmitXml(reportIds);
    }

    public List<AuthorizedReportDefinitionResponseDto> findAndFilterReports(String userId, String collectionId) {
        this.collectionService.getAuthorizedCollectionDefinitionOrFail(userId, collectionId);
        List<ReportDefinitionDto> reportsInCollection = this.reportReader.getReportsForCollectionOmitXml(collectionId);
        return this.filterAuthorizedReports(userId, reportsInCollection);
    }

    private List<ReportDefinitionDto> getReportsForCollection(String collectionId) {
        return this.reportReader.getReportsForCollectionOmitXml(collectionId);
    }

    public void updateCombinedProcessReport(String userId, String combinedReportId, CombinedReportDefinitionRequestDto updatedReport) {
        ValidationHelper.ensureNotNull("data", updatedReport.getData());
        this.validateReportDescription(updatedReport.getDescription());
        ReportDefinitionDto currentReportVersion = this.getReportDefinition(combinedReportId, userId).getDefinitionDto();
        AuthorizedReportDefinitionResponseDto authorizedCombinedReport = this.getReportWithEditAuthorization(userId, currentReportVersion);
        String combinedReportCollectionId = authorizedCombinedReport.getDefinitionDto().getCollectionId();
        this.validateEntityEditorAuthorization(combinedReportCollectionId);
        CombinedProcessReportDefinitionUpdateDto reportUpdate = this.convertToCombinedProcessReportUpdate(updatedReport, userId);
        CombinedReportDataDto data = reportUpdate.getData();
        this.verifyValidReportCombination(userId, combinedReportCollectionId, data);
        this.reportWriter.updateCombinedReport((ReportDefinitionUpdateDto)reportUpdate);
    }

    public void updateSingleProcessReport(String reportId, SingleProcessReportDefinitionRequestDto updatedReport, String userId, boolean force) {
        ValidationHelper.ensureNotNull("data", updatedReport.getData());
        ValidationHelper.validateProcessFilters(((ProcessReportDataDto)updatedReport.getData()).getFilter());
        this.validateReportDescription(updatedReport.getDescription());
        Optional.ofNullable(((ProcessReportDataDto)updatedReport.getData()).getConfiguration()).ifPresent(config -> ValidationHelper.validateAggregationTypes(config.getAggregationTypes()));
        SingleProcessReportDefinitionRequestDto currentReportVersion = this.getSingleProcessReportDefinition(reportId, userId);
        if (this.isManagementOrInstantPreviewReport((ReportDefinitionDto<?>)currentReportVersion)) {
            throw new OptimizeValidationException("Management and Instant Preview Reports cannot be updated");
        }
        this.getReportWithEditAuthorization(userId, (ReportDefinitionDto)currentReportVersion);
        this.ensureCompliesWithCollectionScope(userId, currentReportVersion.getCollectionId(), (SingleReportDefinitionDto<?>)updatedReport);
        this.validateEntityEditorAuthorization(currentReportVersion.getCollectionId());
        SingleProcessReportDefinitionUpdateDto reportUpdate = this.convertToSingleProcessReportUpdate(updatedReport, userId);
        if (!force) {
            this.checkForUpdateConflictsOnSingleProcessDefinition(currentReportVersion, updatedReport);
        }
        this.reportRelationService.handleUpdated(reportId, (ReportDefinitionDto)updatedReport);
        if (this.semanticsForCombinedReportChanged(currentReportVersion, updatedReport)) {
            this.reportWriter.removeSingleReportFromCombinedReports(reportId);
        }
        this.reportWriter.updateSingleProcessReport(reportUpdate);
    }

    public void updateDefinitionXmlOfProcessReports(String definitionKey, String definitionXml) {
        this.reportWriter.updateProcessDefinitionXmlForProcessReportsWithKey(definitionKey, definitionXml);
    }

    public void updateSingleDecisionReport(String reportId, SingleDecisionReportDefinitionRequestDto updatedReport, String userId, boolean force) {
        ValidationHelper.ensureNotNull("data", updatedReport.getData());
        this.validateReportDescription(updatedReport.getDescription());
        SingleDecisionReportDefinitionRequestDto currentReportVersion = this.getSingleDecisionReportDefinition(reportId, userId);
        this.getReportWithEditAuthorization(userId, (ReportDefinitionDto)currentReportVersion);
        this.ensureCompliesWithCollectionScope(userId, currentReportVersion.getCollectionId(), (SingleReportDefinitionDto<?>)updatedReport);
        this.validateEntityEditorAuthorization(currentReportVersion.getCollectionId());
        SingleDecisionReportDefinitionUpdateDto reportUpdate = this.convertToSingleDecisionReportUpdate(updatedReport, userId);
        if (!force) {
            this.checkForUpdateConflictsOnSingleDecisionDefinition(currentReportVersion, updatedReport);
        }
        this.reportRelationService.handleUpdated(reportId, (ReportDefinitionDto)updatedReport);
        this.reportWriter.updateSingleDecisionReport(reportUpdate);
    }

    public void deleteReport(String reportId) {
        ReportDefinitionDto reportDefinition = this.getReportOrFail(reportId);
        if (this.isManagementOrInstantPreviewReport(reportDefinition)) {
            throw new OptimizeValidationException("Management and Instant Preview Reports cannot be deleted manually");
        }
        this.removeReportAndAssociatedResources(reportId, reportDefinition);
    }

    public void deleteManagementOrInstantPreviewReport(String reportId) {
        ReportDefinitionDto reportDefinition = this.getReportOrFail(reportId);
        this.removeReportAndAssociatedResources(reportId, reportDefinition);
    }

    public void deleteReportAsUser(String userId, String reportId, boolean force) {
        Set<ConflictedItemDto> conflictedItems;
        ReportDefinitionDto reportDefinition = this.getReportOrFail(reportId);
        if (this.isManagementOrInstantPreviewReport(reportDefinition)) {
            throw new OptimizeValidationException("Management and Instant Preview Reports cannot be deleted");
        }
        this.getReportWithEditAuthorization(userId, reportDefinition);
        this.validateEntityEditorAuthorization(reportDefinition.getCollectionId());
        if (!force && !(conflictedItems = this.getConflictedItemsForDeleteReport(reportDefinition)).isEmpty()) {
            throw new OptimizeReportConflictException(conflictedItems);
        }
        this.removeReportAndAssociatedResources(reportId, reportDefinition);
    }

    private void verifyValidReportCombination(String userId, String combinedReportCollectionId, CombinedReportDataDto data) {
        if (data.getReportIds() != null && !data.getReportIds().isEmpty()) {
            List<SingleProcessReportDefinitionRequestDto> reportsOfCombinedReport = this.reportReader.getAllSingleProcessReportsForIdsOmitXml(data.getReportIds());
            List reportIds = data.getReportIds();
            if (reportsOfCombinedReport.size() != reportIds.size()) {
                List reportIdsFetched = reportsOfCombinedReport.stream().map(ReportDefinitionDto::getId).collect(Collectors.toList());
                List invalidReportIds = reportIds.stream().filter(reportIdsFetched::contains).collect(Collectors.toList());
                throw new OptimizeValidationException(String.format("The following report IDs could not be found or are not single process reports: %s", invalidReportIds));
            }
            SingleProcessReportDefinitionRequestDto firstReport = reportsOfCombinedReport.get(0);
            boolean allReportsCanBeCombined = reportsOfCombinedReport.stream().peek(report -> {
                ReportDefinitionDto reportDefinition = this.getReportDefinition(report.getId(), userId).getDefinitionDto();
                if (!Objects.equals(combinedReportCollectionId, reportDefinition.getCollectionId())) {
                    throw new BadRequestException(String.format(REPORT_NOT_IN_SAME_COLLECTION_ERROR_MESSAGE, reportDefinition.getId()));
                }
            }).noneMatch(report -> this.semanticsForCombinedReportChanged(firstReport, (SingleProcessReportDefinitionRequestDto)report));
            if (allReportsCanBeCombined) {
                ProcessVisualization visualization = firstReport.getData() == null ? null : ((ProcessReportDataDto)firstReport.getData()).getVisualization();
                data.setVisualization(visualization);
            } else {
                String errorMessage = String.format("Can't create or update combined report. The following report ids are not combinable: [%s]", data.getReportIds());
                LOG.error(errorMessage);
                throw new UncombinableReportsException(errorMessage);
            }
        }
    }

    private <T extends ReportDataDto> ReportDefinitionDto<T> getReportOrFail(String reportId) {
        return this.reportReader.getReport(reportId).orElseThrow(() -> new NotFoundException("Was not able to retrieve report with id [" + reportId + "] from the database. Report does not exist."));
    }

    private void removeReportAndAssociatedResources(String reportId, ReportDefinitionDto reportDefinition) {
        this.reportRelationService.handleDeleted(reportDefinition);
        if (reportDefinition.isCombined()) {
            this.reportWriter.deleteCombinedReport(reportId);
        } else {
            this.reportWriter.removeSingleReportFromCombinedReports(reportId);
            this.reportWriter.deleteSingleReport(reportId);
        }
    }

    private <T extends ReportDefinitionDto<RD>, RD extends ReportDataDto> IdResponseDto createReport(String userId, T reportDefinition, Supplier<RD> defaultDataProvider, CreateReportMethod<RD> createReportMethod) {
        Optional<ReportDefinitionDto> optionalProvidedDefinition = Optional.ofNullable(reportDefinition);
        String collectionId = optionalProvidedDefinition.map(ReportDefinitionDto::getCollectionId).orElse(null);
        this.validateEntityEditorAuthorization(collectionId);
        this.collectionService.verifyUserAuthorizedToEditCollectionResources(userId, collectionId);
        return createReportMethod.create(userId, optionalProvidedDefinition.map(ReportDefinitionDto::getData).orElse((ReportDataDto)defaultDataProvider.get()), optionalProvidedDefinition.map(ReportDefinitionDto::getName).orElse(DEFAULT_REPORT_NAME), optionalProvidedDefinition.map(ReportDefinitionDto::getDescription).orElse(null), collectionId);
    }

    private AuthorizedReportDefinitionResponseDto getReportWithEditAuthorization(String userId, ReportDefinitionDto reportDefinition) {
        Optional<RoleType> authorizedRole = this.reportAuthorizationService.getAuthorizedRole(userId, reportDefinition);
        return authorizedRole.filter(roleType -> roleType.ordinal() >= RoleType.EDITOR.ordinal()).map(role -> new AuthorizedReportDefinitionResponseDto(reportDefinition, role)).orElseThrow(() -> new ForbiddenException("User [" + userId + "] is not authorized to edit report [" + reportDefinition.getName() + "]."));
    }

    public Set<ConflictedItemDto> getConflictedItemsFromReportDefinition(String userId, String reportId) {
        ReportDefinitionDto reportDefinitionDto = this.getReportDefinition(reportId, userId).getDefinitionDto();
        return this.getConflictedItemsForDeleteReport(reportDefinitionDto);
    }

    public void validateReportDescription(String reportDescription) {
        if (reportDescription != null) {
            if (reportDescription.length() > 400) {
                throw new OptimizeValidationException("Report descriptions cannot be greater than 400 characters");
            }
            if (reportDescription.isEmpty()) {
                throw new OptimizeValidationException("Report descriptions cannot be non-null and empty");
            }
        }
    }

    public Optional<String> updateReportDefinitionXmlIfRequiredAndReturn(ReportDefinitionDto reportDefinition) {
        ProcessReportDataDto reportData;
        ReportDataDto reportDataDto = reportDefinition.getData();
        if (reportDataDto instanceof ProcessReportDataDto && this.isHeatmapReportOnVersionAllOrLatest(reportData = (ProcessReportDataDto)reportDataDto)) {
            Optional<String> latestXML = this.defintionService.getDefinitionWithXmlAsService(DefinitionType.PROCESS, reportData.getDefinitionKey(), List.of("latest"), reportData.getTenantIds()).map(ProcessDefinitionOptimizeDto.class::cast).map(ProcessDefinitionOptimizeDto::getBpmn20Xml);
            if (latestXML.isPresent() && !latestXML.get().equals(reportData.getConfiguration().getXml())) {
                this.updateDefinitionXmlOfProcessReports(reportData.getProcessDefinitionKey(), latestXML.get());
                return latestXML;
            }
        }
        return Optional.empty();
    }

    private Set<ConflictedItemDto> mapCombinedReportsToConflictingItems(List<CombinedReportDefinitionRequestDto> combinedReportDtos) {
        return combinedReportDtos.stream().map(combinedReportDto -> new ConflictedItemDto(combinedReportDto.getId(), ConflictedItemType.COMBINED_REPORT, combinedReportDto.getName())).collect(Collectors.toSet());
    }

    private IdResponseDto copyAndMoveReport(ReportDefinitionDto originalReportDefinition, String userId, String newReportName, String newCollectionId, Map<String, String> existingReportCopies, boolean keepSubReportNames) {
        String oldCollectionId = originalReportDefinition.getCollectionId();
        this.validateEntityEditorAuthorization(oldCollectionId);
        if (!originalReportDefinition.isCombined()) {
            switch (originalReportDefinition.getReportType()) {
                case PROCESS: {
                    SingleProcessReportDefinitionRequestDto singleProcessReportDefinitionDto = (SingleProcessReportDefinitionRequestDto)originalReportDefinition;
                    this.ensureCompliesWithCollectionScope(userId, newCollectionId, (SingleReportDefinitionDto<?>)singleProcessReportDefinitionDto);
                    return this.reportWriter.createNewSingleProcessReport(userId, (ProcessReportDataDto)singleProcessReportDefinitionDto.getData(), newReportName, originalReportDefinition.getDescription(), newCollectionId);
                }
                case DECISION: {
                    SingleDecisionReportDefinitionRequestDto singleDecisionReportDefinitionDto = (SingleDecisionReportDefinitionRequestDto)originalReportDefinition;
                    this.ensureCompliesWithCollectionScope(userId, newCollectionId, (SingleReportDefinitionDto<?>)singleDecisionReportDefinitionDto);
                    return this.reportWriter.createNewSingleDecisionReport(userId, (DecisionReportDataDto)singleDecisionReportDefinitionDto.getData(), newReportName, originalReportDefinition.getDescription(), newCollectionId);
                }
            }
            throw new IllegalStateException("Unsupported reportType: " + String.valueOf(originalReportDefinition.getReportType()));
        }
        CombinedReportDefinitionRequestDto combinedReportDefinition = (CombinedReportDefinitionRequestDto)originalReportDefinition;
        return this.copyAndMoveCombinedReport(userId, newReportName, newCollectionId, oldCollectionId, combinedReportDefinition, existingReportCopies, keepSubReportNames);
    }

    private IdResponseDto copyAndMoveCombinedReport(String userId, String newName, String newCollectionId, String oldCollectionId, CombinedReportDefinitionRequestDto oldCombinedReportDef, Map<String, String> existingReportCopies, boolean keepSubReportNames) {
        CombinedReportDataDto oldCombinedReportData = (CombinedReportDataDto)oldCombinedReportDef.getData();
        CombinedReportDataDto newCombinedReportData = new CombinedReportDataDto(oldCombinedReportData.getConfiguration(), oldCombinedReportData.getVisualization(), oldCombinedReportData.getReports());
        if (!StringUtils.equals((CharSequence)newCollectionId, (CharSequence)oldCollectionId)) {
            ArrayList newReports = new ArrayList();
            ((Stream)oldCombinedReportData.getReports().stream().sequential()).peek(report -> this.ensureCompliesWithCollectionScope(userId, newCollectionId, report.getId())).forEach(combinedReportItemDto -> {
                String originalSubReportId = combinedReportItemDto.getId();
                ReportDefinitionDto report = this.reportReader.getReport(originalSubReportId).orElseThrow(() -> new NotFoundException("Was not able to retrieve report with id [" + originalSubReportId + "]from the database. Report does not exist."));
                String reportName = keepSubReportNames ? report.getName() : null;
                String subReportCopyId = (String)existingReportCopies.get(originalSubReportId);
                if (subReportCopyId == null) {
                    subReportCopyId = this.copyAndMoveReport(originalSubReportId, userId, newCollectionId, reportName, existingReportCopies).getId();
                    existingReportCopies.put(originalSubReportId, subReportCopyId);
                }
                newReports.add(combinedReportItemDto.toBuilder().id(subReportCopyId).color(combinedReportItemDto.getColor()).build());
            });
            newCombinedReportData.setReports(newReports);
        }
        return this.reportWriter.createNewCombinedReport(userId, newCombinedReportData, newName, oldCombinedReportDef.getDescription(), newCollectionId);
    }

    private Set<ConflictedItemDto> getConflictedItemsForDeleteReport(ReportDefinitionDto reportDefinition) {
        LinkedHashSet<ConflictedItemDto> conflictedItems = new LinkedHashSet<ConflictedItemDto>();
        if (!reportDefinition.isCombined()) {
            conflictedItems.addAll(this.mapCombinedReportsToConflictingItems(this.reportReader.getCombinedReportsForSimpleReport(reportDefinition.getId())));
        }
        conflictedItems.addAll(this.reportRelationService.getConflictedItemsForDeleteReport(reportDefinition));
        return conflictedItems;
    }

    public void ensureCompliesWithCollectionScope(String userId, String collectionId, String reportId) {
        ReportDefinitionDto reportDefinition = this.reportReader.getReport(reportId).orElseThrow(() -> new NotFoundException("Was not able to retrieve report with id [" + reportId + "]from the database. Report does not exist."));
        if (!reportDefinition.isCombined()) {
            SingleReportDefinitionDto singleProcessReportDefinitionDto = (SingleReportDefinitionDto)reportDefinition;
            this.ensureCompliesWithCollectionScope(userId, collectionId, singleProcessReportDefinitionDto);
        }
    }

    public void ensureCompliesWithCollectionScope(List<ReportDataDefinitionDto> definitions, DefinitionType definitionType, CollectionDefinitionDto collection) {
        definitions.forEach(definitionDto -> this.ensureCompliesWithCollectionScope(definitionDto.getKey(), definitionDto.getTenantIds(), definitionType, collection));
    }

    public boolean isReportAllowedForCollectionScope(SingleReportDefinitionDto<?> report, CollectionDefinitionDto collection) {
        return ((SingleReportDataDto)report.getData()).getDefinitions().stream().allMatch(definitionDto -> ScopeComplianceType.COMPLIANT.equals((Object)this.getScopeComplianceForReport(definitionDto.getKey(), definitionDto.getTenantIds(), report.getReportType().toDefinitionType(), collection)));
    }

    private void ensureCompliesWithCollectionScope(CollectionDefinitionDto collection, SingleReportDefinitionDto<?> report) {
        this.ensureCompliesWithCollectionScope(((SingleReportDataDto)report.getData()).getDefinitions(), report.getDefinitionType(), collection);
    }

    private void ensureCompliesWithCollectionScope(String userId, String collectionId, SingleReportDefinitionDto<?> definition) {
        if (collectionId == null) {
            return;
        }
        CollectionDefinitionDto collection = this.collectionService.getAuthorizedCollectionDefinitionOrFail(userId, collectionId).getDefinitionDto();
        this.ensureCompliesWithCollectionScope(collection, definition);
    }

    private void ensureCompliesWithCollectionScope(String definitionKey, List<String> tenantIds, DefinitionType definitionType, CollectionDefinitionDto collection) {
        ScopeComplianceType complianceLevel = this.getScopeComplianceForReport(definitionKey, tenantIds, definitionType, collection);
        if (ScopeComplianceType.NON_TENANT_COMPLIANT.equals((Object)complianceLevel)) {
            ConflictedItemDto conflictedItemDto = new ConflictedItemDto(collection.getId(), ConflictedItemType.COLLECTION, collection.getName());
            throw new OptimizeNonTenantScopeCompliantException(Set.of(conflictedItemDto));
        }
        if (ScopeComplianceType.NON_DEFINITION_COMPLIANT.equals((Object)complianceLevel)) {
            ConflictedItemDto conflictedItemDto = new ConflictedItemDto(collection.getId(), ConflictedItemType.COLLECTION, collection.getName());
            throw new OptimizeNonDefinitionScopeCompliantException(Set.of(conflictedItemDto));
        }
    }

    private void validateEntityEditorAuthorization(String collectionId) {
        if (collectionId == null && !this.identityService.getEnabledAuthorizations().contains((Object)AuthorizationType.ENTITY_EDITOR)) {
            throw new ForbiddenException("User is not an authorized entity editor");
        }
    }

    private ScopeComplianceType getScopeComplianceForReport(String definitionKey, List<String> tenantIds, DefinitionType definitionType, CollectionDefinitionDto collection) {
        if (definitionKey == null) {
            return ScopeComplianceType.COMPLIANT;
        }
        List compliances = ((CollectionDataDto)collection.getData()).getScope().stream().map(scope -> scope.getComplianceType(definitionType, definitionKey, tenantIds)).collect(Collectors.toList());
        boolean scopeCompliant = compliances.stream().anyMatch(compliance -> compliance.equals((Object)ScopeComplianceType.COMPLIANT));
        if (scopeCompliant) {
            return ScopeComplianceType.COMPLIANT;
        }
        boolean definitionCompliantButNonTenantCompliant = compliances.stream().anyMatch(compliance -> compliance.equals((Object)ScopeComplianceType.NON_TENANT_COMPLIANT));
        if (definitionCompliantButNonTenantCompliant) {
            return ScopeComplianceType.NON_TENANT_COMPLIANT;
        }
        return ScopeComplianceType.NON_DEFINITION_COMPLIANT;
    }

    private void checkForUpdateConflictsOnSingleProcessDefinition(SingleProcessReportDefinitionRequestDto currentReportVersion, SingleProcessReportDefinitionRequestDto reportUpdateDto) {
        LinkedHashSet<ConflictedItemDto> conflictedItems = new LinkedHashSet<ConflictedItemDto>();
        String reportId = currentReportVersion.getId();
        if (this.semanticsForCombinedReportChanged(currentReportVersion, reportUpdateDto)) {
            conflictedItems.addAll(this.mapCombinedReportsToConflictingItems(this.reportReader.getCombinedReportsForSimpleReport(reportId)));
        }
        conflictedItems.addAll(this.reportRelationService.getConflictedItemsForUpdatedReport((ReportDefinitionDto)currentReportVersion, (ReportDefinitionDto)reportUpdateDto));
        if (!conflictedItems.isEmpty()) {
            throw new OptimizeReportConflictException(conflictedItems);
        }
    }

    private void checkForUpdateConflictsOnSingleDecisionDefinition(SingleDecisionReportDefinitionRequestDto currentReportVersion, SingleDecisionReportDefinitionRequestDto reportUpdateDto) {
        Set<ConflictedItemDto> conflictedItems = this.reportRelationService.getConflictedItemsForUpdatedReport((ReportDefinitionDto)currentReportVersion, (ReportDefinitionDto)reportUpdateDto);
        if (!conflictedItems.isEmpty()) {
            throw new OptimizeReportConflictException(conflictedItems);
        }
    }

    private boolean semanticsForCombinedReportChanged(SingleProcessReportDefinitionRequestDto firstReport, SingleProcessReportDefinitionRequestDto secondReport) {
        boolean result = false;
        if (firstReport.getData() != null) {
            ProcessReportDataDto oldData = (ProcessReportDataDto)firstReport.getData();
            ProcessReportDataDto newData = (ProcessReportDataDto)secondReport.getData();
            result = !newData.isCombinable((Object)oldData);
        }
        return result;
    }

    private SingleProcessReportDefinitionUpdateDto convertToSingleProcessReportUpdate(SingleProcessReportDefinitionRequestDto updatedReport, String userId) {
        SingleProcessReportDefinitionUpdateDto reportUpdate = new SingleProcessReportDefinitionUpdateDto();
        ReportService.copyDefinitionMetaDataToUpdate((ReportDefinitionDto)updatedReport, (ReportDefinitionUpdateDto)reportUpdate, userId);
        reportUpdate.setData((ProcessReportDataDto)updatedReport.getData());
        String xml = reportUpdate.getData().getConfiguration().getXml();
        if (xml != null) {
            String definitionKey = reportUpdate.getData().getDefinitionKey();
            reportUpdate.getData().setProcessDefinitionName(BpmnModelUtil.extractProcessDefinitionName(definitionKey, xml).orElse(definitionKey));
        }
        return reportUpdate;
    }

    private SingleDecisionReportDefinitionUpdateDto convertToSingleDecisionReportUpdate(SingleDecisionReportDefinitionRequestDto updatedReport, String userId) {
        SingleDecisionReportDefinitionUpdateDto reportUpdate = new SingleDecisionReportDefinitionUpdateDto();
        ReportService.copyDefinitionMetaDataToUpdate((ReportDefinitionDto)updatedReport, (ReportDefinitionUpdateDto)reportUpdate, userId);
        reportUpdate.setData((DecisionReportDataDto)updatedReport.getData());
        String xml = reportUpdate.getData().getConfiguration().getXml();
        if (xml != null) {
            String definitionKey = reportUpdate.getData().getDecisionDefinitionKey();
            reportUpdate.getData().setDecisionDefinitionName(DmnModelUtil.extractDecisionDefinitionName(definitionKey, xml).orElse(definitionKey));
        }
        return reportUpdate;
    }

    private CombinedProcessReportDefinitionUpdateDto convertToCombinedProcessReportUpdate(CombinedReportDefinitionRequestDto updatedReport, String userId) {
        CombinedProcessReportDefinitionUpdateDto reportUpdate = new CombinedProcessReportDefinitionUpdateDto();
        ReportService.copyDefinitionMetaDataToUpdate((ReportDefinitionDto)updatedReport, (ReportDefinitionUpdateDto)reportUpdate, userId);
        reportUpdate.setData((CombinedReportDataDto)updatedReport.getData());
        return reportUpdate;
    }

    private SingleProcessReportDefinitionRequestDto getSingleProcessReportDefinition(String reportId, String userId) {
        SingleProcessReportDefinitionRequestDto report = this.reportReader.getSingleProcessReportOmitXml(reportId).orElseThrow(() -> new NotFoundException("Single process report with id [" + reportId + "] does not exist!"));
        if (!this.reportAuthorizationService.isAuthorizedToReport(userId, (ReportDefinitionDto<?>)report)) {
            throw new ForbiddenException("User [" + userId + "] is not authorized to access or edit report [" + report.getName() + "].");
        }
        return report;
    }

    private SingleDecisionReportDefinitionRequestDto getSingleDecisionReportDefinition(String reportId, String userId) {
        SingleDecisionReportDefinitionRequestDto report = this.reportReader.getSingleDecisionReportOmitXml(reportId).orElseThrow(() -> new NotFoundException("Single decision report with id [" + reportId + "] does not exist!"));
        if (!this.reportAuthorizationService.isAuthorizedToReport(userId, (ReportDefinitionDto<?>)report)) {
            throw new ForbiddenException("User [" + userId + "] is not authorized to access or edit report [" + report.getName() + "].");
        }
        return report;
    }

    public Set<String> filterAuthorizedReportIds(String userId, Set<String> reportIds) {
        List<ReportDefinitionDto> reports = this.reportReader.getAllReportsForIdsOmitXml(new ArrayList<String>(reportIds));
        return this.filterAuthorizedReports(userId, reports).stream().map(report -> report.getDefinitionDto().getId()).collect(Collectors.toSet());
    }

    private List<AuthorizedReportDefinitionResponseDto> filterAuthorizedReports(String userId, List<ReportDefinitionDto> reports) {
        return reports.stream().map(report -> Pair.of((Object)report, this.reportAuthorizationService.getAuthorizedRole(userId, (ReportDefinitionDto<?>)report))).filter(reportAndRole -> ((Optional)reportAndRole.getValue()).isPresent()).map(reportAndRole -> new AuthorizedReportDefinitionResponseDto((ReportDefinitionDto)reportAndRole.getKey(), (RoleType)((Optional)reportAndRole.getValue()).get())).collect(Collectors.toList());
    }

    private boolean isManagementOrInstantPreviewReport(ReportDefinitionDto<?> reportDefinition) {
        return reportDefinition instanceof SingleProcessReportDefinitionRequestDto && (((ProcessReportDataDto)((SingleProcessReportDefinitionRequestDto)reportDefinition).getData()).isManagementReport() || ((ProcessReportDataDto)((SingleProcessReportDefinitionRequestDto)reportDefinition).getData()).isInstantPreviewReport());
    }

    private boolean isHeatmapReportOnVersionAllOrLatest(ProcessReportDataDto reportData) {
        return ProcessVisualization.HEAT.equals((Object)reportData.getVisualization()) && DefinitionVersionHandlingUtil.isDefinitionVersionSetToAllOrLatest(reportData.getDefinitionVersions());
    }

    @FunctionalInterface
    private static interface CreateReportMethod<RD extends ReportDataDto> {
        public IdResponseDto create(String var1, RD var2, String var3, String var4, String var5);
    }
}

