/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.onboarding;

import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.reader.ProcessOverviewReader;
import io.camunda.optimize.service.email.EmailService;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.util.RootUrlGenerator;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OnboardingEmailNotificationService {
    public static final String DASHBOARD_LINK_TEMPLATE = "%s/dashboard/instant/%s";
    public static final String EMAIL_SUBJECT = "You've got insights from Optimize for your new process";
    private static final String ONBOARDING_EMAIL_TEMPLATE = "onboardingEmailTemplate.ftl";
    private static final Logger LOG = LoggerFactory.getLogger(OnboardingEmailNotificationService.class);
    private final EmailService emailService;
    private final ProcessOverviewReader processOverviewReader;
    private final AbstractIdentityService identityService;
    private final DefinitionService definitionService;
    private final RootUrlGenerator rootUrlGenerator;

    public OnboardingEmailNotificationService(EmailService emailService, ProcessOverviewReader processOverviewReader, AbstractIdentityService identityService, DefinitionService definitionService, RootUrlGenerator rootUrlGenerator) {
        this.emailService = emailService;
        this.processOverviewReader = processOverviewReader;
        this.identityService = identityService;
        this.definitionService = definitionService;
        this.rootUrlGenerator = rootUrlGenerator;
    }

    public void sendOnboardingEmailWithErrorHandling(String processKey) {
        if (processKey == null) {
            throw new IllegalArgumentException("processKey must not be null");
        }
        Optional<ProcessOverviewDto> optProcessOverview = this.processOverviewReader.getProcessOverviewByKey(processKey);
        if (optProcessOverview.isPresent()) {
            ProcessOverviewDto overviewDto = optProcessOverview.get();
            String ownerId = overviewDto.getOwner();
            Optional<UserDto> optProcessOwner = this.identityService.getUserById(ownerId);
            if (optProcessOwner.isPresent()) {
                UserDto processOwner = optProcessOwner.get();
                String definitionName = this.definitionService.getLatestCachedDefinitionOnAnyTenant(DefinitionType.PROCESS, overviewDto.getProcessDefinitionKey()).map(DefinitionOptimizeResponseDto::getName).orElse(overviewDto.getProcessDefinitionKey());
                this.emailService.sendTemplatedEmailWithErrorHandling(processOwner.getEmail(), EMAIL_SUBJECT, ONBOARDING_EMAIL_TEMPLATE, this.createInputsForTemplate(processOwner.getName(), definitionName, this.generateDashboardLinkForProcess(processKey)));
            } else {
                LOG.warn(String.format("No user found for owner user ID %s of process %s, therefore no onboarding email will be sent.", ownerId, processKey));
            }
        } else {
            LOG.warn(String.format("No overview for Process definition %s could be found, therefore not able to determine a valid owner. No onboarding email will be sent.", processKey));
        }
    }

    private Map<String, Object> createInputsForTemplate(String ownerName, String processDefinitionName, String dashboardLink) {
        return Map.of("ownerName", ownerName, "processName", processDefinitionName, "dashboardLink", dashboardLink);
    }

    public String generateDashboardLinkForProcess(String processKey) {
        String rootUrl = this.rootUrlGenerator.getRootUrl() + "/#";
        return String.format(DASHBOARD_LINK_TEMPLATE, rootUrl, processKey);
    }
}

