/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.onboarding;

import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.cloud.panelnotifications.PanelNotificationDataDto;
import io.camunda.optimize.dto.optimize.cloud.panelnotifications.PanelNotificationMetaDataDto;
import io.camunda.optimize.dto.optimize.cloud.panelnotifications.PanelNotificationRequestDto;
import io.camunda.optimize.rest.cloud.CCSaaSNotificationClient;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.util.PanelNotificationConstants;
import io.camunda.optimize.service.util.RootUrlGenerator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class CCSaaSOnboardingPanelNotificationService {
    public static final String INSTANT_DASHBOARD_LINK_TEMPLATE = "%s/dashboard/instant/%s";
    private static final Logger LOG = LoggerFactory.getLogger(CCSaaSOnboardingPanelNotificationService.class);
    private final CCSaaSNotificationClient notificationClient;
    private final ConfigurationService configurationService;
    private final DefinitionService definitionService;
    private final RootUrlGenerator rootUrlGenerator;

    public CCSaaSOnboardingPanelNotificationService(CCSaaSNotificationClient notificationClient, ConfigurationService configurationService, DefinitionService definitionService, RootUrlGenerator rootUrlGenerator) {
        this.notificationClient = notificationClient;
        this.configurationService = configurationService;
        this.definitionService = definitionService;
        this.rootUrlGenerator = rootUrlGenerator;
    }

    public void sendOnboardingPanelNotification(String processKey) {
        this.notificationClient.sendPanelNotificationToOrg(PanelNotificationRequestDto.builder().notification(this.createPanelNotificationData(this.createUniqueNotificationId(processKey), this.configurationService.getAuthConfiguration().getCloudAuthConfiguration().getOrganizationId(), processKey, this.createPanelNotificationContent(this.getProcessName(processKey)))).build());
    }

    private PanelNotificationDataDto createPanelNotificationData(String uniqueId, String orgId, String processKey, String notificationContent) {
        return PanelNotificationDataDto.builder().uniqueId(uniqueId).source("optimize").type("org").orgId(orgId).title("See how your process is doing").description(notificationContent).meta(PanelNotificationMetaDataDto.builder().permissions(PanelNotificationConstants.OPTIMIZE_USER_PERMISSIONS).identifier("initialVisitToInstantDashboard").href(this.createInstantPreviewDashboardLink(processKey)).label("View instant preview dashboard").build()).build();
    }

    private String createPanelNotificationContent(String processName) {
        return String.format("Your first process of %s was started successfully. Track the status in the instant preview dashboard.", processName);
    }

    private String createInstantPreviewDashboardLink(String processKey) {
        return String.format(INSTANT_DASHBOARD_LINK_TEMPLATE, this.generateRootDashboardLink(), processKey);
    }

    private String createUniqueNotificationId(String processKey) {
        return String.format("%s_%s", "initialVisitToInstantDashboard", processKey);
    }

    public String generateRootDashboardLink() {
        String rootUrl = this.rootUrlGenerator.getRootUrl();
        return String.format("%s/#", rootUrl);
    }

    private String getProcessName(String processKey) {
        return this.definitionService.getDefinition(DefinitionType.PROCESS, processKey, List.of("all"), Collections.emptyList()).map(DefinitionOptimizeResponseDto::getName).orElse(processKey);
    }
}

