/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.mediator.factory;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.datasource.ZeebeDataSourceDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.writer.ProcessDefinitionWriter;
import io.camunda.optimize.service.importing.ImportIndexHandlerRegistry;
import io.camunda.optimize.service.importing.ImportMediator;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeProcessDefinitionImportService;
import io.camunda.optimize.service.importing.zeebe.db.ZeebeProcessDefinitionFetcher;
import io.camunda.optimize.service.importing.zeebe.mediator.ZeebeProcessDefinitionImportMediator;
import io.camunda.optimize.service.importing.zeebe.mediator.factory.AbstractZeebeImportMediatorFactory;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.stereotype.Component;

@Component
public class ZeebeProcessDefinitionImportMediatorFactory
extends AbstractZeebeImportMediatorFactory {
    private final ProcessDefinitionWriter processDefinitionWriter;

    public ZeebeProcessDefinitionImportMediatorFactory(BeanFactory beanFactory, ImportIndexHandlerRegistry importIndexHandlerRegistry, ConfigurationService configurationService, ProcessDefinitionWriter processDefinitionWriter, ObjectMapper objectMapper, DatabaseClient databaseClient) {
        super(beanFactory, importIndexHandlerRegistry, configurationService, objectMapper, databaseClient);
        this.processDefinitionWriter = processDefinitionWriter;
    }

    @Override
    public List<ImportMediator> createMediators(ZeebeDataSourceDto zeebeDataSourceDto) {
        return Collections.singletonList(new ZeebeProcessDefinitionImportMediator(this.importIndexHandlerRegistry.getZeebeProcessDefinitionImportIndexHandler(zeebeDataSourceDto.getPartitionId()), (ZeebeProcessDefinitionFetcher)this.beanFactory.getBean(ZeebeProcessDefinitionFetcher.class, new Object[]{zeebeDataSourceDto.getPartitionId(), this.databaseClient, this.objectMapper, this.configurationService}), new ZeebeProcessDefinitionImportService(this.configurationService, this.processDefinitionWriter, zeebeDataSourceDto.getPartitionId(), this.databaseClient), this.configurationService, new BackoffCalculator(this.configurationService)));
    }
}

