/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.mediator;

import io.camunda.optimize.MetricEnum;
import io.camunda.optimize.OptimizeMetrics;
import io.camunda.optimize.dto.zeebe.variable.ZeebeVariableRecordDto;
import io.camunda.optimize.service.importing.PositionBasedImportMediator;
import io.camunda.optimize.service.importing.engine.mediator.MediatorRank;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeVariableImportService;
import io.camunda.optimize.service.importing.zeebe.db.ZeebeVariableFetcher;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeVariableImportIndexHandler;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.List;

public class ZeebeVariableImportMediator
extends PositionBasedImportMediator<ZeebeVariableImportIndexHandler, ZeebeVariableRecordDto> {
    private final ZeebeVariableFetcher zeebeVariableFetcher;

    public ZeebeVariableImportMediator(ZeebeVariableImportIndexHandler importIndexHandler, ZeebeVariableFetcher zeebeVariableFetcher, ZeebeVariableImportService importService, ConfigurationService configurationService, BackoffCalculator idleBackoffCalculator) {
        this.importIndexHandler = importIndexHandler;
        this.zeebeVariableFetcher = zeebeVariableFetcher;
        this.importService = importService;
        this.configurationService = configurationService;
        this.idleBackoffCalculator = idleBackoffCalculator;
    }

    @Override
    public MediatorRank getRank() {
        return MediatorRank.INSTANCE_SUB_ENTITIES;
    }

    @Override
    protected boolean importNextPage(Runnable importCompleteCallback) {
        return this.importNextPagePositionBased(this.getVariables(), importCompleteCallback);
    }

    @Override
    protected String getRecordType() {
        return ValueType.VARIABLE.name();
    }

    @Override
    protected Integer getPartitionId() {
        return this.zeebeVariableFetcher.getPartitionId();
    }

    private List<ZeebeVariableRecordDto> getVariables() {
        return (List)OptimizeMetrics.getTimer(MetricEnum.NEW_PAGE_FETCH_TIME_METRIC, this.getRecordType(), this.getPartitionId()).record(() -> this.zeebeVariableFetcher.getZeebeRecordsForPrefixAndPartitionFrom(((ZeebeVariableImportIndexHandler)this.importIndexHandler).getNextPage()));
    }
}

