/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.mediator;

import io.camunda.optimize.MetricEnum;
import io.camunda.optimize.OptimizeMetrics;
import io.camunda.optimize.dto.zeebe.process.ZeebeProcessInstanceRecordDto;
import io.camunda.optimize.service.importing.PositionBasedImportMediator;
import io.camunda.optimize.service.importing.engine.mediator.MediatorRank;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeProcessInstanceImportService;
import io.camunda.optimize.service.importing.zeebe.db.ZeebeProcessInstanceFetcher;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeProcessInstanceImportIndexHandler;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ZeebeProcessInstanceImportMediator
extends PositionBasedImportMediator<ZeebeProcessInstanceImportIndexHandler, ZeebeProcessInstanceRecordDto> {
    private final ZeebeProcessInstanceFetcher zeebeProcessInstanceFetcher;

    public ZeebeProcessInstanceImportMediator(ZeebeProcessInstanceImportIndexHandler importIndexHandler, ZeebeProcessInstanceFetcher zeebeProcessInstanceFetcher, ZeebeProcessInstanceImportService importService, ConfigurationService configurationService, BackoffCalculator idleBackoffCalculator) {
        this.importIndexHandler = importIndexHandler;
        this.zeebeProcessInstanceFetcher = zeebeProcessInstanceFetcher;
        this.importService = importService;
        this.configurationService = configurationService;
        this.idleBackoffCalculator = idleBackoffCalculator;
    }

    @Override
    public MediatorRank getRank() {
        return MediatorRank.INSTANCE;
    }

    @Override
    protected boolean importNextPage(Runnable importCompleteCallback) {
        return this.importNextPagePositionBased(this.getProcesses(), importCompleteCallback);
    }

    @Override
    protected String getRecordType() {
        return ValueType.PROCESS_INSTANCE.name();
    }

    @Override
    protected Integer getPartitionId() {
        return this.zeebeProcessInstanceFetcher.getPartitionId();
    }

    private List<ZeebeProcessInstanceRecordDto> getProcesses() {
        return (List)OptimizeMetrics.getTimer(MetricEnum.NEW_PAGE_FETCH_TIME_METRIC, this.getRecordType(), this.getPartitionId()).record(() -> this.zeebeProcessInstanceFetcher.getZeebeRecordsForPrefixAndPartitionFrom(((ZeebeProcessInstanceImportIndexHandler)this.importIndexHandler).getNextPage()));
    }
}

