/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.ingested.mediator;

import io.camunda.optimize.dto.optimize.index.TimestampBasedImportIndexDto;
import io.camunda.optimize.service.importing.ImportIndexHandler;
import io.camunda.optimize.service.importing.ImportIndexHandlerRegistry;
import io.camunda.optimize.service.importing.ImportMediator;
import io.camunda.optimize.service.importing.engine.mediator.AbstractStoreIndexesImportMediator;
import io.camunda.optimize.service.importing.engine.service.StoreTimestampBasedImportIndexImportService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class StoreIngestedImportProgressMediator
extends AbstractStoreIndexesImportMediator<StoreTimestampBasedImportIndexImportService>
implements ImportMediator {
    private static final Logger LOG = LoggerFactory.getLogger(StoreIngestedImportProgressMediator.class);
    private final ImportIndexHandlerRegistry importIndexHandlerRegistry;

    public StoreIngestedImportProgressMediator(ImportIndexHandlerRegistry importIndexHandlerRegistry, StoreTimestampBasedImportIndexImportService importService, ConfigurationService configurationService) {
        super(importService, configurationService);
        this.importIndexHandlerRegistry = importIndexHandlerRegistry;
    }

    @Override
    public CompletableFuture<Void> runImport() {
        CompletableFuture<Void> importCompleted = new CompletableFuture<Void>();
        this.dateUntilJobCreationIsBlocked = this.calculateDateUntilJobCreationIsBlocked();
        try {
            List<TimestampBasedImportIndexDto> importIndexes = this.importIndexHandlerRegistry.getAllIngestedImportHandlers().stream().map(ImportIndexHandler::getIndexStateDto).filter(Objects::nonNull).map(TimestampBasedImportIndexDto.class::cast).collect(Collectors.toList());
            ((StoreTimestampBasedImportIndexImportService)this.importService).executeImport(importIndexes, () -> importCompleted.complete(null));
        }
        catch (Exception e) {
            LOG.error("Could not execute import for storing ingested import information!", (Throwable)e);
            importCompleted.complete(null);
        }
        return importCompleted;
    }
}

