/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.ingested.handler;

import io.camunda.optimize.dto.optimize.datasource.DataSourceDto;
import io.camunda.optimize.dto.optimize.datasource.IngestedDataSourceDto;
import io.camunda.optimize.dto.optimize.index.TimestampBasedImportIndexDto;
import io.camunda.optimize.service.db.reader.importindex.TimestampBasedImportIndexReader;
import io.camunda.optimize.service.importing.ImportIndexHandler;
import io.camunda.optimize.service.importing.page.TimestampBasedImportPage;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import jakarta.annotation.PostConstruct;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ExternalVariableUpdateImportIndexHandler
implements ImportIndexHandler<TimestampBasedImportPage, TimestampBasedImportIndexDto> {
    public static final String EXTERNAL_VARIABLE_UPDATE_IMPORT_INDEX_DOC_ID = "externalVariableUpdateImportIndex";
    public static final OffsetDateTime BEGINNING_OF_TIME = OffsetDateTime.ofInstant(Instant.EPOCH, ZoneId.systemDefault());
    @Autowired
    protected ConfigurationService configurationService;
    @Autowired
    protected TimestampBasedImportIndexReader importIndexReader;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected IngestedDataSourceDto dataSource;
    private OffsetDateTime lastImportExecutionTimestamp = BEGINNING_OF_TIME;
    private OffsetDateTime timestampOfLastEntity = BEGINNING_OF_TIME;
    private OffsetDateTime persistedTimestampOfLastEntity = BEGINNING_OF_TIME;

    @PostConstruct
    protected void init() {
        Optional<TimestampBasedImportIndexDto> dto = this.importIndexReader.getImportIndex(this.getDatabaseDocID(), this.getDataSource());
        if (dto.isPresent()) {
            TimestampBasedImportIndexDto loadedImportIndex = dto.get();
            this.updateLastPersistedEntityTimestamp(loadedImportIndex.getTimestampOfLastEntity());
            this.updatePendingLastEntityTimestamp(loadedImportIndex.getTimestampOfLastEntity());
            this.updateLastImportExecutionTimestamp(loadedImportIndex.getLastImportExecutionTimestamp());
        }
    }

    @Override
    public TimestampBasedImportPage getNextPage() {
        TimestampBasedImportPage page = new TimestampBasedImportPage();
        page.setTimestampOfLastEntity(this.timestampOfLastEntity);
        return page;
    }

    @Override
    public TimestampBasedImportIndexDto getIndexStateDto() {
        TimestampBasedImportIndexDto indexToStore = new TimestampBasedImportIndexDto();
        indexToStore.setLastImportExecutionTimestamp(this.lastImportExecutionTimestamp);
        indexToStore.setTimestampOfLastEntity(this.persistedTimestampOfLastEntity);
        indexToStore.setDataSource((DataSourceDto)this.getDataSource());
        indexToStore.setDbTypeIndexRefersTo(this.getDatabaseDocID());
        return indexToStore;
    }

    @Override
    public void resetImportIndex() {
        this.updateLastImportExecutionTimestamp(BEGINNING_OF_TIME);
        this.updateLastPersistedEntityTimestamp(BEGINNING_OF_TIME);
        this.updatePendingLastEntityTimestamp(BEGINNING_OF_TIME);
    }

    public String getDataSourceAlias() {
        return "optimize";
    }

    public OffsetDateTime getTimestampOfLastEntity() {
        return this.timestampOfLastEntity;
    }

    public void updateLastImportExecutionTimestamp() {
        this.updateLastImportExecutionTimestamp(LocalDateUtil.getCurrentDateTime());
    }

    public void updateTimestampOfLastEntity(OffsetDateTime timestamp) {
        OffsetDateTime backOffWindowStart = this.reduceByCurrentTimeBackoff(OffsetDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()));
        if (timestamp.isAfter(backOffWindowStart)) {
            this.logger.info("Timestamp is in the current time backoff window of {}ms, will save begin of backoff window as last timestamp", (Object)this.getTipOfTimeBackoffMilliseconds());
            this.updateLastPersistedEntityTimestamp(backOffWindowStart);
        } else {
            this.updateLastPersistedEntityTimestamp(timestamp);
        }
    }

    public void updatePendingTimestampOfLastEntity(OffsetDateTime timestamp) {
        OffsetDateTime backOffWindowStart = this.reduceByCurrentTimeBackoff(OffsetDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()));
        if (timestamp.isAfter(backOffWindowStart)) {
            this.logger.info("Timestamp is in the current time backoff window of {}ms, will save begin of backoff window as last timestamp", (Object)this.getTipOfTimeBackoffMilliseconds());
            this.updatePendingLastEntityTimestamp(backOffWindowStart);
        } else {
            this.updatePendingLastEntityTimestamp(timestamp);
        }
    }

    private String getDatabaseDocID() {
        return EXTERNAL_VARIABLE_UPDATE_IMPORT_INDEX_DOC_ID;
    }

    private IngestedDataSourceDto getDataSource() {
        return new IngestedDataSourceDto(this.getDataSourceAlias());
    }

    private void updateLastPersistedEntityTimestamp(OffsetDateTime timestamp) {
        this.persistedTimestampOfLastEntity = timestamp;
    }

    private void updateLastImportExecutionTimestamp(OffsetDateTime timestamp) {
        this.lastImportExecutionTimestamp = timestamp;
    }

    private void updatePendingLastEntityTimestamp(OffsetDateTime timestamp) {
        this.timestampOfLastEntity = timestamp;
    }

    private OffsetDateTime reduceByCurrentTimeBackoff(OffsetDateTime currentDateTime) {
        return currentDateTime.minus(this.getTipOfTimeBackoffMilliseconds(), ChronoUnit.MILLIS);
    }

    private int getTipOfTimeBackoffMilliseconds() {
        return this.configurationService.getCurrentTimeBackoffMilliseconds();
    }
}

