/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.engine.service.zeebe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableUpdateDto;
import io.camunda.optimize.dto.optimize.query.variable.SimpleProcessVariableDto;
import io.camunda.optimize.dto.zeebe.ZeebeRecordDto;
import io.camunda.optimize.dto.zeebe.variable.ZeebeVariableDataDto;
import io.camunda.optimize.dto.zeebe.variable.ZeebeVariableRecordDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.writer.ProcessInstanceWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.importing.engine.service.ObjectVariableService;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeProcessInstanceSubEntityImportService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class ZeebeVariableImportService
extends ZeebeProcessInstanceSubEntityImportService<ZeebeVariableRecordDto> {
    private static final Map<String, Object> OBJECT_VALUE_INFO = Map.of("serializationDataFormat", MediaType.APPLICATION_JSON);
    private static final Set<VariableIntent> INTENTS_TO_IMPORT = Set.of(VariableIntent.CREATED, VariableIntent.UPDATED);
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeVariableImportService.class);
    private final ObjectMapper objectMapper;
    private final ObjectVariableService objectVariableService;

    public ZeebeVariableImportService(ConfigurationService configurationService, ProcessInstanceWriter processInstanceWriter, int partitionId, ObjectMapper objectMapper, ProcessDefinitionReader processDefinitionReader, ObjectVariableService objectVariableService, DatabaseClient databaseClient) {
        super(configurationService, processInstanceWriter, partitionId, processDefinitionReader, databaseClient, "variable");
        this.objectMapper = objectMapper;
        this.objectVariableService = objectVariableService;
    }

    @Override
    protected List<ProcessInstanceDto> filterAndMapZeebeRecordsToOptimizeEntities(List<ZeebeVariableRecordDto> zeebeRecords) {
        List<ProcessInstanceDto> optimizeDtos = zeebeRecords.stream().filter(zeebeRecord -> INTENTS_TO_IMPORT.contains(zeebeRecord.getIntent())).collect(Collectors.groupingBy(zeebeRecord -> ((ZeebeVariableDataDto)zeebeRecord.getValue()).getProcessInstanceKey())).values().stream().map(this::createProcessInstanceForData).toList();
        LOG.debug("Processing {} fetched zeebe variable records, of which {} are relevant to Optimize and will be imported.", (Object)zeebeRecords.size(), (Object)optimizeDtos.size());
        return optimizeDtos;
    }

    private ProcessInstanceDto createProcessInstanceForData(List<ZeebeVariableRecordDto> recordsForInstance) {
        ZeebeVariableDataDto firstRecordValue = (ZeebeVariableDataDto)recordsForInstance.get(0).getValue();
        ProcessInstanceDto instanceToAdd = this.createSkeletonProcessInstance(this.getBpmnProcessId(firstRecordValue), firstRecordValue.getProcessInstanceKey(), firstRecordValue.getProcessDefinitionKey(), firstRecordValue.getTenantId());
        return this.updateProcessVariables(instanceToAdd, recordsForInstance);
    }

    private String getBpmnProcessId(ZeebeVariableDataDto zeebeVariableDataDto) {
        return Optional.ofNullable(zeebeVariableDataDto.getBpmnProcessId()).orElseGet(() -> {
            String processDefKey = String.valueOf(zeebeVariableDataDto.getProcessDefinitionKey());
            Optional<ProcessDefinitionOptimizeDto> processDefinition = this.processDefinitionReader.getProcessDefinition(processDefKey);
            return processDefinition.map(DefinitionOptimizeResponseDto::getKey).orElseThrow(() -> new OptimizeRuntimeException("The process definition with id " + processDefKey + " has not yet been imported to Optimize"));
        });
    }

    private ProcessInstanceDto updateProcessVariables(ProcessInstanceDto instanceToAdd, List<ZeebeVariableRecordDto> recordsForInstance) {
        List<ProcessVariableUpdateDto> variables = this.resolveDuplicateUpdates(recordsForInstance).stream().map(this::convertToProcessVariableDto).filter(Optional::isPresent).map(Optional::get).toList();
        List<ProcessVariableDto> processVariablesToImport = this.configurationService.getConfiguredZeebe().isIncludeObjectVariableValue() ? this.objectVariableService.convertToProcessVariableDtos(variables) : this.objectVariableService.convertToProcessVariableDtosSkippingObjectVariables(variables);
        processVariablesToImport.forEach(variable -> instanceToAdd.getVariables().add(this.convertToSimpleProcessVariableDto((ProcessVariableDto)variable)));
        return instanceToAdd;
    }

    private List<ZeebeVariableRecordDto> resolveDuplicateUpdates(List<ZeebeVariableRecordDto> recordsForInstance) {
        return new ArrayList<ZeebeVariableRecordDto>(recordsForInstance.stream().collect(Collectors.toMap(ZeebeRecordDto::getKey, Function.identity(), (oldVar, newVar) -> newVar.getPosition() > oldVar.getPosition() ? newVar : oldVar)).values());
    }

    private SimpleProcessVariableDto convertToSimpleProcessVariableDto(ProcessVariableDto processVariableDto) {
        SimpleProcessVariableDto simpleProcessVariableDto = new SimpleProcessVariableDto();
        simpleProcessVariableDto.setId(String.valueOf(processVariableDto.getId()));
        simpleProcessVariableDto.setName(processVariableDto.getName());
        simpleProcessVariableDto.setType(processVariableDto.getType());
        simpleProcessVariableDto.setValue(processVariableDto.getValue());
        simpleProcessVariableDto.setVersion(processVariableDto.getVersion().longValue());
        return simpleProcessVariableDto;
    }

    private Optional<ProcessVariableUpdateDto> convertToProcessVariableDto(ZeebeVariableRecordDto variableRecordDto) {
        ZeebeVariableDataDto zeebeVariableDataDto = (ZeebeVariableDataDto)variableRecordDto.getValue();
        return this.getVariableTypeFromJsonNode(zeebeVariableDataDto, variableRecordDto.getKey()).map(type -> {
            ProcessVariableUpdateDto processVariableDto = new ProcessVariableUpdateDto();
            processVariableDto.setId(String.valueOf(variableRecordDto.getKey()));
            processVariableDto.setName(zeebeVariableDataDto.getName());
            processVariableDto.setVersion(Long.valueOf(variableRecordDto.getPosition()));
            processVariableDto.setType(type);
            processVariableDto.setValue(zeebeVariableDataDto.getValue());
            processVariableDto.setTenantId(zeebeVariableDataDto.getTenantId());
            if (type.equals("String")) {
                processVariableDto.setValue(this.stripExtraDoubleQuotationsIfExist(zeebeVariableDataDto.getValue()));
            } else if ("Object".equalsIgnoreCase((String)type)) {
                processVariableDto.setValueInfo(OBJECT_VALUE_INFO);
            }
            return processVariableDto;
        });
    }

    private Optional<String> getVariableTypeFromJsonNode(ZeebeVariableDataDto zeebeVariableDataDto, long recordKey) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(zeebeVariableDataDto.getValue());
            JsonNodeType jsonNodeType = jsonNode.getNodeType();
            switch (jsonNodeType) {
                case NUMBER: {
                    return Optional.of("Double");
                }
                case BOOLEAN: {
                    return Optional.of("Boolean");
                }
                case STRING: {
                    return Optional.of("String");
                }
                case OBJECT: 
                case ARRAY: {
                    return Optional.of("Object");
                }
            }
            return Optional.empty();
        }
        catch (JsonProcessingException e) {
            LOG.debug("Could not process json node for variable record with key {}", (Object)recordKey);
            return Optional.empty();
        }
    }

    private String stripExtraDoubleQuotationsIfExist(String variableValue) {
        if (variableValue.charAt(0) == '\"' && variableValue.charAt(variableValue.length() - 1) == '\"') {
            return variableValue.substring(1, variableValue.length() - 1);
        }
        return variableValue;
    }
}

