/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.engine.service.zeebe;

import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.process.FlowNodeInstanceDto;
import io.camunda.optimize.dto.zeebe.process.ZeebeProcessInstanceDataDto;
import io.camunda.optimize.dto.zeebe.process.ZeebeProcessInstanceRecordDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.writer.ProcessInstanceWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeProcessInstanceSubEntityImportService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeebeProcessInstanceImportService
extends ZeebeProcessInstanceSubEntityImportService<ZeebeProcessInstanceRecordDto> {
    public static final Set<ProcessInstanceIntent> INTENTS_TO_IMPORT = Set.of(ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.ELEMENT_TERMINATED, ProcessInstanceIntent.ELEMENT_ACTIVATING);
    private static final Set<BpmnElementType> TYPES_TO_IGNORE = Set.of(BpmnElementType.UNSPECIFIED, BpmnElementType.SEQUENCE_FLOW);
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeProcessInstanceImportService.class);

    public ZeebeProcessInstanceImportService(ConfigurationService configurationService, ProcessInstanceWriter processInstanceWriter, int partitionId, ProcessDefinitionReader processDefinitionReader, DatabaseClient databaseClient) {
        super(configurationService, processInstanceWriter, partitionId, processDefinitionReader, databaseClient, "process-instance");
    }

    @Override
    protected List<ProcessInstanceDto> filterAndMapZeebeRecordsToOptimizeEntities(List<ZeebeProcessInstanceRecordDto> zeebeRecords) {
        ArrayList<ProcessInstanceDto> optimizeDtos = new ArrayList<ProcessInstanceDto>(zeebeRecords.stream().filter(zeebeRecord -> {
            BpmnElementType bpmnElementType = ((ZeebeProcessInstanceDataDto)zeebeRecord.getValue()).getBpmnElementType();
            return bpmnElementType != null && !TYPES_TO_IGNORE.contains(bpmnElementType);
        }).filter(zeebeRecord -> INTENTS_TO_IMPORT.contains(zeebeRecord.getIntent())).collect(Collectors.groupingBy(zeebeRecord -> ((ZeebeProcessInstanceDataDto)zeebeRecord.getValue()).getProcessInstanceKey(), Collectors.mapping(Function.identity(), Collectors.collectingAndThen(Collectors.toList(), this::createProcessInstanceForData)))).values());
        LOG.debug("Processing {} fetched zeebe process instance records, of which {} are relevant to Optimize and will be imported.", (Object)zeebeRecords.size(), (Object)optimizeDtos.size());
        return optimizeDtos;
    }

    private ProcessInstanceDto createProcessInstanceForData(List<ZeebeProcessInstanceRecordDto> recordsForInstance) {
        ZeebeProcessInstanceRecordDto firstRecord = recordsForInstance.get(0);
        ZeebeProcessInstanceDataDto firstRecordValue = (ZeebeProcessInstanceDataDto)firstRecord.getValue();
        ProcessInstanceDto instanceToAdd = this.createSkeletonProcessInstance(firstRecordValue.getBpmnProcessId(), firstRecordValue.getProcessInstanceKey(), firstRecordValue.getProcessDefinitionKey(), firstRecordValue.getTenantId());
        instanceToAdd.setProcessDefinitionVersion(String.valueOf(firstRecordValue.getVersion()));
        instanceToAdd.setIncidents(Collections.emptyList());
        instanceToAdd.setVariables(Collections.emptyList());
        this.updateProcessStateAndDateProperties(instanceToAdd, recordsForInstance);
        this.updateFlowNodeEventsForProcess(instanceToAdd, recordsForInstance);
        return instanceToAdd;
    }

    private void updateProcessStateAndDateProperties(ProcessInstanceDto instanceToAdd, List<ZeebeProcessInstanceRecordDto> recordsForInstance) {
        recordsForInstance.stream().filter(zeebeRecord -> BpmnElementType.PROCESS.equals((Object)((ZeebeProcessInstanceDataDto)zeebeRecord.getValue()).getBpmnElementType())).forEach(processInstance -> {
            switch ((ProcessInstanceIntent)processInstance.getIntent()) {
                case ELEMENT_COMPLETED: {
                    this.updateStateIfValidTransition(instanceToAdd, "COMPLETED");
                    instanceToAdd.setEndDate(processInstance.getDateForTimestamp());
                    break;
                }
                case ELEMENT_TERMINATED: {
                    this.updateStateIfValidTransition(instanceToAdd, "EXTERNALLY_TERMINATED");
                    instanceToAdd.setEndDate(processInstance.getDateForTimestamp());
                    break;
                }
                case ELEMENT_ACTIVATING: {
                    this.updateStateIfValidTransition(instanceToAdd, "ACTIVE");
                    instanceToAdd.setStartDate(processInstance.getDateForTimestamp());
                    break;
                }
                default: {
                    throw new OptimizeRuntimeException("Unsupported intent: " + String.valueOf(processInstance.getIntent()));
                }
            }
            this.updateDurationIfCompleted(instanceToAdd);
        });
    }

    private void updateFlowNodeEventsForProcess(ProcessInstanceDto instanceToAdd, List<ZeebeProcessInstanceRecordDto> recordsForInstance) {
        HashMap flowNodeInstancesByRecordKey = new HashMap();
        recordsForInstance.stream().filter(zeebeRecord -> ((ZeebeProcessInstanceDataDto)zeebeRecord.getValue()).getBpmnElementType().getElementTypeName().isPresent()).filter(zeebeRecord -> !BpmnElementType.PROCESS.equals((Object)((ZeebeProcessInstanceDataDto)zeebeRecord.getValue()).getBpmnElementType())).forEach(zeebeFlowNodeInstanceRecord -> {
            long recordKey = zeebeFlowNodeInstanceRecord.getKey();
            FlowNodeInstanceDto flowNodeForKey = flowNodeInstancesByRecordKey.getOrDefault(recordKey, this.createSkeletonFlowNodeInstance((ZeebeProcessInstanceRecordDto)zeebeFlowNodeInstanceRecord));
            ProcessInstanceIntent instanceIntent = (ProcessInstanceIntent)zeebeFlowNodeInstanceRecord.getIntent();
            if (instanceIntent == ProcessInstanceIntent.ELEMENT_COMPLETED) {
                flowNodeForKey.setEndDate(zeebeFlowNodeInstanceRecord.getDateForTimestamp());
            } else if (instanceIntent == ProcessInstanceIntent.ELEMENT_TERMINATED) {
                flowNodeForKey.setCanceled(Boolean.valueOf(true));
                flowNodeForKey.setEndDate(zeebeFlowNodeInstanceRecord.getDateForTimestamp());
            } else if (instanceIntent == ProcessInstanceIntent.ELEMENT_ACTIVATING) {
                flowNodeForKey.setStartDate(zeebeFlowNodeInstanceRecord.getDateForTimestamp());
            }
            this.updateDurationIfCompleted(flowNodeForKey);
            flowNodeInstancesByRecordKey.put(recordKey, flowNodeForKey);
        });
        instanceToAdd.setFlowNodeInstances(new ArrayList(flowNodeInstancesByRecordKey.values()));
    }

    private FlowNodeInstanceDto createSkeletonFlowNodeInstance(ZeebeProcessInstanceRecordDto zeebeProcessInstanceRecordDto) {
        ZeebeProcessInstanceDataDto zeebeInstanceRecord = (ZeebeProcessInstanceDataDto)zeebeProcessInstanceRecordDto.getValue();
        FlowNodeInstanceDto flowNodeInstanceDto = new FlowNodeInstanceDto(String.valueOf(zeebeInstanceRecord.getBpmnProcessId()), String.valueOf(zeebeInstanceRecord.getVersion()), zeebeInstanceRecord.getTenantId(), String.valueOf(zeebeInstanceRecord.getProcessInstanceKey()), zeebeInstanceRecord.getElementId(), (String)zeebeInstanceRecord.getBpmnElementType().getElementTypeName().orElseThrow(() -> new OptimizeRuntimeException("Cannot create flow node instances for records without element types")), String.valueOf(zeebeProcessInstanceRecordDto.getKey()));
        flowNodeInstanceDto.setCanceled(Boolean.valueOf(false));
        return flowNodeInstanceDto;
    }

    private void updateStateIfValidTransition(ProcessInstanceDto instance, String targetState) {
        if (instance.getState() == null || instance.getState().equals("ACTIVE")) {
            instance.setState(targetState);
        }
    }

    private void updateDurationIfCompleted(ProcessInstanceDto instanceToAdd) {
        if (instanceToAdd.getStartDate() != null && instanceToAdd.getEndDate() != null) {
            instanceToAdd.setDuration(Long.valueOf(instanceToAdd.getStartDate().until(instanceToAdd.getEndDate(), ChronoUnit.MILLIS)));
        }
    }

    private void updateDurationIfCompleted(FlowNodeInstanceDto flowNodeToAdd) {
        if (flowNodeToAdd.getStartDate() != null && flowNodeToAdd.getEndDate() != null) {
            flowNodeToAdd.setTotalDurationInMs(Long.valueOf(flowNodeToAdd.getStartDate().until(flowNodeToAdd.getEndDate(), ChronoUnit.MILLIS)));
        }
    }
}

