/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.engine.service.zeebe;

import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.persistence.incident.IncidentDto;
import io.camunda.optimize.dto.optimize.persistence.incident.IncidentStatus;
import io.camunda.optimize.dto.optimize.persistence.incident.IncidentType;
import io.camunda.optimize.dto.zeebe.incident.ZeebeIncidentDataDto;
import io.camunda.optimize.dto.zeebe.incident.ZeebeIncidentRecordDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.writer.ProcessInstanceWriter;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeProcessInstanceSubEntityImportService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeebeIncidentImportService
extends ZeebeProcessInstanceSubEntityImportService<ZeebeIncidentRecordDto> {
    private static final Set<IncidentIntent> INTENTS_TO_IMPORT = Set.of(IncidentIntent.CREATED, IncidentIntent.RESOLVED);
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeIncidentImportService.class);

    public ZeebeIncidentImportService(ConfigurationService configurationService, ProcessInstanceWriter processInstanceWriter, int partitionId, ProcessDefinitionReader processDefinitionReader, DatabaseClient databaseClient) {
        super(configurationService, processInstanceWriter, partitionId, processDefinitionReader, databaseClient, "incident");
    }

    @Override
    protected List<ProcessInstanceDto> filterAndMapZeebeRecordsToOptimizeEntities(List<ZeebeIncidentRecordDto> zeebeRecords) {
        List<ProcessInstanceDto> optimizeDtos = zeebeRecords.stream().filter(zeebeRecord -> INTENTS_TO_IMPORT.contains(zeebeRecord.getIntent())).collect(Collectors.groupingBy(zeebeRecord -> ((ZeebeIncidentDataDto)zeebeRecord.getValue()).getProcessInstanceKey())).values().stream().map(this::createProcessInstanceForData).collect(Collectors.toList());
        LOG.debug("Processing {} fetched zeebe incident records, of which {} are relevant to Optimize and will be imported.", (Object)zeebeRecords.size(), (Object)optimizeDtos.size());
        return optimizeDtos;
    }

    private ProcessInstanceDto createProcessInstanceForData(List<ZeebeIncidentRecordDto> recordsForInstance) {
        ZeebeIncidentDataDto firstRecordValue = (ZeebeIncidentDataDto)recordsForInstance.get(0).getValue();
        ProcessInstanceDto instanceToAdd = this.createSkeletonProcessInstance(firstRecordValue.getBpmnProcessId(), firstRecordValue.getProcessInstanceKey(), firstRecordValue.getProcessDefinitionKey(), firstRecordValue.getTenantId());
        return this.updateIncidents(instanceToAdd, recordsForInstance);
    }

    private ProcessInstanceDto updateIncidents(ProcessInstanceDto instanceToAdd, List<ZeebeIncidentRecordDto> recordsForInstance) {
        HashMap incidentsByRecordKey = new HashMap();
        recordsForInstance.forEach(incident -> {
            long recordKey = incident.getKey();
            IncidentDto incidentForKey = incidentsByRecordKey.getOrDefault(recordKey, this.createSkeletonIncident((ZeebeIncidentRecordDto)incident));
            if (incident.getIntent() == IncidentIntent.CREATED && incidentForKey.getIncidentStatus() != IncidentStatus.RESOLVED) {
                incidentForKey.setIncidentStatus(IncidentStatus.OPEN);
                incidentForKey.setCreateTime(this.dateForTimestamp((ZeebeIncidentRecordDto)incident));
            } else if (incident.getIntent() == IncidentIntent.RESOLVED) {
                incidentForKey.setIncidentStatus(IncidentStatus.RESOLVED);
                incidentForKey.setEndTime(this.dateForTimestamp((ZeebeIncidentRecordDto)incident));
            }
            this.updateDurationIfMissing(incidentForKey);
            incidentsByRecordKey.put(recordKey, incidentForKey);
        });
        instanceToAdd.setIncidents(new ArrayList(incidentsByRecordKey.values()));
        return instanceToAdd;
    }

    private void updateDurationIfMissing(IncidentDto incidentDto) {
        if (incidentDto.getDurationInMs() == null && incidentDto.getCreateTime() != null && incidentDto.getEndTime() != null) {
            incidentDto.setDurationInMs(Long.valueOf(incidentDto.getCreateTime().until(incidentDto.getEndTime(), ChronoUnit.MILLIS)));
        }
    }

    private IncidentDto createSkeletonIncident(ZeebeIncidentRecordDto zeebeIncidentRecordDto) {
        ZeebeIncidentDataDto incidentDataDto = (ZeebeIncidentDataDto)zeebeIncidentRecordDto.getValue();
        IncidentDto incidentDto = new IncidentDto();
        incidentDto.setId(String.valueOf(zeebeIncidentRecordDto.getKey()));
        incidentDto.setDefinitionKey(((ZeebeIncidentDataDto)zeebeIncidentRecordDto.getValue()).getBpmnProcessId());
        incidentDto.setIncidentType(IncidentType.valueOfId((String)incidentDataDto.getErrorType().toString()));
        incidentDto.setActivityId(String.valueOf(incidentDataDto.getElementInstanceKey()));
        incidentDto.setIncidentMessage(incidentDataDto.getErrorMessage());
        incidentDto.setTenantId(incidentDataDto.getTenantId());
        return incidentDto;
    }

    private OffsetDateTime dateForTimestamp(ZeebeIncidentRecordDto zeebeRecord) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(zeebeRecord.getTimestamp()), ZoneId.systemDefault());
    }
}

