/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.engine.service;

import io.camunda.optimize.dto.optimize.index.TimestampBasedImportIndexDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.writer.ImportIndexWriter;
import io.camunda.optimize.service.importing.DatabaseImportJobExecutor;
import io.camunda.optimize.service.importing.engine.service.ImportService;
import io.camunda.optimize.service.importing.job.StoreTimestampBasedImportIndexDatabaseImportJob;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreTimestampBasedImportIndexImportService
implements ImportService<TimestampBasedImportIndexDto> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreTimestampBasedImportIndexImportService.class);
    private final ImportIndexWriter importIndexWriter;
    private final DatabaseImportJobExecutor databaseImportJobExecutor;
    private final DatabaseClient databaseClient;

    public StoreTimestampBasedImportIndexImportService(ConfigurationService configurationService, ImportIndexWriter importIndexWriter, DatabaseClient databaseClient) {
        this.databaseImportJobExecutor = new DatabaseImportJobExecutor(this.getClass().getSimpleName(), configurationService);
        this.importIndexWriter = importIndexWriter;
        this.databaseClient = databaseClient;
    }

    @Override
    public void executeImport(List<TimestampBasedImportIndexDto> importIndexesToStore, Runnable importCompleteCallback) {
        StoreTimestampBasedImportIndexDatabaseImportJob storeIndexesImportJob = new StoreTimestampBasedImportIndexDatabaseImportJob(this.importIndexWriter, importCompleteCallback, this.databaseClient);
        storeIndexesImportJob.setEntitiesToImport(importIndexesToStore);
        this.databaseImportJobExecutor.executeImportJob(storeIndexesImportJob);
    }

    @Override
    public DatabaseImportJobExecutor getDatabaseImportJobExecutor() {
        return this.databaseImportJobExecutor;
    }
}

