/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseImportJobExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseImportJobExecutor.class);
    private final ConfigurationService configurationService;
    private final String name;
    private ThreadPoolExecutor importExecutor;

    public DatabaseImportJobExecutor(String name, ConfigurationService configurationService) {
        this.name = name;
        this.configurationService = configurationService;
        this.startExecutingImportJobs();
    }

    public void shutdown() {
        this.stopExecutingImportJobs();
    }

    public boolean isActive() {
        return this.importExecutor.getActiveCount() > 0 || !this.importExecutor.getQueue().isEmpty();
    }

    public void stopExecutingImportJobs() {
        this.importExecutor.shutdownNow();
        try {
            boolean timeElapsedBeforeTermination;
            boolean bl = timeElapsedBeforeTermination = !this.importExecutor.awaitTermination(60L, TimeUnit.SECONDS);
            if (timeElapsedBeforeTermination) {
                LOG.warn("{}: Timeout during shutdown of import job executor! The current running jobs could not end within 60 seconds after shutdown operation.", (Object)this.getClass().getSimpleName());
            }
        }
        catch (InterruptedException e) {
            LOG.error("{}: Interrupted while shutting down the import job executor!", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public void executeImportJob(Runnable dbImportJob) {
        LOG.debug("{}: Currently active [{}] jobs and [{}] in queue of job type [{}]", new Object[]{this.getClass().getSimpleName(), this.importExecutor.getActiveCount(), this.importExecutor.getQueue().size(), dbImportJob.getClass().getSimpleName()});
        this.importExecutor.execute(dbImportJob);
    }

    public void startExecutingImportJobs() {
        if (this.importExecutor == null || this.importExecutor.isShutdown()) {
            ArrayBlockingQueue<Runnable> importJobsQueue = new ArrayBlockingQueue<Runnable>(this.getMaxQueueSize());
            this.importExecutor = new ThreadPoolExecutor(this.getExecutorThreadCount(), this.getExecutorThreadCount(), Long.MAX_VALUE, TimeUnit.DAYS, importJobsQueue, new ThreadFactoryBuilder().setNameFormat("ImportJobExecutor-pool-" + this.name + "-%d").build(), new BlockCallerUntilExecutorHasCapacity());
        }
    }

    protected int getExecutorThreadCount() {
        return this.configurationService.getJobExecutorThreadCount();
    }

    protected int getMaxQueueSize() {
        return this.configurationService.getJobExecutorQueueSize();
    }

    private static final class BlockCallerUntilExecutorHasCapacity
    implements RejectedExecutionHandler {
        private BlockCallerUntilExecutorHasCapacity() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                try {
                    LOG.debug("{}: Max queue capacity is reached and, thus, can't schedule any new jobs. Caller needs to wait until there is new free spot. Job class [{}].", (Object)super.getClass().getSimpleName(), (Object)runnable.getClass().getSimpleName());
                    executor.getQueue().put(runnable);
                    LOG.debug("{}: Added job to queue. Caller can continue working on his tasks.", (Object)super.getClass().getSimpleName());
                }
                catch (InterruptedException e) {
                    LOG.error("{}: Interrupted while waiting to submit a new job to the job executor!", (Object)this.getClass().getSimpleName(), (Object)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

