/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.identity;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.camunda.optimize.dto.optimize.GroupDto;
import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.IdentitySearchResultResponseDto;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.util.configuration.CacheConfiguration;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserTaskIdentityService {
    private static final Logger LOG = LoggerFactory.getLogger(UserTaskIdentityService.class);
    private final AbstractIdentityService identityService;
    private final Cache<String, UserDto> externalUserTaskAssignees;
    private final Cache<String, GroupDto> externalUserTaskCandidateGroups;

    public UserTaskIdentityService(AbstractIdentityService identityService, ConfigurationService configurationService) {
        this.identityService = identityService;
        CacheConfiguration usersCacheConfig = configurationService.getCaches().getUsers();
        this.externalUserTaskAssignees = Caffeine.newBuilder().maximumSize((long)usersCacheConfig.getMaxSize()).expireAfterWrite(Duration.ofMillis(usersCacheConfig.getDefaultTtlMillis())).build();
        this.externalUserTaskCandidateGroups = Caffeine.newBuilder().maximumSize((long)usersCacheConfig.getMaxSize()).expireAfterWrite(Duration.ofMillis(usersCacheConfig.getDefaultTtlMillis())).build();
    }

    public List<GroupDto> getCandidateGroupIdentitiesById(Collection<String> ids) {
        return this.getIdentities(ids.stream().map(id -> new IdentityDto(id, IdentityType.GROUP)).collect(Collectors.toSet())).stream().filter(GroupDto.class::isInstance).map(GroupDto.class::cast).toList();
    }

    public List<UserDto> getAssigneesByIds(Collection<String> assigneeIds) {
        return this.getIdentities(assigneeIds.stream().map(id -> new IdentityDto(id, IdentityType.USER)).collect(Collectors.toSet())).stream().filter(UserDto.class::isInstance).map(UserDto.class::cast).toList();
    }

    public IdentitySearchResultResponseDto searchAmongIdentitiesWithIds(String terms, Collection<String> identityIds, IdentityType identityType, int resultLimit) {
        if (StringUtils.isEmpty((CharSequence)terms)) {
            LOG.debug("Searching with empty search term. Retrieving all identities for given IDs.");
            return new IdentitySearchResultResponseDto(this.getIdentitiesByIdOrReturnDefaultDto(new HashSet<String>(identityIds), identityType, resultLimit));
        }
        return this.searchAmongIdentitiesWithIdsOrReturnDefaultDto(terms, identityIds, identityType, resultLimit);
    }

    public List<IdentityWithMetadataResponseDto> getIdentities(Collection<IdentityDto> identities) {
        return identities.stream().collect(Collectors.groupingBy(IdentityDto::getType, Collectors.mapping(IdentityDto::getId, Collectors.toSet()))).entrySet().stream().flatMap(entry -> this.getIdentitiesByIdOrReturnDefaultDto((Set)entry.getValue(), (IdentityType)entry.getKey()).stream()).toList();
    }

    public Optional<IdentityWithMetadataResponseDto> getIdentityByIdAndType(String id, IdentityType type) {
        return IdentityType.USER == type ? Optional.of(this.getUserByIdAndAddToCacheIfNotFound(id)) : Optional.of(this.getGroupByIdAndAddToCacheIfNotFound(id));
    }

    private List<IdentityWithMetadataResponseDto> getIdentitiesByIdOrReturnDefaultDto(Set<String> ids, IdentityType type) {
        return this.getIdentitiesByIdOrReturnDefaultDto(ids, type, ids.size());
    }

    private List<IdentityWithMetadataResponseDto> getIdentitiesByIdOrReturnDefaultDto(Set<String> ids, IdentityType type, int resultLimit) {
        return IdentityType.USER == type ? this.getUsersByIdAndAddToCacheIfNotFound(ids, resultLimit).stream().map(IdentityWithMetadataResponseDto.class::cast).collect(Collectors.toList()) : this.getGroupsByIdAndAddToCacheIfNotFound(ids, resultLimit).stream().map(IdentityWithMetadataResponseDto.class::cast).collect(Collectors.toList());
    }

    private IdentityWithMetadataResponseDto getUserByIdAndAddToCacheIfNotFound(String id) {
        return (IdentityWithMetadataResponseDto)Optional.ofNullable((UserDto)this.externalUserTaskAssignees.getIfPresent((Object)id)).orElseGet(() -> {
            LOG.debug("No user found in external user cache for ID [{}]. Looking up in identityService instead.", (Object)id);
            return this.identityService.getUserById(id).orElseGet(() -> {
                LOG.debug("No user found in identityService for ID [{}]. Adding to external user cache.", (Object)id);
                this.externalUserTaskAssignees.put((Object)id, (Object)new UserDto(id));
                return new UserDto(id);
            });
        });
    }

    private List<IdentityWithMetadataResponseDto> getUsersByIdAndAddToCacheIfNotFound(Set<String> ids, int resultLimit) {
        ids = ids.stream().sorted().limit(resultLimit).collect(Collectors.toSet());
        LOG.debug("Attempting to retrieve users from external user cache for IDs [{}].", ids);
        Map externalUsers = this.externalUserTaskAssignees.getAllPresent(ids);
        ArrayList result = new ArrayList(externalUsers.values());
        ids.removeAll(externalUsers.keySet());
        if (!ids.isEmpty() && externalUsers.size() < resultLimit) {
            LOG.debug("No users found in external user cache for IDs [{}]. Attempting to retrieve from identityService instead.", ids);
            List<IdentityWithMetadataResponseDto> existingUsers = this.identityService.getUsersById(ids);
            result.addAll(existingUsers);
            ids.removeAll(existingUsers.stream().map(IdentityDto::getId).collect(Collectors.toSet()));
            ids.forEach(id -> result.add((IdentityWithMetadataResponseDto)this.externalUserTaskAssignees.get(id, UserDto::new)));
        }
        return result.stream().limit(resultLimit).toList();
    }

    private IdentityWithMetadataResponseDto getGroupByIdAndAddToCacheIfNotFound(String id) {
        return (IdentityWithMetadataResponseDto)Optional.ofNullable((GroupDto)this.externalUserTaskCandidateGroups.getIfPresent((Object)id)).orElseGet(() -> {
            LOG.debug("No group found in external group cache for ID [{}]. Looking up in identityService instead.", (Object)id);
            return this.identityService.getGroupById(id).orElseGet(() -> {
                LOG.debug("No group found in identityService for ID [{}]. Adding to external group cache.", (Object)id);
                this.externalUserTaskCandidateGroups.put((Object)id, (Object)new GroupDto(id));
                return new GroupDto(id);
            });
        });
    }

    private List<IdentityWithMetadataResponseDto> getGroupsByIdAndAddToCacheIfNotFound(Set<String> ids, int resultLimit) {
        ids = ids.stream().sorted().limit(resultLimit).collect(Collectors.toSet());
        LOG.debug("Attempting to retrieve groups from external group cache for IDs [{}].", ids);
        Map externalGroups = this.externalUserTaskCandidateGroups.getAllPresent(ids);
        ArrayList result = new ArrayList(externalGroups.values());
        ids.removeAll(externalGroups.keySet());
        if (!ids.isEmpty() && result.size() < resultLimit) {
            LOG.debug("No groups found in external group cache for IDs [{}]. Attempting to retrieve from identityService instead.", ids);
            List<IdentityWithMetadataResponseDto> existingGroups = this.identityService.getGroupsById(ids);
            result.addAll(existingGroups);
            ids.removeAll(existingGroups.stream().map(IdentityDto::getId).collect(Collectors.toSet()));
            ids.forEach(id -> result.add((IdentityWithMetadataResponseDto)this.externalUserTaskCandidateGroups.get(id, GroupDto::new)));
        }
        return result.stream().limit(resultLimit).toList();
    }

    private IdentitySearchResultResponseDto searchAmongIdentitiesWithIdsOrReturnDefaultDto(String terms, Collection<String> identityIds, IdentityType identityType, int resultLimit) {
        if (IdentityType.GROUP == identityType) {
            LOG.debug("Searching for groups in external group cache for IDs [{}] and searchterm [{}].", identityIds, (Object)terms);
            return new IdentitySearchResultResponseDto(this.externalUserTaskCandidateGroups.getAll(identityIds, ids -> ids.stream().map(GroupDto::new).collect(Collectors.toMap(IdentityDto::getId, Function.identity()))).values().stream().filter(group -> group.isIdentityContainsSearchTerm(terms)).map(IdentityWithMetadataResponseDto.class::cast).limit(resultLimit).toList());
        }
        LOG.debug("Searching for users in external user cache for IDs [{}] and searchterm [{}].", identityIds, (Object)terms);
        Map externalUsers = this.externalUserTaskAssignees.getAllPresent(identityIds);
        identityIds.removeAll(externalUsers.keySet());
        List result = externalUsers.values().stream().filter(user -> user.isIdentityContainsSearchTerm(terms)).map(IdentityWithMetadataResponseDto.class::cast).limit(resultLimit).collect(Collectors.toList());
        if (!identityIds.isEmpty() && result.size() < resultLimit) {
            LOG.debug("Searching for users in identityService for IDs [{}] and searchterm [{}].", identityIds, (Object)terms);
            result.addAll(this.identityService.searchForIdentitiesAsUser(null, terms, resultLimit, true).getResult().stream().filter(user -> identityIds.contains(user.toIdentityDto().getId())).toList());
        }
        return new IdentitySearchResultResponseDto(result.stream().limit(resultLimit).toList());
    }
}

