/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.identity;

import com.google.common.collect.ImmutableList;
import io.camunda.optimize.dto.optimize.GroupDto;
import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.IdentitySearchResultResponseDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizationType;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.users.AuthorizedUserType;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractIdentityService
implements ConfigurationReloadable {
    private static List<AuthorizationType> defaultUserAuthorizations;
    private static final Logger LOG;
    protected final ConfigurationService configurationService;

    protected AbstractIdentityService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        AbstractIdentityService.initializeAuthorizations(configurationService);
    }

    private static void initializeAuthorizations(ConfigurationService configurationService) {
        ArrayList<AuthorizationType> initializedDefaultUserAuthorizations = new ArrayList<AuthorizationType>();
        AbstractIdentityService.initializeUserAuthorizationsForAuthorizationType(AuthorizationType.CSV_EXPORT, configurationService.getCsvConfiguration().getAuthorizedUserType(), initializedDefaultUserAuthorizations);
        AbstractIdentityService.initializeUserAuthorizationsForAuthorizationType(AuthorizationType.ENTITY_EDITOR, configurationService.getEntityConfiguration().getAuthorizedUserType(), initializedDefaultUserAuthorizations);
        defaultUserAuthorizations = ImmutableList.copyOf(initializedDefaultUserAuthorizations);
    }

    private static void initializeUserAuthorizationsForAuthorizationType(AuthorizationType authorizationType, AuthorizedUserType authorizedUserType, List<AuthorizationType> initializedDefaultUserAuthorizations) {
        if (authorizedUserType == AuthorizedUserType.ALL) {
            initializedDefaultUserAuthorizations.add(authorizationType);
        }
    }

    public void reloadConfiguration(ApplicationContext context) {
        AbstractIdentityService.initializeAuthorizations(this.configurationService);
    }

    public abstract Optional<UserDto> getUserById(String var1);

    public abstract Optional<UserDto> getCurrentUserById(String var1, HttpServletRequest var2);

    public abstract Optional<GroupDto> getGroupById(String var1);

    public abstract List<GroupDto> getAllGroupsOfUser(String var1);

    public abstract boolean isUserAuthorizedToAccessIdentity(String var1, IdentityDto var2);

    public abstract IdentitySearchResultResponseDto searchForIdentitiesAsUser(String var1, String var2, int var3, boolean var4);

    public List<IdentityWithMetadataResponseDto> getUsersById(Set<String> userIds) {
        return userIds.stream().map(this::getUserById).filter(Optional::isPresent).map(Optional::get).map(IdentityWithMetadataResponseDto.class::cast).toList();
    }

    public List<IdentityWithMetadataResponseDto> getGroupsById(Set<String> groupIds) {
        return groupIds.stream().map(this::getGroupById).filter(Optional::isPresent).map(Optional::get).map(IdentityWithMetadataResponseDto.class::cast).toList();
    }

    public List<AuthorizationType> getEnabledAuthorizations() {
        return ImmutableList.copyOf(defaultUserAuthorizations);
    }

    public Optional<IdentityWithMetadataResponseDto> getIdentityWithMetadataForId(String userOrGroupId) {
        return this.getUserById(userOrGroupId).map(IdentityWithMetadataResponseDto.class::cast).or(() -> this.getGroupById(userOrGroupId));
    }

    public Optional<IdentityWithMetadataResponseDto> getIdentityWithMetadataForIdAsUser(String userId, String userOrGroupId) {
        return this.getUserById(userOrGroupId).map(IdentityWithMetadataResponseDto.class::cast).or(() -> this.getGroupById(userOrGroupId)).map(identityDto -> this.isUserAuthorizedToAccessIdentity(userId, (IdentityDto)identityDto) ? identityDto : null);
    }

    public void validateUserAuthorizedToAccessRoleOrFail(String userId, IdentityDto identityDto) {
        if (!this.isUserAuthorizedToAccessIdentity(userId, identityDto)) {
            throw new ForbiddenException(String.format("User with ID %s is not authorized to access identity with ID %s", userId, identityDto.getId()));
        }
    }

    public boolean doesIdentityExist(IdentityDto identity) {
        return this.getIdentityWithMetadataForId(identity.getId()).isPresent();
    }

    public Optional<String> getIdentityNameById(String identityId) {
        if ("System User".equals(identityId)) {
            return Optional.empty();
        }
        Optional<IdentityWithMetadataResponseDto> identityDto = this.getIdentityWithMetadataForId(identityId);
        return identityDto.map(IdentityWithMetadataResponseDto::getName);
    }

    protected List<IdentityWithMetadataResponseDto> filterIdentitySearchResultByUserAuthorizations(String userId, IdentitySearchResultResponseDto result) {
        return result.getResult().stream().filter(identity -> this.isUserAuthorizedToAccessIdentity(userId, (IdentityDto)identity)).toList();
    }

    static {
        LOG = LoggerFactory.getLogger(AbstractIdentityService.class);
    }
}

