/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.entities.report;

import io.camunda.optimize.dto.optimize.DecisionDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.query.EntityIdResponseDto;
import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityType;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportItemDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.dto.optimize.rest.DefinitionExceptionItemDto;
import io.camunda.optimize.dto.optimize.rest.DefinitionVersionResponseDto;
import io.camunda.optimize.dto.optimize.rest.ImportIndexMismatchDto;
import io.camunda.optimize.dto.optimize.rest.export.ExportEntityType;
import io.camunda.optimize.dto.optimize.rest.export.report.CombinedProcessReportDefinitionExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.ReportDefinitionExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.SingleDecisionReportDefinitionExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.SingleProcessReportDefinitionExportDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.db.writer.ReportWriter;
import io.camunda.optimize.service.exceptions.OptimizeImportDefinitionDoesNotExistException;
import io.camunda.optimize.service.exceptions.OptimizeImportDescriptionNotValidException;
import io.camunda.optimize.service.exceptions.OptimizeImportForbiddenException;
import io.camunda.optimize.service.exceptions.OptimizeImportIncorrectIndexVersionException;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeNonDefinitionScopeCompliantException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeNonTenantScopeCompliantException;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import io.camunda.optimize.service.util.DataUtil;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportImportService {
    private static final Logger LOG = LoggerFactory.getLogger(ReportImportService.class);
    private final ReportService reportService;
    private final ReportWriter reportWriter;
    private final DefinitionService definitionService;
    private final DataSourceDefinitionAuthorizationService definitionAuthorizationService;
    private final OptimizeIndexNameService optimizeIndexNameService;

    public ReportImportService(ReportService reportService, ReportWriter reportWriter, DefinitionService definitionService, DataSourceDefinitionAuthorizationService definitionAuthorizationService, OptimizeIndexNameService optimizeIndexNameService) {
        this.reportService = reportService;
        this.reportWriter = reportWriter;
        this.definitionService = definitionService;
        this.definitionAuthorizationService = definitionAuthorizationService;
        this.optimizeIndexNameService = optimizeIndexNameService;
    }

    public void importReportsIntoCollection(String collectionId, List<ReportDefinitionExportDto> reportsToImport, Map<String, EntityIdResponseDto> originalIdToNewIdMap) {
        this.importReportsIntoCollection(null, collectionId, reportsToImport, originalIdToNewIdMap);
    }

    public void importReportsIntoCollection(String userId, String collectionId, List<ReportDefinitionExportDto> reportsToImport, Map<String, EntityIdResponseDto> originalIdToNewIdMap) {
        List<ReportDefinitionExportDto> singleReportsToImport = reportsToImport.stream().filter(entity -> ExportEntityType.SINGLE_PROCESS_REPORT.equals((Object)entity.getExportEntityType()) || ExportEntityType.SINGLE_DECISION_REPORT.equals((Object)entity.getExportEntityType())).toList();
        List<ReportDefinitionExportDto> combinedReportsToImport = reportsToImport.stream().filter(entity -> ExportEntityType.COMBINED_REPORT.equals((Object)entity.getExportEntityType())).toList();
        singleReportsToImport.forEach(reportToImport -> this.importReportIntoCollection(userId, collectionId, (ReportDefinitionExportDto)reportToImport, originalIdToNewIdMap));
        combinedReportsToImport.forEach(reportToImport -> this.importReportIntoCollection(userId, collectionId, (ReportDefinitionExportDto)reportToImport, originalIdToNewIdMap));
    }

    public void validateAllReportsOrFail(CollectionDefinitionDto collection, List<ReportDefinitionExportDto> reportsToImport) {
        this.validateAllReportsOrFail(null, collection, reportsToImport);
    }

    public void validateAllReportsOrFail(String userId, CollectionDefinitionDto collection, List<ReportDefinitionExportDto> reportsToImport) {
        HashSet<ImportIndexMismatchDto> indexMismatches = new HashSet<ImportIndexMismatchDto>();
        HashSet<DefinitionExceptionItemDto> missingDefinitions = new HashSet<DefinitionExceptionItemDto>();
        HashSet<DefinitionExceptionItemDto> forbiddenDefinitions = new HashSet<DefinitionExceptionItemDto>();
        HashSet<ConflictedItemDto> definitionsNotInScope = new HashSet<ConflictedItemDto>();
        HashSet<ConflictedItemDto> tenantsNotInScope = new HashSet<ConflictedItemDto>();
        HashSet<String> invalidReportIds = new HashSet<String>();
        reportsToImport.forEach(reportExportDto -> {
            try {
                this.validateReportOrFail(userId, collection, (ReportDefinitionExportDto)reportExportDto);
            }
            catch (OptimizeImportIncorrectIndexVersionException e) {
                indexMismatches.addAll(e.getMismatchingIndices());
            }
            catch (OptimizeImportDefinitionDoesNotExistException e) {
                missingDefinitions.addAll(e.getMissingDefinitions());
            }
            catch (OptimizeImportForbiddenException e) {
                forbiddenDefinitions.addAll(e.getForbiddenDefinitions());
            }
            catch (OptimizeNonDefinitionScopeCompliantException e) {
                definitionsNotInScope.addAll(e.getConflictedItems());
            }
            catch (OptimizeNonTenantScopeCompliantException e) {
                tenantsNotInScope.addAll(e.getConflictedItems());
            }
            catch (OptimizeImportDescriptionNotValidException e) {
                invalidReportIds.addAll(e.getInvalidEntityIds());
            }
        });
        if (!indexMismatches.isEmpty()) {
            throw new OptimizeImportIncorrectIndexVersionException("Could not import because source and target index versions do not match for at least one report.", indexMismatches);
        }
        if (!missingDefinitions.isEmpty()) {
            throw new OptimizeImportDefinitionDoesNotExistException("Could not import because at least one required definition does not exist.", missingDefinitions);
        }
        if (!forbiddenDefinitions.isEmpty()) {
            throw new OptimizeImportForbiddenException(String.format("Could not import because user with ID [%s] is not authorized to access at least one of the required definitions.", userId), forbiddenDefinitions);
        }
        if (!definitionsNotInScope.isEmpty()) {
            throw new OptimizeNonDefinitionScopeCompliantException(definitionsNotInScope);
        }
        if (!tenantsNotInScope.isEmpty()) {
            throw new OptimizeNonTenantScopeCompliantException(tenantsNotInScope);
        }
        if (!invalidReportIds.isEmpty()) {
            throw new OptimizeImportDescriptionNotValidException(invalidReportIds);
        }
    }

    private void importReportIntoCollection(String userId, String collectionId, ReportDefinitionExportDto reportToImport, Map<String, EntityIdResponseDto> originalIdToNewIdMap) {
        switch (reportToImport.getExportEntityType()) {
            case SINGLE_PROCESS_REPORT: {
                this.importProcessReportIntoCollection(Optional.ofNullable(userId).orElse("System User"), collectionId, (SingleProcessReportDefinitionExportDto)reportToImport, originalIdToNewIdMap);
                break;
            }
            case SINGLE_DECISION_REPORT: {
                this.importDecisionReportIntoCollection(Optional.ofNullable(userId).orElse("System User"), collectionId, (SingleDecisionReportDefinitionExportDto)reportToImport, originalIdToNewIdMap);
                break;
            }
            case COMBINED_REPORT: {
                this.importCombinedProcessReportIntoCollection(Optional.ofNullable(userId).orElse("System User"), collectionId, (CombinedProcessReportDefinitionExportDto)reportToImport, originalIdToNewIdMap);
                break;
            }
            default: {
                throw new OptimizeRuntimeException("Unknown single report entity type: " + String.valueOf((Object)reportToImport.getExportEntityType()));
            }
        }
    }

    private void importProcessReportIntoCollection(String userId, String collectionId, SingleProcessReportDefinitionExportDto reportToImport, Map<String, EntityIdResponseDto> originalIdToNewIdMap) {
        IdResponseDto newId = this.importReport(Optional.ofNullable(userId).orElse("System User"), reportToImport, collectionId);
        originalIdToNewIdMap.put(reportToImport.getId(), new EntityIdResponseDto(newId.getId(), EntityType.REPORT));
    }

    private void importCombinedProcessReportIntoCollection(String userId, String collectionId, CombinedProcessReportDefinitionExportDto reportToImport, Map<String, EntityIdResponseDto> originalIdToNewIdMap) {
        this.prepareCombinedReportForImport(reportToImport, originalIdToNewIdMap);
        IdResponseDto newId = this.importReport(Optional.ofNullable(userId).orElse("System User"), reportToImport, collectionId);
        originalIdToNewIdMap.put(reportToImport.getId(), new EntityIdResponseDto(newId.getId(), EntityType.REPORT));
    }

    private void importDecisionReportIntoCollection(String userId, String collectionId, SingleDecisionReportDefinitionExportDto reportToImport, Map<String, EntityIdResponseDto> originalIdToNewIdMap) {
        IdResponseDto newId = this.importReport(Optional.ofNullable(userId).orElse("System User"), reportToImport, collectionId);
        originalIdToNewIdMap.put(reportToImport.getId(), new EntityIdResponseDto(newId.getId(), EntityType.REPORT));
    }

    public IdResponseDto importReport(String userId, ReportDefinitionExportDto reportToImport, String newCollectionId) {
        switch (reportToImport.getExportEntityType()) {
            case COMBINED_REPORT: {
                return this.reportWriter.createNewCombinedReport(Optional.ofNullable(userId).orElse("System User"), ((CombinedProcessReportDefinitionExportDto)reportToImport).getData(), reportToImport.getName(), reportToImport.getDescription(), newCollectionId);
            }
            case SINGLE_PROCESS_REPORT: {
                return this.reportWriter.createNewSingleProcessReport(Optional.ofNullable(userId).orElse("System User"), ((SingleProcessReportDefinitionExportDto)reportToImport).getData(), reportToImport.getName(), reportToImport.getDescription(), newCollectionId);
            }
            case SINGLE_DECISION_REPORT: {
                return this.reportWriter.createNewSingleDecisionReport(Optional.ofNullable(userId).orElse("System User"), ((SingleDecisionReportDefinitionExportDto)reportToImport).getData(), reportToImport.getName(), reportToImport.getDescription(), newCollectionId);
            }
        }
        throw new IllegalStateException("Unsupported entity type: " + String.valueOf((Object)reportToImport.getExportEntityType()));
    }

    private void prepareCombinedReportForImport(CombinedProcessReportDefinitionExportDto reportToImport, Map<String, EntityIdResponseDto> originalIdToNewIdMap) {
        List<CombinedReportItemDto> newSingleReportItems = reportToImport.getData().getReports().stream().map(reportItem -> new CombinedReportItemDto(((EntityIdResponseDto)originalIdToNewIdMap.get(reportItem.getId())).getId(), reportItem.getColor())).toList();
        reportToImport.getData().setReports(newSingleReportItems);
    }

    private void removeMissingVersionsOrFailIfNoVersionsExist(SingleDecisionReportDefinitionExportDto exportDto) {
        this.removeMissingVersionsOrFailIfNoneExist(DefinitionType.DECISION, exportDto.getData().getDecisionDefinitionKey(), exportDto.getData().getDecisionDefinitionVersions(), exportDto.getData().getTenantIds());
    }

    private void removeMissingVersionsOrFailIfNoVersionsExist(SingleProcessReportDefinitionExportDto exportDto) {
        this.removeMissingVersionsOrFailIfNoneExist(DefinitionType.PROCESS, exportDto.getData().getProcessDefinitionKey(), exportDto.getData().getProcessDefinitionVersions(), exportDto.getData().getTenantIds());
    }

    private void removeMissingVersionsOrFailIfNoneExist(DefinitionType definitionType, String definitionKey, List<String> definitionVersions, List<String> tenantIds) {
        ArrayList<String> requiredVersions = new ArrayList<String>(definitionVersions);
        boolean isAllOrLatest = DefinitionVersionHandlingUtil.isDefinitionVersionSetToAllOrLatest(requiredVersions);
        List<String> existingVersions = this.getExistingDefinitionVersions(definitionType, definitionKey, tenantIds);
        if (!isAllOrLatest) {
            definitionVersions.removeIf(version -> !existingVersions.contains(version));
        }
        if (isAllOrLatest && existingVersions.isEmpty() || !isAllOrLatest && definitionVersions.isEmpty()) {
            throw new OptimizeImportDefinitionDoesNotExistException("Could not find the required definition for this report", DataUtil.newHashSet(DefinitionExceptionItemDto.builder().type(definitionType).key(definitionKey).tenantIds(tenantIds).versions(requiredVersions).build()));
        }
    }

    private List<String> getExistingDefinitionVersions(DefinitionType definitionType, String definitionKey, List<String> tenantIds) {
        return this.definitionService.getDefinitionVersions(definitionType, definitionKey, tenantIds).stream().map(DefinitionVersionResponseDto::getVersion).toList();
    }

    private void populateDefinitionXml(SingleProcessReportDefinitionExportDto exportDto) {
        Optional<ProcessDefinitionOptimizeDto> definitionWithXml = this.definitionService.getDefinitionWithXmlAsService(DefinitionType.PROCESS, exportDto.getData().getProcessDefinitionKey(), exportDto.getData().getDefinitionVersions(), exportDto.getData().getTenantIds());
        definitionWithXml.ifPresent(def -> exportDto.getData().getConfiguration().setXml(def.getBpmn20Xml()));
    }

    private void populateDefinitionXml(SingleDecisionReportDefinitionExportDto exportDto) {
        Optional<DecisionDefinitionOptimizeDto> definitionWithXml = this.definitionService.getDefinitionWithXmlAsService(DefinitionType.DECISION, exportDto.getData().getDecisionDefinitionKey(), exportDto.getData().getDefinitionVersions(), exportDto.getData().getTenantIds());
        definitionWithXml.ifPresent(def -> exportDto.getData().getConfiguration().setXml(def.getDmn10Xml()));
    }

    private void validateReportOrFail(String userId, CollectionDefinitionDto collection, ReportDefinitionExportDto reportToImport) {
        try {
            this.reportService.validateReportDescription(reportToImport.getDescription());
        }
        catch (OptimizeValidationException ex) {
            throw new OptimizeImportDescriptionNotValidException(Set.of(reportToImport.getId()));
        }
        switch (reportToImport.getExportEntityType()) {
            case SINGLE_PROCESS_REPORT: {
                SingleProcessReportDefinitionExportDto processExport = (SingleProcessReportDefinitionExportDto)reportToImport;
                this.validateIndexVersionOrFail(11, "single-process-report", processExport);
                this.removeMissingVersionsOrFailIfNoVersionsExist(processExport);
                if (userId != null) {
                    this.validateAuthorizedToAccessDefinitionOrFail(userId, processExport);
                }
                this.validateCollectionScopeOrFail(collection, processExport);
                this.populateDefinitionXml(processExport);
                break;
            }
            case SINGLE_DECISION_REPORT: {
                SingleDecisionReportDefinitionExportDto decisionExport = (SingleDecisionReportDefinitionExportDto)reportToImport;
                this.validateIndexVersionOrFail(10, "single-decision-report", decisionExport);
                this.removeMissingVersionsOrFailIfNoVersionsExist(decisionExport);
                if (userId != null) {
                    this.validateAuthorizedToAccessDefinitionOrFail(userId, decisionExport);
                }
                this.validateCollectionScopeOrFail(collection, decisionExport);
                this.populateDefinitionXml(decisionExport);
                break;
            }
            case COMBINED_REPORT: {
                CombinedProcessReportDefinitionExportDto combinedExport = (CombinedProcessReportDefinitionExportDto)reportToImport;
                this.validateIndexVersionOrFail(5, "combined-report", combinedExport);
                break;
            }
            default: {
                throw new OptimizeRuntimeException("Unknown report entity type: " + String.valueOf((Object)reportToImport.getExportEntityType()));
            }
        }
    }

    private String getFullyQualifiedIndexName(String name, int version) {
        String indexName = OptimizeIndexNameService.getOptimizeIndexOrTemplateNameForAliasAndVersion((String)name, (String)Integer.toString(version));
        return OptimizeIndexNameService.getOptimizeIndexAliasForIndexNameAndPrefix((String)indexName, (String)this.optimizeIndexNameService.getIndexPrefix());
    }

    private void validateIndexVersionOrFail(int targetVersion, String rawIndexName, ReportDefinitionExportDto exportDto) {
        String targetName = this.getFullyQualifiedIndexName(rawIndexName, targetVersion);
        if (targetVersion != exportDto.getSourceIndexVersion()) {
            throw new OptimizeImportIncorrectIndexVersionException("Could not import because source and target index versions do not match", DataUtil.newHashSet(ImportIndexMismatchDto.builder().indexName(targetName).sourceIndexVersion(exportDto.getSourceIndexVersion()).targetIndexVersion(targetVersion).build()));
        }
    }

    private void validateAuthorizedToAccessDefinitionOrFail(String userId, SingleProcessReportDefinitionExportDto exportDto) {
        this.validateAuthorizedToAccessDefinitionOrFail(userId, DefinitionType.PROCESS, exportDto.getData().getProcessDefinitionKey(), exportDto.getData().getTenantIds());
    }

    private void validateAuthorizedToAccessDefinitionOrFail(String userId, SingleDecisionReportDefinitionExportDto exportDto) {
        this.validateAuthorizedToAccessDefinitionOrFail(userId, DefinitionType.DECISION, exportDto.getData().getDecisionDefinitionKey(), exportDto.getData().getTenantIds());
    }

    private void validateAuthorizedToAccessDefinitionOrFail(String userId, DefinitionType definitionType, String definitionKey, List<String> tenantIds) {
        if (!this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, definitionType, definitionKey, tenantIds)) {
            throw new OptimizeImportForbiddenException(String.format("User with ID [%s] is not authorized to access the required definition.", userId), DataUtil.newHashSet(DefinitionExceptionItemDto.builder().type(definitionType).key(definitionKey).tenantIds(tenantIds).build()));
        }
    }

    private void validateCollectionScopeOrFail(CollectionDefinitionDto collection, SingleProcessReportDefinitionExportDto reportToImport) {
        if (collection != null) {
            this.reportService.ensureCompliesWithCollectionScope(reportToImport.getData().getDefinitions(), DefinitionType.PROCESS, collection);
        }
    }

    private void validateCollectionScopeOrFail(CollectionDefinitionDto collection, SingleDecisionReportDefinitionExportDto reportToImport) {
        if (collection != null) {
            this.reportService.ensureCompliesWithCollectionScope(reportToImport.getData().getDefinitions(), DefinitionType.DECISION, collection);
        }
    }
}

