/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.writer;

import io.camunda.optimize.dto.optimize.importing.LastKpiEvaluationResultsDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestRequestDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessUpdateDto;
import io.camunda.optimize.service.db.repository.ProcessOverviewRepository;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessOverviewWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessOverviewWriter.class);
    private final ProcessOverviewRepository processOverviewRepository;

    public ProcessOverviewWriter(ProcessOverviewRepository processOverviewRepository) {
        this.processOverviewRepository = processOverviewRepository;
    }

    public void updateProcessConfiguration(String processDefinitionKey, ProcessUpdateDto processUpdateDto) {
        ProcessOverviewDto overviewDto = this.createNewProcessOverviewDto(processDefinitionKey, processUpdateDto);
        this.processOverviewRepository.updateProcessConfiguration(processDefinitionKey, overviewDto);
    }

    public void updateProcessDigestResults(String processDefKey, ProcessDigestDto processDigestDto) {
        this.processOverviewRepository.updateProcessDigestResults(processDefKey, processDigestDto);
    }

    public void updateProcessOwnerIfNotSet(String processDefinitionKey, String ownerId) {
        ProcessUpdateDto processUpdateDto = new ProcessUpdateDto();
        processUpdateDto.setOwnerId(ownerId);
        ProcessDigestRequestDto processDigestRequestDto = new ProcessDigestRequestDto();
        processUpdateDto.setProcessDigest(processDigestRequestDto);
        ProcessOverviewDto processOverviewDto = this.createNewProcessOverviewDto(processDefinitionKey, processUpdateDto);
        this.processOverviewRepository.updateProcessOwnerIfNotSet(processDefinitionKey, ownerId, processOverviewDto);
    }

    public void updateKpisForProcessDefinitions(Map<String, LastKpiEvaluationResultsDto> definitionKeyToKpis) {
        LOG.debug("Updating KPI values for process definitions with keys: [{}]", definitionKeyToKpis.keySet());
        List<ProcessOverviewDto> processOverviewDtos = definitionKeyToKpis.entrySet().stream().map(entry -> {
            Map<String, String> reportIdToValue = ((LastKpiEvaluationResultsDto)entry.getValue()).getReportIdToValue();
            ProcessOverviewDto processOverviewDto = new ProcessOverviewDto();
            processOverviewDto.setProcessDefinitionKey((String)entry.getKey());
            processOverviewDto.setDigest(new ProcessDigestDto(Boolean.valueOf(false), Collections.emptyMap()));
            processOverviewDto.setLastKpiEvaluationResults(reportIdToValue);
            return processOverviewDto;
        }).toList();
        this.processOverviewRepository.updateKpisForProcessDefinitions(processOverviewDtos);
    }

    public void deleteProcessOwnerEntry(String processDefinitionKey) {
        LOG.info("Removing pending entry " + processDefinitionKey);
        this.processOverviewRepository.deleteProcessOwnerEntry(processDefinitionKey);
    }

    private ProcessOverviewDto createNewProcessOverviewDto(String processDefinitionKey, ProcessUpdateDto processUpdateDto) {
        ProcessOverviewDto processOverviewDto = new ProcessOverviewDto();
        processOverviewDto.setProcessDefinitionKey(processDefinitionKey);
        processOverviewDto.setOwner(processUpdateDto.getOwnerId());
        processOverviewDto.setDigest(new ProcessDigestDto(Boolean.valueOf(processUpdateDto.getProcessDigest().isEnabled()), Collections.emptyMap()));
        processOverviewDto.setLastKpiEvaluationResults(Collections.emptyMap());
        return processOverviewDto;
    }
}

