/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.ImportRequestDto;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.RequestType;
import io.camunda.optimize.service.db.helper.ImportRequestDtoFactory;
import io.camunda.optimize.service.db.repository.IndexRepository;
import io.camunda.optimize.service.db.repository.ProcessInstanceRepository;
import io.camunda.optimize.service.db.repository.script.ZeebeProcessInstanceScriptFactory;
import io.camunda.optimize.service.db.schema.index.IndexMappingCreatorBuilder;
import io.camunda.optimize.service.db.writer.DatabaseWriterUtil;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceWriter {
    private static final String NEW_INSTANCE = "instance";
    private static final String FORMATTER = "dateFormatPattern";
    private static final String SOURCE_EXPORT_INDEX = "sourceExportIndex";
    private static final Logger LOG = LoggerFactory.getLogger(ProcessInstanceWriter.class);
    private final IndexRepository indexRepository;
    private final ObjectMapper objectMapper;
    private final ImportRequestDtoFactory importRequestDtoFactory;
    private final ProcessInstanceRepository processInstanceRepository;

    public ProcessInstanceWriter(IndexRepository indexRepository, ObjectMapper objectMapper, ImportRequestDtoFactory importRequestDtoFactory, ProcessInstanceRepository processInstanceRepository) {
        this.indexRepository = indexRepository;
        this.objectMapper = objectMapper;
        this.importRequestDtoFactory = importRequestDtoFactory;
        this.processInstanceRepository = processInstanceRepository;
    }

    public List<ImportRequestDto> generateProcessInstanceImports(List<ProcessInstanceDto> processInstances, String sourceExportIndex) {
        String importItemName = "zeebe process instances";
        LOG.debug("Creating imports for {} [{}].", (Object)processInstances.size(), (Object)"zeebe process instances");
        this.indexRepository.createMissingIndices(IndexMappingCreatorBuilder.PROCESS_INSTANCE_INDEX, Set.of("process-instance"), processInstances.stream().map(ProcessInstanceDto::getProcessDefinitionKey).collect(Collectors.toSet()));
        return processInstances.stream().map(procInst -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(NEW_INSTANCE, procInst);
            params.put(FORMATTER, "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            params.put(SOURCE_EXPORT_INDEX, sourceExportIndex);
            params.put("flowNodeInstances", procInst.getFlowNodeInstances());
            return ImportRequestDto.builder().importName("zeebe process instances").type(RequestType.UPDATE).id(procInst.getProcessInstanceId()).indexName(InstanceIndexUtil.getProcessInstanceIndexAliasName((String)procInst.getProcessDefinitionKey())).source(procInst).retryNumberOnConflict(5).scriptData(DatabaseWriterUtil.createScriptData(ZeebeProcessInstanceScriptFactory.createProcessInstanceUpdateScript(), params, this.objectMapper)).build();
        }).collect(Collectors.toList());
    }

    public void deleteByIds(String definitionKey, List<String> processInstanceIds) {
        LOG.debug("Deleting [{}] process instance documents with bulk request.", (Object)processInstanceIds.size());
        String index = InstanceIndexUtil.getProcessInstanceIndexAliasName((String)definitionKey);
        this.processInstanceRepository.deleteByIds(index, index, processInstanceIds);
    }

    public List<ImportRequestDto> generateRunningProcessInstanceImports(List<ProcessInstanceDto> processInstances) {
        String importItemName = "running process instances";
        LOG.debug("Creating imports for {} [{}].", (Object)processInstances.size(), (Object)"running process instances");
        this.indexRepository.createMissingIndices(IndexMappingCreatorBuilder.PROCESS_INSTANCE_INDEX, Set.of("process-instance"), processInstances.stream().map(ProcessInstanceDto::getProcessDefinitionKey).collect(Collectors.toSet()));
        return processInstances.stream().map(instance -> this.importRequestDtoFactory.createImportRequestForProcessInstance((ProcessInstanceDto)instance, Set.of("processDefinitionKey", "processDefinitionVersion", "processDefinitionId", "businessKey", "startDate", "state", "dataSource", "tenantId"), "running process instances")).toList();
    }

    public List<ImportRequestDto> generateCompletedProcessInstanceImports(List<ProcessInstanceDto> processInstances) {
        String importItemName = "completed process instances";
        LOG.debug("Creating imports for {} [{}].", (Object)processInstances.size(), (Object)"completed process instances");
        this.indexRepository.createMissingIndices(IndexMappingCreatorBuilder.PROCESS_INSTANCE_INDEX, Set.of("process-instance"), processInstances.stream().map(ProcessInstanceDto::getProcessDefinitionKey).collect(Collectors.toSet()));
        return processInstances.stream().map(processInstanceDto -> this.importRequestDtoFactory.createImportRequestForProcessInstance((ProcessInstanceDto)processInstanceDto, Set.of("processDefinitionKey", "processDefinitionVersion", "processDefinitionId", "businessKey", "startDate", "endDate", "duration", "state", "dataSource", "tenantId"), "completed process instances")).toList();
    }
}

