/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.os;

import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.repository.TaskRepository;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.upgrade.es.TaskResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch.tasks.GetTasksResponse;
import org.opensearch.client.opensearch.tasks.Info;
import org.opensearch.client.opensearch.tasks.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class TaskRepositoryOS
extends TaskRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRepositoryOS.class);
    private final OptimizeOpenSearchClient osClient;

    public TaskRepositoryOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    @Override
    public List<TaskRepository.TaskProgressInfo> tasksProgress(String action) {
        return this.osClient.getRichOpenSearchClient().task().tasksWithActions(List.of(action)).entrySet().stream().filter(taskInfo -> "bulk-by-scroll".equals(((Info)taskInfo.getValue()).type())).map(taskInfo -> ((Info)taskInfo.getValue()).status()).map(status -> new TaskRepository.TaskProgressInfo(TaskRepositoryOS.getProgress(status), status.total(), TaskRepositoryOS.getProcessedTasksCount(status))).toList();
    }

    private static long getProcessedTasksCount(Status status) {
        return status.deleted() + status.created() + status.updated();
    }

    private static int getProgress(Status status) {
        return status.total() > 0L ? Double.valueOf((double)TaskRepositoryOS.getProcessedTasksCount(status) / (double)status.total() * 100.0).intValue() : 0;
    }

    @Override
    public TaskResponse getTaskResponse(String taskId) throws IOException {
        GetTasksResponse taskResponse = this.osClient.getRichOpenSearchClient().task().taskWithRetries(taskId);
        return this.createTaskResponseFromGetTasksResponse(taskResponse);
    }

    private TaskResponse createTaskResponseFromGetTasksResponse(GetTasksResponse getTasksResponse) {
        boolean completed = getTasksResponse.completed();
        Info taskInfo = getTasksResponse.task();
        TaskResponse.Status status = null;
        if (taskInfo.status() != null) {
            status = new TaskResponse.Status(Long.valueOf(taskInfo.status().total()), Long.valueOf(taskInfo.status().updated()), Long.valueOf(taskInfo.status().created()), Long.valueOf(taskInfo.status().deleted()));
        }
        TaskResponse.Task task = new TaskResponse.Task(String.valueOf(taskInfo.id()), status);
        TaskResponse.Error error = null;
        if (getTasksResponse.error() != null) {
            List stackTrace = getTasksResponse.error().stackTrace() != null ? List.of(getTasksResponse.error().stackTrace()) : Collections.emptyList();
            Map<Object, Object> causedByMap = Map.of();
            ErrorCause causedByResponse = getTasksResponse.error().causedBy();
            if (causedByResponse != null && causedByResponse.type() != null && causedByResponse.reason() != null) {
                causedByMap = Map.of(causedByResponse.type(), causedByResponse.reason());
            }
            error = new TaskResponse.Error(getTasksResponse.error().type(), getTasksResponse.error().reason(), stackTrace, causedByMap);
        }
        TaskResponse.TaskResponseDetails responseDetails = null;
        if (getTasksResponse.response() != null) {
            responseDetails = new TaskResponse.TaskResponseDetails(new ArrayList(getTasksResponse.response().failures()));
        }
        return new TaskResponse(completed, task, error, responseDetails);
    }
}

