/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.os;

import io.camunda.optimize.service.db.os.MappingMetadataUtilOS;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.repository.MappingMetadataRepository;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class MappingMetadataRepositoryOS
implements MappingMetadataRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MappingMetadataRepositoryOS.class);
    private final OptimizeOpenSearchClient osClient;

    public MappingMetadataRepositoryOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    @Override
    public String[] getIndexAliasesWithImportIndexFlag(boolean isImportIndex) {
        MappingMetadataUtilOS mappingUtil = new MappingMetadataUtilOS(this.osClient);
        return (String[])mappingUtil.getAllMappings(this.osClient.getIndexNameService().getIndexPrefix()).stream().filter(mapping -> isImportIndex == mapping.isImportIndex()).map(arg_0 -> ((OptimizeIndexNameService)this.osClient.getIndexNameService()).getOptimizeIndexAliasForIndex(arg_0)).toArray(String[]::new);
    }
}

