/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.os;

import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.schema.OpenSearchSchemaManager;
import io.camunda.optimize.service.db.repository.IndexRepository;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.db.schema.index.IndexMappingCreatorBuilder;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class IndexRepositoryOS
implements IndexRepository,
ConfigurationReloadable {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRepositoryOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final OpenSearchSchemaManager openSearchSchemaManager;
    private final OptimizeIndexNameService indexNameService;
    private final Set<String> indices = ConcurrentHashMap.newKeySet();

    public IndexRepositoryOS(OptimizeOpenSearchClient osClient, OpenSearchSchemaManager openSearchSchemaManager, OptimizeIndexNameService indexNameService) {
        this.osClient = osClient;
        this.openSearchSchemaManager = openSearchSchemaManager;
        this.indexNameService = indexNameService;
    }

    public void reloadConfiguration(ApplicationContext context) {
        this.indices.clear();
    }

    @Override
    public void createMissingIndices(IndexMappingCreatorBuilder indexMappingCreatorBuilder, Set<String> readOnlyAliases, Set<String> keys) {
        keys.stream().map(indexMappingCreatorBuilder.getOpensearch()).filter(indexMappingCreator -> !this.indexExists(this.getIndexName((IndexMappingCreator<IndexSettings.Builder>)indexMappingCreator))).forEach(indexMappingCreator -> this.createMissingIndex((IndexMappingCreator<IndexSettings.Builder>)indexMappingCreator, readOnlyAliases));
    }

    @Override
    public boolean indexExists(IndexMappingCreatorBuilder indexMappingCreatorBuilder, String key) {
        return this.indexExists(((IndexMappingCreator)indexMappingCreatorBuilder.getOpensearch().apply(key)).getIndexName());
    }

    private void createMissingIndex(IndexMappingCreator<IndexSettings.Builder> indexMappingCreator, Set<String> readOnlyAliases) {
        LOG.debug("Creating index {}.", (Object)this.getIndexName(indexMappingCreator));
        this.openSearchSchemaManager.createOrUpdateOptimizeIndex(this.osClient, indexMappingCreator, readOnlyAliases);
        this.indices.add(this.getIndexName(indexMappingCreator));
    }

    private boolean indexExists(String index) {
        return this.indices.contains(index) || this.openSearchSchemaManager.indexExists(this.osClient, index);
    }

    private String getIndexName(IndexMappingCreator<IndexSettings.Builder> indexMappingCreator) {
        return this.indexNameService.getOptimizeIndexNameWithVersion(indexMappingCreator);
    }
}

