/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.os;

import io.camunda.optimize.dto.optimize.OptimizeDto;
import io.camunda.optimize.dto.optimize.datasource.DataSourceDto;
import io.camunda.optimize.dto.optimize.index.ImportIndexDto;
import io.camunda.optimize.dto.optimize.index.PositionBasedImportIndexDto;
import io.camunda.optimize.dto.optimize.index.TimestampBasedImportIndexDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.repository.ImportRepository;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.DatabaseHelper;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ImportRepositoryOS
implements ImportRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ImportRepositoryOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;
    private final OptimizeIndexNameService indexNameService;
    private final DateTimeFormatter dateTimeFormatter;

    public ImportRepositoryOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService, OptimizeIndexNameService indexNameService, DateTimeFormatter dateTimeFormatter) {
        this.osClient = osClient;
        this.configurationService = configurationService;
        this.indexNameService = indexNameService;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public List<TimestampBasedImportIndexDto> getAllTimestampBasedImportIndicesForTypes(List<String> indexTypes) {
        LOG.debug("Fetching timestamp based import indices of types '{}'", indexTypes);
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("timestamp-based-import-index"), new String[0]).query(QueryDSL.stringTerms((String)"esTypeIndexRefersTo", indexTypes)).size(Integer.valueOf(1000));
        return this.osClient.searchValues(requestBuilder, TimestampBasedImportIndexDto.class);
    }

    @Override
    public <T extends ImportIndexDto<D>, D extends DataSourceDto> Optional<T> getImportIndex(String indexName, String indexType, Class<T> importDTOClass, String typeIndexComesFrom, D dataSourceDto) {
        LOG.debug("Fetching {} import index of type '{}'", (Object)indexType, (Object)typeIndexComesFrom);
        GetResponse response = this.osClient.get(this.indexNameService.getOptimizeIndexAliasForIndex(indexName), DatabaseHelper.constructKey(typeIndexComesFrom, dataSourceDto), importDTOClass, String.format("Could not fetch %s import index", indexType));
        if (response.found()) {
            return Optional.ofNullable((ImportIndexDto)response.source());
        }
        LOG.debug("Was not able to retrieve {} import index for type [{}] and engine [{}] from opensearch.", new Object[]{indexType, typeIndexComesFrom, dataSourceDto});
        return Optional.empty();
    }

    @Override
    public void importPositionBasedIndices(String importItemName, List<PositionBasedImportIndexDto> importIndexDtos) {
        this.osClient.doImportBulkRequestWithList(importItemName, importIndexDtos, this::addPositionBasedImportIndexRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached());
    }

    @Override
    public void importIndices(String importItemName, List<TimestampBasedImportIndexDto> timestampBasedImportIndexDtos) {
        this.osClient.doImportBulkRequestWithList(importItemName, timestampBasedImportIndexDtos, this::addImportIndexRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached());
    }

    private BulkOperation addPositionBasedImportIndexRequest(PositionBasedImportIndexDto optimizeDto) {
        LOG.debug("Writing position based import index of type [{}] with position [{}] to opensearch", (Object)optimizeDto.getDbTypeIndexRefersTo(), (Object)optimizeDto.getPositionOfLastEntity());
        return (BulkOperation)new BulkOperation.Builder().index(((IndexOperation.Builder)((IndexOperation.Builder)new IndexOperation.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("position-based-import-index"))).id(DatabaseHelper.constructKey(optimizeDto.getDbTypeIndexRefersTo(), optimizeDto.getDataSource()))).document((Object)optimizeDto).build()).build();
    }

    private BulkOperation addImportIndexRequest(OptimizeDto optimizeDto) {
        if (optimizeDto instanceof TimestampBasedImportIndexDto) {
            TimestampBasedImportIndexDto timestampBasedIndexDto = (TimestampBasedImportIndexDto)optimizeDto;
            return this.createTimestampBasedRequest(timestampBasedIndexDto);
        }
        throw new OptimizeRuntimeException(String.format("Import bulk operation is not supported for %s", optimizeDto.getClass().getName()));
    }

    private BulkOperation createTimestampBasedRequest(TimestampBasedImportIndexDto importIndex) {
        String currentTimeStamp = this.dateTimeFormatter.format(importIndex.getTimestampOfLastEntity());
        LOG.debug("Writing timestamp based import index [{}] of type [{}] with execution timestamp [{}] to opensearch", new Object[]{currentTimeStamp, importIndex.getDbTypeIndexRefersTo(), importIndex.getLastImportExecutionTimestamp()});
        return (BulkOperation)new BulkOperation.Builder().index(((IndexOperation.Builder)((IndexOperation.Builder)new IndexOperation.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("timestamp-based-import-index"))).id(this.getId(importIndex))).document((Object)importIndex).build()).build();
    }

    private String getId(TimestampBasedImportIndexDto importIndex) {
        return DatabaseHelper.constructKey(importIndex.getDbTypeIndexRefersTo(), importIndex.getDataSourceName());
    }
}

