/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSource;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeBucket;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeTermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DoubleTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.DoubleTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.LongTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.LongTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.MgetRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import co.elastic.clients.elasticsearch.core.mget.MultiGetOperation;
import co.elastic.clients.elasticsearch.core.mget.MultiGetResponseItem;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableValueRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.DefinitionVariableLabelsDto;
import io.camunda.optimize.dto.optimize.query.variable.ExternalProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessToQueryDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableSourceDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableValuesQueryDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.dto.optimize.query.variable.VariableUpdateInstanceDto;
import io.camunda.optimize.service.db.es.ElasticsearchCompositeAggregationScroller;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeDeleteRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeMultiGetOperationBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateOperationBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateRequestBuilderES;
import io.camunda.optimize.service.db.es.filter.ProcessQueryFilterEnhancerES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.es.schema.index.DecisionInstanceIndexES;
import io.camunda.optimize.service.db.es.schema.index.ExternalProcessVariableIndexES;
import io.camunda.optimize.service.db.es.schema.index.ProcessInstanceIndexES;
import io.camunda.optimize.service.db.es.schema.index.VariableUpdateInstanceIndexES;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.reader.DecisionDefinitionReader;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.repository.VariableRepository;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.db.repository.script.ProcessInstanceScriptFactory;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.db.schema.ScriptData;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.DecisionVariableHelper;
import io.camunda.optimize.service.util.DefinitionQueryUtilES;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import io.camunda.optimize.util.LogUtil;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class VariableRepositoryES
implements VariableRepository {
    private static final Logger LOG = LoggerFactory.getLogger(VariableRepositoryES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;
    private final ConfigurationService configurationService;
    private final DateTimeFormatter dateTimeFormatter;
    private final DecisionDefinitionReader decisionDefinitionReader;
    private final ProcessQueryFilterEnhancerES processQueryFilterEnhancer;
    private final ProcessDefinitionReader processDefinitionReader;
    private final TaskRepositoryES taskRepositoryES;

    public VariableRepositoryES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper, ConfigurationService configurationService, DateTimeFormatter dateTimeFormatter, DecisionDefinitionReader decisionDefinitionReader, ProcessQueryFilterEnhancerES processQueryFilterEnhancer, ProcessDefinitionReader processDefinitionReader, TaskRepositoryES taskRepositoryES) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
        this.configurationService = configurationService;
        this.dateTimeFormatter = dateTimeFormatter;
        this.decisionDefinitionReader = decisionDefinitionReader;
        this.processQueryFilterEnhancer = processQueryFilterEnhancer;
        this.processDefinitionReader = processDefinitionReader;
        this.taskRepositoryES = taskRepositoryES;
    }

    @Override
    public void deleteVariableDataByProcessInstanceIds(String processDefinitionKey, List<String> processInstanceIds) {
        BulkRequest bulkRequest = BulkRequest.of(b -> {
            b.refresh(Refresh.True);
            processInstanceIds.forEach(id -> b.operations(o -> o.update(OptimizeUpdateOperationBuilderES.of(u -> ((UpdateOperation.Builder)u.optimizeIndex(this.esClient, InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)).id(id)).action(a -> a.script(Script.of(s -> s.inline(i -> i.source(ProcessInstanceScriptFactory.createVariableClearScript()))))).retryOnConflict(Integer.valueOf(5))))));
            return b;
        });
        this.esClient.doBulkRequest(bulkRequest, InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey), false);
    }

    @Override
    public void upsertVariableLabel(String variableLabelIndexName, DefinitionVariableLabelsDto definitionVariableLabelsDto, ScriptData scriptData) {
        Script updateEntityScript = ElasticsearchWriterUtil.createDefaultScriptWithSpecificDtoParams(scriptData.scriptString(), scriptData.params());
        try {
            UpdateRequest updateRequest = OptimizeUpdateRequestBuilderES.of(u -> u.optimizeIndex(this.esClient, new String[]{variableLabelIndexName}).id(definitionVariableLabelsDto.getDefinitionKey().toLowerCase(Locale.ENGLISH)).upsert((Object)definitionVariableLabelsDto).script(updateEntityScript).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5)));
            this.esClient.update(updateRequest, DefinitionVariableLabelsDto.class);
        }
        catch (IOException e) {
            String errorMessage = String.format("Was not able to update the variable labels for the process definition with id: [%s]", definitionVariableLabelsDto.getDefinitionKey());
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            String errorMessage = String.format("Was not able to update the variable labels for the process definition with id: [%s] due to an Elasticsearch exception", definitionVariableLabelsDto.getDefinitionKey());
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void deleteVariablesForDefinition(String variableLabelIndexName, String processDefinitionKey) {
        DeleteRequest request = OptimizeDeleteRequestBuilderES.of(d -> d.optimizeIndex(this.esClient, variableLabelIndexName).id(processDefinitionKey).refresh(Refresh.True));
        try {
            this.esClient.delete(request);
        }
        catch (IOException e) {
            String errorMessage = String.format("Could not delete variable label document with id [%s]. ", processDefinitionKey);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void deleteByProcessInstanceIds(List<String> processInstanceIds) {
        this.taskRepositoryES.tryDeleteByQueryRequest(Query.of(q -> q.bool(b -> b.filter(f -> f.terms(t -> t.field("processInstanceId").terms(tt -> tt.value(processInstanceIds.stream().map(FieldValue::of).toList())))))), String.format("variable updates of %d process instances", processInstanceIds.size()), false, this.esClient.getIndexNameService().getOptimizeIndexNameWithVersionWithWildcardSuffix((IndexMappingCreator)new VariableUpdateInstanceIndexES()));
    }

    @Override
    public Map<String, DefinitionVariableLabelsDto> getVariableLabelsByKey(List<String> processDefinitionKeys) {
        try {
            return this.esClient.mget(MgetRequest.of(m -> {
                processDefinitionKeys.forEach(processDefinitionKey -> m.docs(MultiGetOperation.of(o -> new OptimizeMultiGetOperationBuilderES().optimizeIndex(this.esClient, "variable-label").id(processDefinitionKey.toLowerCase(Locale.ENGLISH))), new MultiGetOperation[0]));
                return m;
            }), DefinitionVariableLabelsDto.class).docs().stream().map(this::extractDefinitionLabelsDto).flatMap(Optional::stream).peek(label -> label.setDefinitionKey(label.getDefinitionKey().toLowerCase(Locale.ENGLISH))).collect(Collectors.toMap(DefinitionVariableLabelsDto::getDefinitionKey, Function.identity()));
        }
        catch (IOException e) {
            String errorMessage = String.format("There was an error while fetching documents from the variable label index with keys %s.", processDefinitionKeys);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public List<VariableUpdateInstanceDto> getVariableInstanceUpdatesForProcessInstanceIds(Set<String> processInstanceIds) {
        SearchResponse searchResponse;
        try {
            searchResponse = this.esClient.search(OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{"variable-update-instance"}).scroll(c -> c.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s")).query(q -> q.bool(b -> b.must(m -> m.terms(t -> t.field("processInstanceId").terms(tt -> tt.value(processInstanceIds.stream().map(FieldValue::of).toList())))))).size(Integer.valueOf(10000)).sort(ss -> ss.field(f -> f.field("timestamp").order(SortOrder.Asc)))), VariableUpdateInstanceDto.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve variable instance updates!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve variable instance updates!", (Throwable)e);
        }
        return ElasticsearchReaderUtil.retrieveAllScrollResults(searchResponse, VariableUpdateInstanceDto.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
    }

    @Override
    public void writeExternalProcessVariables(List<ExternalProcessVariableDto> variables, String itemName) {
        if (!variables.isEmpty()) {
            BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
            variables.forEach(variable -> this.addInsertExternalVariableRequest(bulkRequestBuilder, (ExternalProcessVariableDto)variable));
            this.esClient.doBulkRequest(bulkRequestBuilder.build(), itemName, false);
        }
    }

    @Override
    public void deleteExternalVariablesIngestedBefore(OffsetDateTime timestamp, String deletedItemIdentifier) {
        this.taskRepositoryES.tryDeleteByQueryRequest(Query.of(q -> q.bool(b -> b.filter(f -> f.range(r -> r.field("ingestionTimestamp").lt(JsonData.of((Object)this.dateTimeFormatter.format(timestamp))))))), deletedItemIdentifier, false, this.esClient.getIndexNameService().getOptimizeIndexNameWithVersionWithWildcardSuffix((IndexMappingCreator)new ExternalProcessVariableIndexES()));
    }

    @Override
    public List<ExternalProcessVariableDto> getVariableUpdatesIngestedAfter(Long ingestTimestamp, int limit) {
        return this.getPageOfVariablesSortedByIngestionTimestamp(Query.of(q -> q.range(r -> r.field("ingestionTimestamp").gt(JsonData.of((Object)ingestTimestamp)))), limit);
    }

    @Override
    public List<ExternalProcessVariableDto> getVariableUpdatesIngestedAt(Long ingestTimestamp) {
        return this.getPageOfVariablesSortedByIngestionTimestamp(Query.of(q -> q.range(r -> r.field("ingestionTimestamp").lte(JsonData.of((Object)ingestTimestamp)).gte(JsonData.of((Object)ingestTimestamp)))), 10000);
    }

    @Override
    public List<String> getDecisionVariableValues(DecisionVariableValueRequestDto requestDto, String variablesPath) {
        BoolQuery.Builder definitionQueryBuilder = DefinitionQueryUtilES.createDefinitionQuery(requestDto.getDecisionDefinitionKey(), requestDto.getDecisionDefinitionVersions(), requestDto.getTenantIds(), new DecisionInstanceIndexES(requestDto.getDecisionDefinitionKey()), this.decisionDefinitionReader::getLatestVersionToKey);
        try {
            SearchResponse searchResponse = this.esClient.search(OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{InstanceIndexUtil.getDecisionInstanceIndexAliasName((String)requestDto.getDecisionDefinitionKey())}).query(Query.of(q -> q.bool(definitionQueryBuilder.build()))).aggregations(this.getDecisionVariableValueAggregation(requestDto, variablesPath)).size(Integer.valueOf(0))), Object.class);
            Map aggregations = searchResponse.aggregations();
            return this.extractVariableValues(aggregations, requestDto, variablesPath);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch values for variable [%s] with type [%s] ", requestDto.getVariableId(), requestDto.getVariableType());
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.DECISION, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to fetch variable values because no instance index with alias {} exists. Returning empty list.", (Object)InstanceIndexUtil.getDecisionInstanceIndexAliasName((String)requestDto.getDecisionDefinitionKey()));
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public List<ProcessVariableNameResponseDto> getVariableNames(ProcessVariableNameRequestDto variableNameRequest, List<ProcessToQueryDto> validNameRequests, List<String> processDefinitionKeys, Map<String, DefinitionVariableLabelsDto> definitionLabelsDtos) {
        Supplier<BoolQuery.Builder> builderSupplier = () -> {
            BoolQuery.Builder builder = new BoolQuery.Builder().minimumShouldMatch("1");
            validNameRequests.forEach(request -> builder.should(s -> s.bool(b -> DefinitionQueryUtilES.createDefinitionQuery(request.getProcessDefinitionKey(), request.getProcessDefinitionVersions(), request.getTenantIds(), new ProcessInstanceIndexES(request.getProcessDefinitionKey()), this.processDefinitionReader::getLatestVersionToKey))));
            this.processQueryFilterEnhancer.addFilterToQuery(builder, variableNameRequest.getFilter().stream().filter(filter -> filter.getAppliedTo().contains("all")).toList(), FilterContext.builder().timezone(variableNameRequest.getTimezone()).build());
            return builder;
        };
        return this.getVariableNamesForInstancesMatchingQuery(processDefinitionKeys, builderSupplier, definitionLabelsDtos);
    }

    @Override
    public List<ProcessVariableNameResponseDto> getVariableNamesForInstancesMatchingQuery(List<String> processDefinitionKeysToTarget, Supplier<BoolQuery.Builder> baseQueryBuilderSupplier, Map<String, DefinitionVariableLabelsDto> definitionLabelsDtos) {
        String[] indicesToTarget = (String[])processDefinitionKeysToTarget.stream().map(InstanceIndexUtil::getProcessInstanceIndexAliasName).toArray(String[]::new);
        BoolQuery boolQuery = baseQueryBuilderSupplier.get().build();
        Function<Map<String, FieldValue>, SearchRequest> aggregationRequestWithAfterKeys = map -> OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, indicesToTarget).query(q -> q.bool(boolQuery)).size(Integer.valueOf(0)).aggregations(Map.of("variables", Aggregation.of(a -> a.nested(n -> n.path("variables")).aggregations("varNameAndTypeCompositeAgg", Aggregation.of(a1 -> a1.composite(c -> {
            c.size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit()).sources(List.of(Map.of("variableNameAggregation", CompositeAggregationSource.of(f -> f.terms(t -> (ObjectBuilder)((CompositeTermsAggregation.Builder)t.missingBucket(Boolean.valueOf(false))).field(ProcessVariableHelper.getNestedVariableNameField())))), Map.of("variableTypeAggregation", CompositeAggregationSource.of(f -> f.terms(t -> (ObjectBuilder)((CompositeTermsAggregation.Builder)t.missingBucket(Boolean.valueOf(false))).field(ProcessVariableHelper.getNestedVariableTypeField())))), Map.of("_index", CompositeAggregationSource.of(f -> f.terms(t -> (ObjectBuilder)((CompositeTermsAggregation.Builder)t.missingBucket(Boolean.valueOf(false))).field("_index"))))));
            if (map != null) {
                c.after(map);
            }
            return c;
        })))))));
        ArrayList<ProcessVariableNameResponseDto> variableNames = new ArrayList<ProcessVariableNameResponseDto>();
        ElasticsearchCompositeAggregationScroller.create().setEsClient(this.esClient).setSearchRequest(aggregationRequestWithAfterKeys.apply(null)).setPathToAggregation("variables", "varNameAndTypeCompositeAgg").setFunction(aggregationRequestWithAfterKeys).setCompositeBucketConsumer(bucket -> variableNames.add(this.extractVariableNameAndLabel((CompositeBucket)bucket, definitionLabelsDtos))).consumeAllPages();
        return this.filterVariableNameResults(variableNames);
    }

    @Override
    public List<String> getVariableValues(ProcessVariableValuesQueryDto requestDto, List<ProcessVariableSourceDto> processVariableSources) {
        BoolQuery.Builder boolBuilder = new BoolQuery.Builder();
        processVariableSources.forEach(source -> {
            boolBuilder.should(s -> s.bool(b -> DefinitionQueryUtilES.createDefinitionQuery(source.getProcessDefinitionKey(), source.getProcessDefinitionVersions(), source.getTenantIds(), new ProcessInstanceIndexES(source.getProcessDefinitionKey()), this.processDefinitionReader::getLatestVersionToKey)));
            if (source.getProcessInstanceId() != null) {
                boolBuilder.must(m -> m.term(t -> t.field("processInstanceId").value(source.getProcessInstanceId())));
            }
        });
        try {
            SearchResponse searchResponse = this.esClient.search(OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{"process-instance"}).query(q -> q.bool(boolBuilder.build())).aggregations(this.getVariableValueAggregation(requestDto)).size(Integer.valueOf(0))), Object.class);
            Map aggregations = searchResponse.aggregations();
            return this.extractVariableValues(aggregations, requestDto);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch values for variable [%s] with type [%s] ", requestDto.getName(), requestDto.getType().getId());
            LOG.error(LogUtil.sanitizeLogMessage((String)reason), (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to fetch variable values because no instance indices exist. Returning empty list.");
                return Collections.emptyList();
            }
            throw e;
        }
    }

    private ProcessVariableNameResponseDto extractVariableNameAndLabel(CompositeBucket bucket, Map<String, DefinitionVariableLabelsDto> definitionLabelsByKey) {
        String processDefinitionKey = this.extractProcessDefinitionKeyFromIndexName(((FieldValue)bucket.key().get("_index")).stringValue());
        String variableName = ((FieldValue)bucket.key().get("variableNameAggregation")).stringValue();
        String variableType = ((FieldValue)bucket.key().get("variableTypeAggregation")).stringValue();
        return this.processVariableNameResponseDtoFrom(definitionLabelsByKey, processDefinitionKey, variableName, variableType);
    }

    private List<String> extractVariableValues(Map<String, Aggregate> aggregations, ProcessVariableValuesQueryDto requestDto) {
        return this.extractVariableValues(aggregations, requestDto.getResultOffset(), requestDto.getNumResults(), "variables");
    }

    private List<String> extractVariableValues(Map<String, Aggregate> aggregations, DecisionVariableValueRequestDto requestDto, String variableFieldLabel) {
        return this.extractVariableValues(aggregations, requestDto.getResultOffset(), requestDto.getNumResults(), variableFieldLabel);
    }

    private List<String> extractVariableValues(Map<String, Aggregate> aggregations, Integer resultOffset, Integer numResults, String variableFieldLabel) {
        ArrayList<String> allValues;
        block4: {
            Aggregate aggregate;
            FilterAggregate filteredVariables;
            block5: {
                block3: {
                    NestedAggregate variablesFromType = aggregations.get(variableFieldLabel).nested();
                    filteredVariables = ((Aggregate)variablesFromType.aggregations().get("filteredVariables")).filter();
                    allValues = new ArrayList<String>();
                    aggregate = (Aggregate)filteredVariables.aggregations().get("values");
                    if (!aggregate.isLterms()) break block3;
                    LongTermsAggregate valueTerms = ((Aggregate)filteredVariables.aggregations().get("values")).lterms();
                    for (LongTermsBucket valueBucket : valueTerms.buckets().array()) {
                        allValues.add(String.valueOf(valueBucket.keyAsString() != null ? valueBucket.keyAsString() : Long.valueOf(valueBucket.key())));
                    }
                    break block4;
                }
                if (!aggregate.isSterms()) break block5;
                StringTermsAggregate valueTerms = ((Aggregate)filteredVariables.aggregations().get("values")).sterms();
                for (StringTermsBucket valueBucket : valueTerms.buckets().array()) {
                    allValues.add(valueBucket.key().stringValue());
                }
                break block4;
            }
            if (!aggregate.isDterms()) break block4;
            DoubleTermsAggregate valueTerms = ((Aggregate)filteredVariables.aggregations().get("values")).dterms();
            for (DoubleTermsBucket valueBucket : valueTerms.buckets().array()) {
                allValues.add(Double.toString(valueBucket.key()));
            }
        }
        return allValues;
    }

    private Map<String, Aggregation> getDecisionVariableValueAggregation(DecisionVariableValueRequestDto requestDto, String variablePath) {
        Map<String, Aggregation> filterForVariableWithGivenIdAndPrefix = this.getVariableValueFilterAggregation(requestDto.getVariableId(), variablePath, requestDto.getVariableType(), requestDto.getValueFilter());
        return this.getVariableValuesAggregation(variablePath, requestDto.getVariableType(), filterForVariableWithGivenIdAndPrefix);
    }

    private Map<String, Aggregation> getVariableValueAggregation(ProcessVariableValuesQueryDto requestDto) {
        Map<String, Aggregation> filterForVariableWithGivenIdAndPrefix = this.getProcessVariableValueFilterAggregation(requestDto.getName(), requestDto.getType(), requestDto.getValueFilter());
        return this.getVariableValuesAggregation("variables", requestDto.getType(), filterForVariableWithGivenIdAndPrefix);
    }

    private Map<String, Aggregation> getVariableValuesAggregation(String variablePath, VariableType variableType, Map<String, Aggregation> filterForVariableWithGivenIdAndPrefix) {
        return Map.of(variablePath, Aggregation.of(a -> a.nested(n -> n.path(variablePath)).aggregations(filterForVariableWithGivenIdAndPrefix)));
    }

    private Map<String, Aggregation> getVariableValueFilterAggregation(String variableId, String variablePath, VariableType type, String valueFilter) {
        BoolQuery.Builder filterQuery = new BoolQuery.Builder();
        filterQuery.must(m -> m.term(t -> t.field(DecisionVariableHelper.getVariableClauseIdField(variablePath)).value(variableId)));
        this.addValueFilter(variablePath, valueFilter, filterQuery);
        return Map.of("filteredVariables", Aggregation.of(a -> a.filter(Query.of(q -> q.bool(filterQuery.build()))).aggregations(Map.of("values", Aggregation.of(a1 -> a1.terms(t -> t.field(DecisionVariableHelper.getVariableValueFieldForType(variablePath, type)).size(Integer.valueOf(10000)).order(NamedValue.of((String)"_key", (Object)SortOrder.Asc), new NamedValue[0])))))));
    }

    private Map<String, Aggregation> getProcessVariableValueFilterAggregation(String variableName, VariableType type, String valueFilter) {
        BoolQuery.Builder filterQuery = new BoolQuery.Builder().must(m -> m.term(t -> t.field(ProcessVariableHelper.getNestedVariableNameField()).value(variableName))).must(m -> m.term(t -> t.field(ProcessVariableHelper.getNestedVariableTypeField()).value(type.getId())));
        this.addValueFilter(type, valueFilter, filterQuery);
        return Map.of("filteredVariables", Aggregation.of(a -> a.filter(q -> q.bool(filterQuery.build())).aggregations(Map.of("values", Aggregation.of(a1 -> a1.terms(t -> t.field(DecisionVariableHelper.getVariableValueFieldForType("variables", type)).size(Integer.valueOf(10000)).order(NamedValue.of((String)"_key", (Object)SortOrder.Asc), new NamedValue[0])))))));
    }

    private void addValueFilter(VariableType variableType, String valueFilter, BoolQuery.Builder filterQueryBuilder) {
        boolean valueFilterIsConfigured;
        boolean isStringVariable = VariableType.STRING.equals((Object)variableType);
        boolean bl = valueFilterIsConfigured = valueFilter != null && !valueFilter.isEmpty();
        if (isStringVariable && valueFilterIsConfigured) {
            String lowerCaseValue = valueFilter.toLowerCase(Locale.ENGLISH);
            filterQueryBuilder.must(m -> {
                if (lowerCaseValue.length() > 10) {
                    m.wildcard(w -> w.field(ProcessVariableHelper.getValueSearchField("lowercaseField")).wildcard(this.buildWildcardQuery(lowerCaseValue)));
                } else {
                    m.term(w -> w.field(ProcessVariableHelper.getValueSearchField("nGramField")).value(lowerCaseValue));
                }
                return m;
            });
        }
    }

    private void addValueFilter(String variablePath, String valueFilter, BoolQuery.Builder filterQuery) {
        if (valueFilter != null && !valueFilter.isEmpty()) {
            String lowerCaseValue = valueFilter.toLowerCase(Locale.ENGLISH);
            filterQuery.must(m -> {
                if (lowerCaseValue.length() > 10) {
                    m.wildcard(w -> w.field(this.getValueSearchField(variablePath, "lowercaseField")).wildcard(this.buildWildcardQuery(lowerCaseValue)));
                } else {
                    m.term(t -> t.field(this.getValueSearchField(variablePath, "nGramField")).value(lowerCaseValue));
                }
                return m;
            });
        }
    }

    private List<ExternalProcessVariableDto> getPageOfVariablesSortedByIngestionTimestamp(Query query, int limit) {
        try {
            SearchResponse searchResponse = this.esClient.search(OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{"external-process-variable"}).query(query).sort(ss -> ss.field(f -> f.field("ingestionTimestamp").order(SortOrder.Asc))).size(Integer.valueOf(limit))), ExternalProcessVariableDto.class);
            return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), ExternalProcessVariableDto.class, this.objectMapper);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Was not able to retrieve ingested variables by timestamp!", (Throwable)e);
        }
    }

    private Optional<DefinitionVariableLabelsDto> extractDefinitionLabelsDto(MultiGetResponseItem<DefinitionVariableLabelsDto> multiGetItemResponse) {
        return Optional.ofNullable((DefinitionVariableLabelsDto)multiGetItemResponse.result().source());
    }

    private void addInsertExternalVariableRequest(BulkRequest.Builder bulkRequestBuilder, ExternalProcessVariableDto externalVariable) {
        bulkRequestBuilder.operations(o -> o.index(IndexOperation.of(i -> ((IndexOperation.Builder)i.index((String)this.esClient.addPrefixesToIndices(new String[]{"external-process-variable"}).get(0))).document((Object)externalVariable))));
    }
}

