/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.elasticsearch.tasks.ListRequest;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.repository.TaskRepository;
import io.camunda.optimize.service.exceptions.ExceptionHelper;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import io.camunda.optimize.service.util.mapper.ObjectMapperFactory;
import io.camunda.optimize.upgrade.es.TaskResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class TaskRepositoryES
extends TaskRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRepositoryES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;

    public TaskRepositoryES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService) {
        this.esClient = esClient;
        this.configurationService = configurationService;
    }

    @Override
    public List<TaskRepository.TaskProgressInfo> tasksProgress(String action) {
        ListRequest request = ListRequest.of(b -> b.actions(action, new String[0]).detailed(Boolean.valueOf(true)));
        return (List)ExceptionHelper.safe(() -> Optional.ofNullable(this.esClient.getTaskList(request).tasks()).map(tasks -> tasks.flat().stream().filter(taskInfo -> taskInfo.status() != null).map(taskInfo -> taskInfo.status().toJson().asJsonObject()).map(status -> new TaskRepository.TaskProgressInfo(TaskRepositoryES.getProgress(status), status.getInt("total"), TaskRepositoryES.getProcessedTasksCount(status))).toList()).orElse(List.of()), e -> "Failed to fetch task progress from Elasticsearch!", (Logger)LOG);
    }

    @Override
    public TaskResponse getTaskResponse(String taskId) throws IOException {
        Request request = new Request("GET", "/_tasks/" + taskId);
        Response response = this.esClient.performRequest(request);
        return (TaskResponse)ObjectMapperFactory.OPTIMIZE_MAPPER.readValue(response.getEntity().getContent(), TaskResponse.class);
    }

    public boolean tryUpdateByQueryRequest(String updateItemIdentifier, Script updateScript, Query filterQuery, String ... indices) {
        LOG.debug("Updating {}", (Object)updateItemIdentifier);
        boolean clusterTaskCheckingEnabled = this.configurationService.getElasticSearchConfiguration().getConnection().isClusterTaskCheckingEnabled();
        UpdateByQueryRequest updateByQueryRequest = UpdateByQueryRequest.of(b -> b.index(this.esClient.addPrefixesToIndices(indices)).query(filterQuery).conflicts(Conflicts.Proceed).script(updateScript).waitForCompletion(Boolean.valueOf(!clusterTaskCheckingEnabled)).refresh(Boolean.valueOf(true)));
        if (clusterTaskCheckingEnabled) {
            return this.asyncUpdate(updateItemIdentifier, filterQuery, updateByQueryRequest);
        }
        return this.syncUpdate(updateByQueryRequest);
    }

    public boolean tryDeleteByQueryRequest(Query query, String deletedItemIdentifier, boolean refresh, String ... indices) {
        LOG.debug("Deleting {}", (Object)deletedItemIdentifier);
        boolean clusterTaskCheckingEnabled = this.configurationService.getElasticSearchConfiguration().getConnection().isClusterTaskCheckingEnabled();
        DeleteByQueryRequest request = DeleteByQueryRequest.of(b -> b.index(this.esClient.addPrefixesToIndices(indices)).query(query).refresh(Boolean.valueOf(refresh)).waitForCompletion(Boolean.valueOf(!clusterTaskCheckingEnabled)).conflicts(Conflicts.Proceed));
        if (clusterTaskCheckingEnabled) {
            return this.asyncDelete(query, deletedItemIdentifier, request);
        }
        return this.syncDelete(request);
    }

    private boolean syncUpdate(UpdateByQueryRequest request) {
        try {
            Long deleted = this.esClient.submitUpdateTask(request).updated();
            return deleted != null && deleted > 0L;
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Error while trying to submit update task", (Throwable)e);
        }
    }

    private boolean asyncUpdate(String updateItemIdentifier, Query filterQuery, UpdateByQueryRequest updateByQueryRequest) {
        String taskId;
        try {
            taskId = this.esClient.submitUpdateTask(updateByQueryRequest).task();
        }
        catch (IOException e) {
            String errorMessage = String.format("Could not create updateBy task for [%s] with query [%s]!", updateItemIdentifier, filterQuery);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        this.waitUntilTaskIsFinished(taskId, updateItemIdentifier);
        try {
            TaskResponse.Status taskStatus = this.getTaskResponse(taskId).getTaskStatus();
            LOG.debug("Updated [{}] {}.", (Object)taskStatus.getDeleted(), (Object)updateItemIdentifier);
            return taskStatus.getUpdated() > 0L;
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException(String.format("Error while trying to read Elasticsearch task status with ID: [%s]", taskId), (Throwable)e);
        }
    }

    private boolean syncDelete(DeleteByQueryRequest request) {
        try {
            Long deleted = this.esClient.submitDeleteTask(request).deleted();
            return deleted != null && deleted > 0L;
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Error while trying to submit update task", (Throwable)e);
        }
    }

    private boolean asyncDelete(Query query, String deletedItemIdentifier, DeleteByQueryRequest request) {
        String taskId;
        try {
            taskId = this.esClient.submitDeleteTask(request).task();
        }
        catch (IOException e) {
            String errorMessage = String.format("Could not create delete task for [%s] with query [%s]!", deletedItemIdentifier, query);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        this.waitUntilTaskIsFinished(taskId, deletedItemIdentifier);
        try {
            TaskResponse.Status taskStatus = this.getTaskResponse(taskId).getTaskStatus();
            LOG.debug("Deleted [{}] out of [{}] {}.", new Object[]{taskStatus.getDeleted(), taskStatus.getTotal(), deletedItemIdentifier});
            return taskStatus.getDeleted() > 0L;
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException(String.format("Error while trying to read Elasticsearch task status with ID: [%s]", taskId), (Throwable)e);
        }
    }
}

