/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import co.elastic.clients.elasticsearch.snapshot.CreateSnapshotRequest;
import co.elastic.clients.elasticsearch.snapshot.CreateSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.DeleteSnapshotRequest;
import co.elastic.clients.elasticsearch.snapshot.DeleteSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.SnapshotInfo;
import io.camunda.optimize.dto.optimize.rest.SnapshotState;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.repository.SnapshotRepository;
import io.camunda.optimize.service.util.SnapshotUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class SnapshotRepositoryES
implements SnapshotRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotRepositoryES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;

    public SnapshotRepositoryES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService) {
        this.esClient = esClient;
        this.configurationService = configurationService;
    }

    @Override
    public void deleteOptimizeSnapshots(Long backupId) {
        DeleteSnapshotRequest deleteSnapshotRequest = DeleteSnapshotRequest.of(b -> b.repository(this.configurationService.getElasticSearchConfiguration().getSnapshotRepositoryName()).snapshot(SnapshotUtil.getSnapshotPrefixWithBackupId(backupId) + "*"));
        this.getDeleteSnapshotActionListener(this.esClient.deleteSnapshotAsync(deleteSnapshotRequest), backupId);
    }

    @Override
    public void triggerSnapshot(String snapshotName, String[] indexNames) {
        LOG.info("Triggering async snapshot {}.", (Object)snapshotName);
        CreateSnapshotRequest createSnapshotRequest = CreateSnapshotRequest.of(b -> b.repository(this.configurationService.getElasticSearchConfiguration().getSnapshotRepositoryName()).snapshot(snapshotName).indices(Arrays.stream(indexNames).toList()).includeGlobalState(Boolean.valueOf(false)).waitForCompletion(Boolean.valueOf(true)));
        this.getCreateSnapshotActionListener(this.esClient.triggerSnapshotAsync(createSnapshotRequest), snapshotName);
    }

    private void getCreateSnapshotActionListener(CompletableFuture<CreateSnapshotResponse> future, String snapshotName) {
        future.whenComplete((v, e) -> {
            if (e != null) {
                if (e instanceof IOException) {
                    String reason = String.format("Encountered an error connecting to Elasticsearch while attempting to create snapshot [%s].", snapshotName);
                    LOG.error(reason, e);
                } else {
                    String reason = String.format("Failed to take snapshot [%s]", snapshotName);
                    LOG.error(reason, e);
                }
            } else {
                SnapshotInfo snapshotInfo = v.snapshot();
                switch (SnapshotState.valueOf((String)snapshotInfo.state())) {
                    case SUCCESS: {
                        LOG.info("Successfully taken snapshot [{}].", (Object)snapshotInfo.snapshot());
                        break;
                    }
                    case FAILED: 
                    case INCOMPATIBLE: {
                        String reason = String.format("Snapshot execution failed for [%s], reason: %s", snapshotInfo.snapshot(), snapshotInfo.reason());
                        LOG.error(reason);
                        break;
                    }
                    default: {
                        String reason = String.format("Snapshot status [%s] for snapshot with ID [%s]", snapshotInfo.state(), snapshotInfo.snapshot());
                        LOG.warn(reason);
                    }
                }
            }
        });
    }

    private void getDeleteSnapshotActionListener(CompletableFuture<DeleteSnapshotResponse> future, Long backupId) {
        future.whenComplete((v, e) -> {
            if (e != null) {
                if (e instanceof IOException) {
                    String reason = String.format("Encountered an error connecting to Elasticsearch while attempting to delete snapshots for backupID [%s].", backupId);
                    LOG.error(reason, e);
                } else {
                    String reason = String.format("Failed to delete snapshots for backupID [%s]", backupId);
                    LOG.error(reason, e);
                }
            } else if (v.acknowledged()) {
                String reason = String.format("Request to delete all Optimize snapshots with the backupID [%d] successfully submitted", backupId);
                LOG.info(reason);
            } else {
                String reason = String.format("Request to delete all Optimize snapshots with the backupID [%d] was not acknowledged by Elasticsearch.", backupId);
                LOG.error(reason);
            }
        });
    }
}

