/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.service;

import io.camunda.optimize.dto.optimize.query.report.single.configuration.custom_buckets.BucketUnit;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.custom_buckets.CustomBucketDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DurationUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.RoundingUtil;

public class DurationAggregationService {
    protected static final String DURATION_HISTOGRAM_AGGREGATION = "durationHistogram";
    protected static final int AUTOMATIC_BUCKET_LIMIT = 80;
    protected static final BucketUnit DEFAULT_UNIT = BucketUnit.MILLISECOND;
    protected static final DurationUnit FILTER_UNIT = DurationUnit.MILLIS;

    protected double getIntervalInMillis(double minValueInMillis, double maxValueInMillis, CustomBucketDto customBucketDto) {
        double interval;
        double distance = maxValueInMillis - minValueInMillis;
        if (customBucketDto.isActive()) {
            interval = customBucketDto.getBucketSizeInUnit(DEFAULT_UNIT).orElse(1.0);
        } else if (distance <= 80.0) {
            interval = 1.0;
        } else {
            int minimalInterval = (int)Math.ceil(distance / 80.0);
            interval = RoundingUtil.roundUpToNearestPowerOfTen(Double.valueOf(minimalInterval)).intValue();
        }
        return interval;
    }

    protected double getMinValueInMillis(MinMaxStatDto minMaxStats, CustomBucketDto customBucketDto) {
        if (customBucketDto.isActive()) {
            return customBucketDto.getBaselineInUnit(DEFAULT_UNIT).orElse(0.0);
        }
        return RoundingUtil.roundDownToNearestPowerOfTen(minMaxStats.getMin());
    }

    protected String[] getIndexNames(ExecutionContext<ProcessReportDataDto, ?> context) {
        return InstanceIndexUtil.getProcessInstanceIndexAliasNames((ProcessReportDataDto)context.getReportData());
    }
}

