/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.result;

import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.RawDataInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.MeasureDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.ResultType;
import io.camunda.optimize.service.export.CSVUtils;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;

public class RawDataCommandResult<T extends RawDataInstanceDto>
extends CommandEvaluationResult<List<T>> {
    public RawDataCommandResult(ReportDataDto reportData) {
        super(reportData);
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
    }

    public RawDataCommandResult(List<T> data, SingleReportDataDto reportData) {
        super(Collections.singletonList(MeasureDto.of(data)), (ReportDataDto)reportData);
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
    }

    public RawDataCommandResult() {
    }

    @Override
    public List<String[]> getResultAsCsv(Integer limit, Integer offset, ZoneId timezone) {
        return this.getResultAsCsv(limit, offset, timezone, true);
    }

    @Override
    public ResultType getType() {
        return ResultType.RAW;
    }

    public List<String[]> getResultAsCsv(Integer limit, Integer offset, ZoneId timezone, boolean includeNewVariables) {
        SingleReportDataDto singleReportData = this.getReportDataAs(SingleReportDataDto.class);
        List rawData = (List)this.getFirstMeasureData();
        if (rawData.isEmpty()) {
            return CSVUtils.mapRawProcessReportInstances(Collections.emptyList(), limit, offset, singleReportData.getConfiguration().getTableColumns(), true);
        }
        if (rawData.get(0) instanceof RawDataProcessInstanceDto) {
            List rawProcessData = rawData;
            rawProcessData.forEach(raw -> {
                raw.setStartDate(LocalDateUtil.atSameTimezoneOffsetDateTime((OffsetDateTime)raw.getStartDate(), (ZoneId)timezone));
                raw.setEndDate(LocalDateUtil.atSameTimezoneOffsetDateTime((OffsetDateTime)raw.getEndDate(), (ZoneId)timezone));
            });
            return CSVUtils.mapRawProcessReportInstances(rawProcessData, limit, offset, singleReportData.getConfiguration().getTableColumns(), includeNewVariables);
        }
        List rawDecisionData = rawData;
        rawDecisionData.forEach(raw -> raw.setEvaluationDateTime(LocalDateUtil.atSameTimezoneOffsetDateTime((OffsetDateTime)raw.getEvaluationDateTime(), (ZoneId)timezone)));
        return CSVUtils.mapRawDecisionReportInstances(rawDecisionData, limit, offset, singleReportData.getConfiguration().getTableColumns());
    }
}

