/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.util;

import io.camunda.optimize.dto.optimize.importing.DecisionInstanceDto;
import io.camunda.optimize.dto.optimize.importing.InputInstanceDto;
import io.camunda.optimize.dto.optimize.importing.OutputInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.InputVariableEntry;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.OutputVariableEntry;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.RawDataDecisionInstanceDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawDecisionDataResultDtoMapper {
    private static final List<Object> DEFAULT_OUTPUT_VARIABLE_VALUE = Collections.emptyList();
    private static final String DEFAULT_INPUT_VARIABLE_VALUE = "";
    private static final Logger LOG = LoggerFactory.getLogger(RawDecisionDataResultDtoMapper.class);

    public List<RawDataDecisionInstanceDto> mapFrom(List<DecisionInstanceDto> decisionInstanceDtos, Set<InputVariableEntry> allInputVariables, Set<OutputVariableEntry> allOutputVariables) {
        ArrayList<RawDataDecisionInstanceDto> rawData = new ArrayList<RawDataDecisionInstanceDto>();
        decisionInstanceDtos.forEach(decisionInstanceDto -> {
            allInputVariables.addAll(this.getInputVariables((DecisionInstanceDto)decisionInstanceDto));
            allOutputVariables.addAll(this.getOutputVariables((DecisionInstanceDto)decisionInstanceDto));
            RawDataDecisionInstanceDto dataEntry = this.convertToRawDataEntry((DecisionInstanceDto)decisionInstanceDto);
            rawData.add(dataEntry);
        });
        this.ensureEveryRawDataInstanceContainsAllVariables(rawData, allInputVariables, allOutputVariables);
        return rawData;
    }

    private void ensureEveryRawDataInstanceContainsAllVariables(List<RawDataDecisionInstanceDto> rawData, Set<InputVariableEntry> inputVariables, Set<OutputVariableEntry> outputVariables) {
        rawData.forEach(data -> {
            inputVariables.forEach(inputVariableEntry -> data.getInputVariables().putIfAbsent(inputVariableEntry.getId(), this.toDefaultInputVariable((InputVariableEntry)inputVariableEntry)));
            outputVariables.forEach(outputVariableEntry -> data.getOutputVariables().putIfAbsent(outputVariableEntry.getId(), this.toDefaultOutputVariable((OutputVariableEntry)outputVariableEntry)));
        });
    }

    private InputVariableEntry toDefaultInputVariable(InputVariableEntry inputVariableEntry) {
        inputVariableEntry.setValue((Object)DEFAULT_INPUT_VARIABLE_VALUE);
        return inputVariableEntry;
    }

    private OutputVariableEntry toDefaultOutputVariable(OutputVariableEntry outputVariableEntry) {
        outputVariableEntry.setValues(DEFAULT_OUTPUT_VARIABLE_VALUE);
        return outputVariableEntry;
    }

    private Set<InputVariableEntry> getInputVariables(DecisionInstanceDto decisionInstanceDto) {
        return decisionInstanceDto.getInputs().stream().map(inputInstanceDto -> new InputVariableEntry(inputInstanceDto.getClauseId(), inputInstanceDto.getClauseName(), inputInstanceDto.getType(), (Object)DEFAULT_INPUT_VARIABLE_VALUE)).collect(Collectors.toSet());
    }

    private Set<OutputVariableEntry> getOutputVariables(DecisionInstanceDto decisionInstanceDto) {
        return decisionInstanceDto.getOutputs().stream().map(outputInstanceDto -> new OutputVariableEntry(outputInstanceDto.getClauseId(), outputInstanceDto.getClauseName(), outputInstanceDto.getType(), DEFAULT_OUTPUT_VARIABLE_VALUE)).collect(Collectors.toSet());
    }

    private RawDataDecisionInstanceDto convertToRawDataEntry(DecisionInstanceDto decisionInstanceDto) {
        return new RawDataDecisionInstanceDto(decisionInstanceDto.getDecisionDefinitionKey(), decisionInstanceDto.getDecisionDefinitionId(), decisionInstanceDto.getDecisionInstanceId(), decisionInstanceDto.getProcessInstanceId(), decisionInstanceDto.getEvaluationDateTime(), decisionInstanceDto.getEngine(), decisionInstanceDto.getTenantId(), decisionInstanceDto.getInputs().stream().collect(Collectors.toMap(InputInstanceDto::getClauseId, this::mapToVariableEntry)), decisionInstanceDto.getOutputs().stream().collect(Collectors.toMap(OutputInstanceDto::getClauseId, this::mapToVariableEntry, (variableEntry, variableEntry2) -> {
            variableEntry.getValues().addAll(variableEntry2.getValues());
            return variableEntry;
        })));
    }

    private InputVariableEntry mapToVariableEntry(InputInstanceDto inputInstanceDto) {
        return new InputVariableEntry(inputInstanceDto.getClauseId(), inputInstanceDto.getClauseName(), inputInstanceDto.getType(), (Object)inputInstanceDto.getValue());
    }

    private OutputVariableEntry mapToVariableEntry(OutputInstanceDto outputInstanceDto) {
        return new OutputVariableEntry(outputInstanceDto.getClauseId(), outputInstanceDto.getClauseName(), outputInstanceDto.getType(), (Object)outputInstanceDto.getValue());
    }
}

