/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.plan.decision;

import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.TableColumnDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.InputVariableEntry;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.OutputVariableEntry;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.plan.decision.DecisionExecutionPlanInterpreter;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.export.CSVUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public interface RawDecisionInstanceDataGroupByNoneExecutionPlanInterpreter
extends DecisionExecutionPlanInterpreter {
    @Override
    default public Set<DecisionExecutionPlan> getSupportedExecutionPlans() {
        return Set.of(DecisionExecutionPlan.DECISION_RAW_DECISION_INSTANCE_DATA_GROUP_BY_NONE);
    }

    default public void addNewVariablesAndDtoFieldsToTableColumnConfig(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> executionContext, CommandEvaluationResult<Object> result) {
        List firstMeasureData = (List)result.getFirstMeasureData();
        List variableNames = firstMeasureData.stream().flatMap(rawDataDecisionInstanceDto -> rawDataDecisionInstanceDto.getInputVariables().values().stream()).map(this::getPrefixedInputVariableId).collect(Collectors.toList());
        variableNames.addAll(firstMeasureData.stream().flatMap(rawDataDecisionInstanceDto -> rawDataDecisionInstanceDto.getOutputVariables().values().stream()).map(this::getPrefixedOutputVariableId).toList());
        TableColumnDto tableColumns = executionContext.getReportData().getConfiguration().getTableColumns();
        tableColumns.addNewAndRemoveUnexpectedVariableColumns(variableNames);
        tableColumns.addDtoColumns(CSVUtils.extractAllDecisionInstanceDtoFieldKeys());
    }

    default public String getPrefixedInputVariableId(InputVariableEntry inputVariableEntry) {
        return "input:" + inputVariableEntry.getId();
    }

    default public String getPrefixedOutputVariableId(OutputVariableEntry outputVariableEntry) {
        return "output:" + outputVariableEntry.getId();
    }
}

