/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.distributedby.process.identity;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.AssigneeCandidateGroupService;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ProcessDistributedByIdentityInterpreterHelper {
    private final AssigneeCandidateGroupService assigneeCandidateGroupService;
    private final DefinitionService definitionService;
    private final LocalizationService localizationService;

    public ProcessDistributedByIdentityInterpreterHelper(AssigneeCandidateGroupService assigneeCandidateGroupService, DefinitionService definitionService, LocalizationService localizationService) {
        this.assigneeCandidateGroupService = assigneeCandidateGroupService;
        this.definitionService = definitionService;
        this.localizationService = localizationService;
    }

    public Set<String> getUserTaskIds(ProcessReportDataDto reportData) {
        return this.definitionService.extractUserTaskIdAndNames(reportData.getDefinitions().stream().map(definitionDto -> this.definitionService.getDefinition(DefinitionType.PROCESS, definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds())).filter(Optional::isPresent).map(Optional::get).map(ProcessDefinitionOptimizeDto.class::cast).collect(Collectors.toList())).keySet();
    }

    public String resolveIdentityName(String key, Supplier<IdentityType> identityTypeSupplier) {
        if ("unassignedUserTasks___".equals(key)) {
            return this.localizationService.getDefaultLocaleMessageForMissingAssigneeLabel();
        }
        return this.assigneeCandidateGroupService.getIdentityByIdAndType(key, identityTypeSupplier.get()).map(IdentityWithMetadataResponseDto::getName).orElse(key);
    }

    public void addEmptyMissingDistributedByResults(List<CompositeCommandResult.DistributedByResult> distributedByIdentityResultList, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Supplier<CompositeCommandResult.ViewResult> emptyViewResultSupplier) {
        context.getAllDistributedByKeysAndLabels().entrySet().stream().filter(entry -> distributedByIdentityResultList.stream().noneMatch(distributedByResult -> distributedByResult.getKey().equals(entry.getKey()))).map(entry -> CompositeCommandResult.DistributedByResult.createDistributedByResult((String)entry.getKey(), (String)entry.getValue(), (CompositeCommandResult.ViewResult)emptyViewResultSupplier.get())).forEach(distributedByIdentityResultList::add);
    }
}

